<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: rdf_entities_integrator_collection.php,v 1.1.2.2 2025/06/27 14:20:45 rtigero Exp $

namespace Pmb\ImportExport\Models\Integrators\RdfEntitiesIntegrators;

use collection;

class rdf_entities_integrator_collection extends rdf_entities_integrator_authority
{
	protected $table_name = 'collections';

	protected $table_key = 'collection_id';

	protected $ppersos_prefix = 'collection';

	protected function init_map_fields()
	{
		$this->map_fields = array_merge(parent::init_map_fields(), array(
			'http://www.pmbservices.fr/ontology#website' => 'collection_web',
			'http://www.pmbservices.fr/ontology#label' => 'collection_name',
			'http://www.pmbservices.fr/ontology#issn' => 'collection_issn'
		));
		return $this->map_fields;
	}

	protected function init_foreign_fields()
	{
		$this->foreign_fields = array_merge(parent::init_foreign_fields(), array(
			'http://www.pmbservices.fr/ontology#has_publisher' => 'collection_parent'
		));
		return $this->foreign_fields;
	}

	protected function init_linked_entities()
	{
		$this->linked_entities = array_merge(parent::init_linked_entities(), array(
			'http://www.pmbservices.fr/ontology#has_concept' => array(
				'table' => 'index_concept',
				'reference_field_name' => 'num_object',
				'external_field_name' => 'num_concept',
				'other_fields' => array(
					'type_object' => TYPE_COLLECTION
				)
			)
		));
		return $this->linked_entities;
	}

	protected function init_special_fields()
	{
		$this->special_fields = array_merge(parent::init_special_fields(), array(
			'http://www.pmbservices.fr/ontology#thumbnail_url' => array(
				"method" => array($this, "insert_thumbnail_url"),
				"arguments" => array(AUT_TABLE_COLLECTIONS)
			),
		));
		return $this->special_fields;
	}

	protected function post_create($uri)
	{
		// Audit
		if ($this->integration_type && $this->entity_id) {
			$query = 'insert into audit (type_obj, object_id, user_id, type_modif, info, type_user) ';
			$query .= 'values ("' . AUDIT_COLLECTION . '", "' . $this->entity_id . '", "' . $this->contributor_id . '", "' . $this->integration_type . '", "' . $this->create_audit_comment($uri) . '", "' . $this->contributor_type . '")';
			pmb_mysql_query($query);
			// Indexation
			collection::update_index($this->entity_id);
		}
	}
}
