<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ChunkXMLOAI.php,v 1.1.2.2 2025/06/27 14:21:05 rtigero Exp $

namespace Pmb\ImportExport\Models\Chunks\ChunkXML\ChunkXMLOAI;

use Pmb\ImportExport\Models\Chunks\ChunkXML\ChunkXML;
use XMLReader;

class ChunkXMLOAI extends ChunkXML
{
    private const RESUMPTION_TOKEN = "resumptionToken";
    private const REQUEST = "request";

    private $resumptionToken = "";
    private $request = "";

    public function next()
    {
        $this->initialize();

        $opened = $this->xmlReader->open($this->uri, null, LIBXML_NOBLANKS);
        if (!$opened) {
            yield null;
        }

        $currentContent = '';

        while ($this->xmlReader->read()) {

            if ($this->xmlReader->nodeType === XMLReader::ELEMENT) {
                array_push($this->currentNodePath, $this->xmlReader->name);
            }
            if ($this->xmlReader->nodeType === XMLReader::END_ELEMENT) {
                array_pop($this->currentNodePath);
            }

            $path = '/' . implode('/', $this->currentNodePath);
            $name = $this->xmlReader->name;

            //On tente de rcuprer un rsumption token s'il y en a un
            if ($this->xmlReader->nodeType === XMLReader::ELEMENT && $name == self::RESUMPTION_TOKEN) {
                $this->resumptionToken = $this->xmlReader->readInnerXML();
            }

            //On tente de rcuprer l'URL depuis l'OAI
            if ($this->xmlReader->nodeType === XMLReader::ELEMENT && $name == self::REQUEST) {
                $this->request = $this->xmlReader->readInnerXML();
            }

            if ($this->xmlReader->nodeType === XMLReader::ELEMENT && in_array($name, $this->entities)) {
                $content = $this->xmlReader->readOuterXML();
                $currentContent .= $this->parameters["cleanHTML"] ? $this->cleanHTML($content) : $content;
                yield $this->xmlHeader . $currentContent;
                $currentContent = '';
            }

            if ($this->xmlReader->nodeType === XMLReader::ELEMENT && in_array($path, $this->entities)) {
                $content = $this->xmlReader->readOuterXML();
                $currentContent .= $this->parameters["cleanHTML"] ? $this->cleanHTML($content) : $content;
                yield $this->xmlHeader . $currentContent;
                $currentContent = '';
            }
        }

        //Gestion rcursive du resumptionToken pour tout rcuprer
        if (! empty($this->resumptionToken)) {
            $this->isInitialized = false;
            //On gre ici le flag keepUrl
            $this->resource["uri"] = $this->parameters["keepUrl"] ? $this->parameters["url"] : $this->request . "?verb=ListRecords&" . self::RESUMPTION_TOKEN . "=" . $this->resumptionToken;
            foreach ($this->next() as $next) {
                yield $next;
            }
            $this->resumptionToken = "";
        }

        $this->xmlReader->close();
    }

    protected function initialize()
    {
        if ($this->isInitialized) {
            return;
        }
        if (empty($this->resumptionToken)) {
            $this->resource["uri"] = $this->parameters["url"] . "?verb=ListRecords&metadataPrefix=" . $this->parameters["OAIMetadataFormat"];
            if (! empty($this->parameters["OAISet"])) {
                $this->resource["uri"] .= "&set=" . $this->parameters["OAISet"];
            }
        }
        parent::initialize();
    }
}
