<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ProfilesImportEntitiesController.php,v 1.4.2.2 2025/06/27 14:20:45 rtigero Exp $

namespace Pmb\ImportExport\Controller;

use Pmb\ImportExport\Models\Profiles\ProfileEntity;
use Pmb\ImportExport\Orm\ProfileEntityOrm;

class ProfilesImportEntitiesController extends ImportExportController
{

    protected const VUE_NAME = "importexport/profilesImportEntities";

    public function proceed()
    {
        switch ($this->data->action) {
            case 'edit':
                $this->editAction();
                break;
            default:
                $this->defaultAction();
                break;
        }
    }

    protected function defaultAction()
    {
        $ProfileEntity = new ProfileEntity();
        $this->render([
            "list" => $ProfileEntity->getList(),
        ]);
    }

    protected function editAction()
    {
        global $id;

        $id = intval($id);
        if (ProfileEntityOrm::exist($id)) {
            $this->render($this->getFormData($id));
        } else {
            $this->render($this->getFormData());
        }
    }

    /**
     * Recuperation donnees formulaire ajout/edition
     *
     * @param int $id
     * @return array[]
     */
    protected function getFormData($id = 0)
    {
        $data = array();

        $data['entity'] = new ProfileEntity($id);
        return $data;
    }

    public function save()
    {
        if (!empty($this->data->numProfile)) {
            $ProfileEntity = new ProfileEntity($this->data->id);
            $ProfileEntity->numProfile = $this->data->numProfile;
            $ProfileEntity->setFromForm($this->data);
            $ProfileEntity->save();
            $this->ajaxJsonResponse($ProfileEntity);
        }
    }

    public function remove()
    {

        $ProfileEntity = new ProfileEntity($this->data->id);
        $ProfileEntity->remove();
        $this->ajaxJsonResponse(['success' => true]);
    }
}
