<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ProfilesExportController.php,v 1.5.2.2 2025/06/27 14:20:45 rtigero Exp $

namespace Pmb\ImportExport\Controller;

use Pmb\ImportExport\Models\ImportExportParserDirectory;
use Pmb\ImportExport\Models\Profiles\ProfileExport;
use Pmb\ImportExport\Orm\ProfileOrm;

class ProfilesExportController extends ImportExportController
{

    protected const VUE_NAME = "importexport/profilesExport";

    protected function getBreadcrumb(): string
    {
        global $msg, $action, $id;
        $breadcrum = "{$msg['imports_exports_profiles']} {$msg['menu_separator']} {$msg['imports_exports_profiles_export']}";

        if (isset($action) && $action == "edit" && isset($id)) {
            if (ProfileOrm::exist($id)) {
                $profile = ProfileOrm::findById($id);
                $breadcrum .= " {$msg['menu_separator']} {$profile->profile_name}";
            }
        }

        return $breadcrum;
    }

    public function proceed()
    {
        switch ($this->data->action) {
            case 'edit':
                $this->editAction();
                break;
            default:
                $this->defaultAction();
                break;
        }
    }

    protected function defaultAction()
    {
        $ProfileExport = new ProfileExport();
        $this->render([
            "list" => $ProfileExport->getList(),
        ]);
    }

    protected function editAction()
    {
        global $id;

        $id = intval($id);
        if (ProfileOrm::exist($id)) {
            $this->render($this->getFormData($id));
        } else {
            $this->render($this->getFormData());
        }
    }

    /**
     * Recuperation donnees formulaire ajout/edition
     *
     * @param int $id
     * @return array[]
     */
    protected function getFormData($id = 0)
    {
        $data = array();

        $data['profile'] = new ProfileExport($id);
        return $data;
    }

    public function save()
    {
        $ProfileExport = new ProfileExport($this->data->id);
        $ProfileExport->setFromForm($this->data);
        $ProfileExport->save();
        $this->ajaxJsonResponse($ProfileExport);
    }

    public function remove()
    {

        $ProfileExport = new ProfileExport($this->data->id);
        $ProfileExport->remove();
        $this->ajaxJsonResponse(['success' => true]);
    }

    public function getDeduplicationFunctions()
    {
        $result = array();

        $parser = ImportExportParserDirectory::getInstance();
        $manifests = $parser->getManifests("Pmb/ImportExport/Models/Profiles/DeduplicationFunctions");
        foreach ($manifests as $manifest) {
            // $compatibility = $parser->getCompatibility($transformerManifest->namespace);
            $result[] = array(
                "namespace" => $manifest->namespace,
                "name" => $manifest->name,
                "msg" =>  $manifest->namespace::getMessages()
            );
        }

        $this->ajaxJsonResponse($result);
    }

    public function duplicate()
    {
        $id = ($this->data->id) ?? 0;
        if (!$id || !ProfileOrm::exist($id)) {
            $this->ajaxError('unknown profile');
        }

        $profile = new ProfileExport($this->data->id);
        $newProfile = $profile->duplicate();
        $this->ajaxJsonResponse($newProfile);
    }
}
