<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: ExplnumsController.php,v 1.8.2.2 2025/06/12 09:13:53 rtigero Exp $

namespace Pmb\Docnums\Controller;

use Pmb\Common\Controller\Controller;
use Pmb\Docnums\Models\Collection;
use Pmb\Docnums\Models\Explnum;

class ExplnumsController extends Controller
{
    public function import(int $numCollection)
    {
        global $id_rep, $explnum_collection;

        $explnums = array();
        $collection = new Collection($numCollection);
        $explnum_collection = $numCollection;
        $id_rep = $collection->uploadFolderId;

        foreach ($_FILES as $file) {
            if (! $file["error"]) {
                $newExplnum = new Explnum();
                $newExplnum->collectionId = $numCollection;
                $newExplnum->importFromFile($file);
                //On retire les binaires car ca ne plait pas a vuejs
                $newExplnum->explnum_vignette = "";
                $newExplnum->explnumCollections->explnumCollectionsExplnumsVignette = "";
                $newExplnum->explnum_data = "";
                $newExplnum->explnumCollections->explnumCollectionsExplnumsData = "";
                $newExplnum->infos_docnum = array();
                $explnums[] = $newExplnum;
            }
        }

        $this->ajaxJsonResponse($explnums);
    }

    public function getForm(int $numExplnum, int $numCollection)
    {
        global $collectionId;

        $collectionId = $numCollection;

        $explnum = new Explnum($numExplnum);

        $baseUrl = "./catalog.php?categ=docnum_collections&sub=";
        $actionUrl = "{$baseUrl}add&action=save";
        $deleteUrl = "";
        $cancelUrl = ""; // Peut tre dfini si ncessaire

        if ($numExplnum > 0) {
            $actionUrl = "{$baseUrl}edit&action=save&id={$numExplnum}";
            $deleteUrl = "{$baseUrl}edit&action=delete&id={$numExplnum}";
        }

        $this->ajaxResponse($explnum->explnum_form(
            $actionUrl,
            $cancelUrl,
            $deleteUrl
        ));
    }

    public function delete(int $idExplnum)
    {
        $explnum = new Explnum($idExplnum);
        $explnum->delete();

        $this->ajaxJsonResponse([
            "error" => false
        ]);
    }

    public function getExplnum(int $idExplnum)
    {
        $explnum = new Explnum($idExplnum);
        $explnum->explnum_data = "";
        $explnum->explnum_vignette = "";
        $explnum->explnumCollections->explnumCollectionsExplnumsData = "";
        $explnum->explnumCollections->explnumCollectionsExplnumsVignette = "";
        $this->ajaxJsonResponse($explnum);
    }

    public function associate(string $type, int $numEntity)
    {
        foreach ($this->data->explnums as $explnumId) {
            $collectionExplnum = new Explnum($explnumId);
            $explnum = $collectionExplnum->createNoticeExplnum($numEntity, $type, $this->data->settings);

            if ($explnum->explnum_id == 0) {
                $this->ajaxError("Unable to create explnum");
            }

            //On supprime l'exemplaire de la collection en gardant le fichier evidemment
            $collectionExplnum->delete(true);
        }
        $this->ajaxJsonResponse(true);
    }

    public function getExplnumLicenceProfiles(int $numLicence)
    {
        if ($numLicence == 0) {
            $this->ajaxError("Invalid profile id");
        }
        $this->ajaxJsonResponse(Explnum::getExplnumLicenceProfiles($numLicence));
    }
}
