<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: DiffusionsController.php,v 1.14.6.2.2.1 2025/10/30 13:23:25 rtigero Exp $
namespace Pmb\DSI\Opac\Controller;

use Pmb\Common\Opac\Controller\Controller;
use Pmb\DSI\Models\Diffusion;
use Pmb\DSI\Models\SubscriberList\RootSubscriberList;
use Pmb\DSI\Models\SubscriberList\Subscribers\Subscriber;
use Pmb\DSI\Opac\Models\OpacDiffusions;
use Pmb\DSI\Opac\Views\AlertsView;
use Pmb\DSI\Opac\Views\UnsubscribeView;
use Pmb\DSI\Orm\DiffusionOrm;

class DiffusionsController extends Controller
{

	protected $action;

	protected $empr;

	protected $opacDiffusions;

	public function __construct(object $data = null)
	{
		parent::__construct($data);
		if ($this->data->id) {
			$this->empr = new \emprunteur(intval($this->data->id));
		}
		$this->opacDiffusions = new OpacDiffusions($this->data->id ?? 0);
	}

	public function proceed($action = "")
	{
		switch ($action) {
			case "unsubscribe":
				$viewData = [
					"diffusion" => null
				];
				if (! DiffusionOrm::exist($this->data->idDiffusion)) {
					$view = new UnsubscribeView("dsi/unsubscribe", $viewData);
					print $view->render();
					exit();
				}
				$diffusion = new Diffusion($this->data->idDiffusion);
				$id = $this->data->idEmpr ?? $this->data->id;
				$viewData["diffusion"] = $diffusion;

				if ($id) {
					$view = new UnsubscribeView("dsi/unsubscribe", $viewData);

					//Cas d'une DSI prive, on supprime la diffusion  la dsinscription
					if ($diffusion->settings->idEmpr == $id) {
						$diffusion->delete();
						print $view->render();
						exit();
					}
					$diffusion->fetchSubscriberList();
					RootSubscriberList::unsubscribe($diffusion, $id, $this->data->emprType);
					print $view->render();
				}
				break;
			case "bannette":
				$opacDiffusions = $this->getOpacDiffusions();
				$opacDiffusionsPrivate = $this->getOpacDiffusionsPrivate();

				$subscriber = $this->getSubscriberFromType();

				$viewData = [
					"list" => $opacDiffusions,
					"listPrivate" => $opacDiffusionsPrivate,
					"subscriber" => $subscriber,
					"emprType" => $this->data->emprType
				];
				$view = new AlertsView("dsi/alerts", $viewData);
				print $view->render();
				break;
			default:
				return;
		}
	}

	public function getSubscriberFromType()
	{
		return $this->opacDiffusions->getSubscriberFromType($this->data->emprType, $this->data->id);
	}

	private function getOpacDiffusions()
	{
		return $this->opacDiffusions->getOpacDiffusions();
	}

	private function getOpacDiffusionsPrivate()
	{
		return $this->opacDiffusions->getOpacDiffusionsPrivate($this->data->emprType);
	}

	/**
	 * Vrifie si un emprunteur est est base pour une entite donne
	 *
	 * @param $entityType int
	 * @param $entityId int
	 * @return Subscriber | null
	 */
	public function getSubscriberFromEntity($entityType, $entityId)
	{
		return $this->opacDiffusions->getSubscriberFromEntity($entityType, $entityId);
	}
}
