<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HashModel.php,v 1.2.14.1 2025/07/10 08:29:31 jparis Exp $
namespace Pmb\Common\Helper;

class HashModel
{

    /**
     *
     * @var string
     */
    private const PHRASE_SECRET = "";

    /**
     * Hash gnrer pour chaque client
     *
     * @var string
     */
    private $key_secret;

    public function __construct()
    {
        $query = "SELECT valeur_param FROM parametres WHERE type_param='pmb' AND sstype_param='hash_key_secret'";
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            $row = pmb_mysql_fetch_assoc($result);
            $this->key_secret = $row['valeur_param'];
        } else {
            throw new \Exception("No secret key found");
        }
    }

    /**
     *
     * @param string $param
     * @return string
     */
    public function generateHash(string $param)
    {
        return sha1($param . self::PHRASE_SECRET . $this->key_secret);
    }

    /**
     *
     * @param string $hash
     * @param string $barcode
     * @return boolean
     */
    public function verifeHash(string $hash, string $barcode)
    {
        $newHash = $this->generateHash($barcode);
        if ($newHash === $hash) {
            return true;
        }
        return false;
    }

    /**
     * Gnration d'un hash pour le point d'entre getimage.php
     *
     * @param string $urlImages
     * @param string $urlVign
     * @return string
     */
    public function generateHashForGetImage(string $urlImages = "", string $urlVign = ""): string
    {
        return $this->generateHash($this->generateStringForGetImage($urlImages, $urlVign));
    }

    /**
     * Gnration d'une chaine pour le point d'entre getimage.php
     *
     * @param string $urlImages
     * @param string $urlVign
     * @return string
     */
    public function generateStringForGetImage(string $urlImages = "", string $urlVign = ""): string
    {
        if (empty($urlImages) && empty($urlVign)) {
            return "";
        }

        $urlImages = urldecode($urlImages);
        $urlVign = urldecode($urlVign);

        if (empty($urlImages)) {
            $url = $urlVign;
        } else if (empty($urlVign)) {
            $url = $urlImages;
        } else {
            $url = "{$urlImages};{$urlVign}";
        }

        $url = trim($url, ';');

        return $url;
    }
}