<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SharedListModel.php,v 1.1.2.4.4.1 2025/04/11 08:58:47 qvarin Exp $

namespace Pmb\AI\Models;

use Pmb\AI\Orm\AiSharedListOrm;
use Pmb\Common\Models\Model;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class SharedListModel extends Model
{
    public const ID_CONFIG_SHARED_LIST = 1;

    /**
     * Rcupre les donnes de paramtrage.
     *
     * @return array
     */
    public static function getSharedListData()
    {
        if (empty(AiSharedListOrm::findAll())) {
            return [];
        }
        $aiSettingsOrm = new AiSharedListOrm(self::ID_CONFIG_SHARED_LIST);
        return $aiSettingsOrm->getAiSharedList();
    }
}
