<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: Lexia.php,v 1.1.2.8.2.1 2025/12/02 08:07:10 gneveu Exp $

namespace Pmb\AI\Library\Services\Pmb;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

use encoding_normalize;
use Pmb\AI\Library\Services\Agent;
use Pmb\AI\Library\Services\AgentUtils;

class Lexia implements Agent
{
    use AgentUtils;
    /**
     * URL de la verification du token
     */
    public const CHECK_TOKEN_URL = '/check_token';

    /**
     * URL de la verification du token
     */
    public const URL_EMBEDDINGS = '/embeddings';

    /**
     * URL
     */
    public const URL_CHAT = '/chat';

    /**
     * Parameters
     */
    private $parameters;

    /**
     * Set parameters
     *
     * @param array $parameters
     * @return void
     */
    public function setParameters(array $parameters): void
    {
        $this->parameters = $parameters;
    }

    /**
     * Get parameters
     *
     * @return array
     */
    public function getParameters(): array
    {
        return $this->parameters;
    }

    /**
     * Convert text to embeddings
     *
     * @param string|array  $text
     * @return array
     */
    public function textToEmbeddings(string|array $text): array
    {
        $headers = [];
        $headers['Content-Type'] = 'application/json';
        $headers['x-auth-token'] = $this->parameters['auth_token'];
        $headers['Expect'] = '';
        $embeddingSend = [
            "input" => $text,
        ];

        $response = $this->post($this->parameters['url_server_python'] . self::URL_EMBEDDINGS, $headers, encoding_normalize::json_encode($embeddingSend));
        if ($response->headers['Status-Code'] == 200) {
            $response = json_decode($response->body, true);
            $plop = json_decode($response["data"], true);
            foreach ($plop as $key => $value) {
                $data["embedding"][$key] = $value;
            }
            return $data["embedding"];
        }
        return [];
    }

    /**
     * Chat
     *
     * @param string $promptSystem
     * @param string $promptUser
     * @return string
     */
    public function chat(string $promptSystem, string $promptUser): string
    {
        $headers = [];
        $headers['Content-Type'] = 'application/json';
        $headers['x-auth-token'] = $this->parameters['auth_token'];
        $headers['Expect'] = '';

        $data = [
            "messages" => [
                [
                    "role" => "system",
                    "content" => $promptSystem
                ],
                [
                    "role" => "user",
                    "content" => $promptUser
                ]
            ],
        ];

        $response = $this->post($this->parameters['url_server_python'] . self::URL_CHAT, $headers, encoding_normalize::json_encode($data));
        if (($response instanceof \CurlResponse) && $response->headers['Status-Code'] == 200) {
            $response = encoding_normalize::json_decode($response->body, true);
            return $response["response"];
        }
        return "";
    }

    public function validateToken(array $parameters): bool
    {
        $headers = [];
        $headers['Content-Type'] = 'application/json';
        $headers['x-auth-token'] = $parameters['auth_token'] ?? $parameters['token'];
        $headers['Expect'] = '';
        $response = $this->post($parameters['url'] . self::CHECK_TOKEN_URL, $headers);
        if ($response->headers['Status-Code'] != 200) {
            return false;
        }
        return true;
    }

    /**
     * Check parameters
     *
     * @param array $parameters
     * @return bool
     */
    public function checkParameters(array $parameters): bool
    {
        if (isset($parameters['auth_token'], $parameters['url_server_python'])) {
            return $this->validateToken($parameters['auth_token'], $parameters['url_server_python']);
        }
        return false;
    }
}
