<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: TextChunker.php,v 1.1.2.5 2025/04/11 07:36:26 qvarin Exp $

namespace Pmb\AI\Library\Chunker;

if (stristr($_SERVER['REQUEST_URI'], '/'.basename(__FILE__))) {
    die("no access");
}

class TextChunker implements Chunker
{
    /**
     * Le nombre maximum de phrase par chunk
     *
     * @var int
     */
    public const MAX_SENTENCE = 20;

    /**
     * Chunk
     *
     * @param string $text
     * @return array<int, array{offset: int, length: int, data: string}>
     */
    public function chunk(string $text): array
    {
        // Decoupage sur la ponctuation
        $sentences = preg_split('/ *[\.\?!][\'"\)\]]* */', $text);
        if (false === $sentences) {
            return [];
        }

        // Creation des chunks
        $chunks = array_chunk($sentences, self::MAX_SENTENCE);
        $chunks = array_map(fn ($chunk) => implode(' ', $chunk), $chunks);

        $result = [];
        $offset = 0;

        for ($i = 0, $count = count($chunks); $i < $count; $i++) {
            $chunk = $chunks[$i];

            $length = strlen($chunk);
            // Tant que le chunk suivant est vide, on l'ajoute dans le chunk courant
            // On evite de faire des index de chunk vide
            while (isset($chunks[$i + 1]) && empty(trim($chunks[$i + 1]))) {
                $length += strlen($chunks[$i + 1]);
                $i++;
            }

            $result[] = [
                'offset' => $offset,
                'length' => $length,
                'data' => $chunk
            ];

            $offset += $length;
        }

        return $result;
    }
}
