<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AiAPIController.php,v 1.3.6.3 2025/04/11 12:51:46 qvarin Exp $

namespace Pmb\AI\Controller;

use encoding_normalize;
use Pmb\AI\Library\Api;
use Pmb\AI\Library\Source\Semantic;
use Pmb\AI\Orm\AISettingsOrm;
use Pmb\Common\Controller\Controller;
use Pmb\Common\Helper\UrlEntities;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class AiAPIController extends Controller
{
    public $action = "list";

    public function proceed($action = "")
    {
        $this->action = $action;

        switch ($action) {
            case 'semantic_chat_catalog':
                $this->semanticChatCatalogAction();
                break;
            default:
                $this->ajaxError('No action', 400);
                break;
        }
    }

    public function semanticChatCatalogAction()
    {
        try {
            $aiSettings = AISettingsOrm::fetchActiveAiSettings();
            if (empty($aiSettings)) {
                throw new \Exception('No active AI settings');
            }
        } catch (\Exception $e) {
            $this->ajaxError($e->getMessage(), 500);
        }

        $_SESSION["ai_search_semantic_index"] = array_filter($_SESSION["ai_search_semantic_index"], function ($semantic_search) {
            return $semantic_search['time'] >= strtotime('-1 day');
        });

        $semantic = new Semantic($aiSettings);
        $sessionInfos = $_SESSION["ai_search_semantic_index"][$this->data->session_index] ?? [];
        if (empty($sessionInfos) || !is_array($sessionInfos)) {
            $this->ajaxError('No index list', 400);
        }

        if (isset($sessionInfos["response"])) {
            $this->ajaxJsonResponse([
                'response' => $sessionInfos["response"]
            ]);
        }

        $content = $semantic->textGeneration($sessionInfos['semantic_query'], $sessionInfos['index_list']);
        if (empty($content)) {
            $this->ajaxError('API error', 500);
        }

        $content = nl2br($content);
        $content = $this->parseAiResponse($content, $sessionInfos['index_list']);
        $content = strip_tags($content, "<a><br>");

        $_SESSION["ai_search_semantic_index"][$this->data->session_index]["response"] = $content;
        $this->ajaxJsonResponse(['response' => $content]);
    }
    /**
     * Parse AI response
     *
     * @param string $content
     * @param array $indexList
     * @return string
     */
    protected function parseAiResponse(string $content, array $indexList): string
    {
        return preg_replace_callback("(#(\d+))", function ($matches) use ($indexList) {
            global $charset;

            [$pattern, $num] = $matches;

            $noticeId = intval($indexList[$num - 1]["object_id"] ?? 0);
            if (empty($noticeId)) {
                return "";
            }

            $notice = new \record_datas($noticeId);
            $lien = UrlEntities::getRealPermalink(TYPE_NOTICE, intval($noticeId));
            return "<a href='$lien' target='_blank' title='" . htmlentities($notice->get_tit1(), ENT_QUOTES, $charset) . "'>
                        ". htmlentities($pattern, ENT_QUOTES, $charset) ."
                    </a>";
        }, $content);
    }
}
