<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: parametres_perso.class.php,v 1.64.4.17 2025/12/17 15:44:56 dgoron Exp $


if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

//Gestion des champs personnaliss simplifie pour l'OPAC
global $class_path, $include_path;

use Pmb\Common\Helper\Helper;

require_once $include_path."/parser.inc.php";
require_once $include_path."/fields_empr.inc.php";
require_once $include_path."/datatype.inc.php";
require_once $class_path."/translation.class.php";

class parametres_perso {

	public $prefix;

	public $no_special_fields;

    public $error_message;

	public $values;

	public $list_values = null;

	public static $fields = array();
	public static $st_fields = array();
	protected static $out_values = array();
	public $t_fields = array();
	public static $st_prefix = '';

	//Crateur : passer dans $prefix le type de champs persos et dans $base_url l'url a appeller pour les formulaires de gestion
	public function __construct($prefix) {
		global $_custom_prefixe_, $charset;

		// Lecture des champs
		$this->no_special_fields = 0;
		$this->t_fields = array();

		$prefix = Helper::getPrefixCustomTable($prefix);
		if ($prefix === false) {
			$this->no_special_fields = 1;
			return;
		}

		$this->prefix = $prefix;
		$_custom_prefixe_ = $prefix;
		self::$st_prefix = $this->prefix;
		if (!isset(self::$st_fields[$this->prefix])) {
			$requete = "SELECT idchamp, name, titre, type, datatype, obligatoire, options, multiple, search, export, opac_sort, comment, pond FROM " . $this->prefix . "_custom ORDER BY ordre";
			$resultat = pmb_mysql_query($requete);
			if (pmb_mysql_num_rows($resultat) == 0) {
				self::$st_fields[self::$st_prefix] = false;
			} else {
				while ($r = pmb_mysql_fetch_object($resultat)) {
					self::$st_fields[self::$st_prefix][$r->idchamp]["idchamp"] = $r->idchamp;
					self::$st_fields[self::$st_prefix][$r->idchamp]["DATATYPE"] = $r->datatype;
					self::$st_fields[self::$st_prefix][$r->idchamp]["NAME"] = $r->name;
					self::$st_fields[self::$st_prefix][$r->idchamp]["TITRE"] = translation::get_text($r->idchamp, $this->prefix."_custom", 'titre', $r->titre);
					self::$st_fields[self::$st_prefix][$r->idchamp]["TYPE"] = $r->type;
					self::$st_fields[self::$st_prefix][$r->idchamp]["OPTIONS"][0] = _parser_text_no_function_("<?xml version='1.0' encoding='".$charset."'?>\n".$r->options, "OPTIONS");
					if (!isset(self::$st_fields[self::$st_prefix][$r->idchamp]["OPTIONS"][0]["REPEATABLE"][0]["value"])) {
						self::$st_fields[self::$st_prefix][$r->idchamp]["OPTIONS"][0]["REPEATABLE"][0]["value"] = 0;
					}
					self::$st_fields[self::$st_prefix][$r->idchamp]["MANDATORY"] = $r->obligatoire;
					self::$st_fields[self::$st_prefix][$r->idchamp]["OPAC_SHOW"] = $r->multiple;
					self::$st_fields[self::$st_prefix][$r->idchamp]["SEARCH"] = $r->search;
					self::$st_fields[self::$st_prefix][$r->idchamp]["EXPORT"] = $r->export;
					self::$st_fields[self::$st_prefix][$r->idchamp]["OPAC_SORT"] = $r->opac_sort;
					self::$st_fields[self::$st_prefix][$r->idchamp]["COMMENT"] = $r->comment;
					self::$st_fields[self::$st_prefix][$r->idchamp]["POND"] = $r->pond;
					self::$st_fields[self::$st_prefix][$r->idchamp]["GROUP"] = $this->get_custom_field_group_from_id($r->idchamp);
				}
			}
		}
		if (self::$st_fields[self::$st_prefix] == false) {
			$this->no_special_fields = 1;
		} else {
			$this->t_fields = self::$st_fields[self::$st_prefix];
		}
	}

	public function get_custom_field_group_from_id($idchamp)
	{
	    $custom_fields_groups = custom_fields_groups::get_instance($this->prefix);
	    $group = $custom_fields_groups->find_group($idchamp);
	    if (is_object($group)) {
	        return $group;
	    }
	    return null;
	}

	protected function get_selected_group($idchamp = 0)
	{
	    $group = $this->get_custom_field_group_from_id($idchamp);
	    if (is_object($group)) {
	        return $group->get_id();
	    }
	    return 0;
	}

	protected function _sort_values_by_format_values($a, $b)
	{
		if($a['order'] != $b['order']) {
			return ($a['order'] < $b['order']) ? -1 : 1;
		}
		if (strtolower(strip_tags($a['format_value'])) == strtolower(strip_tags($b['format_value']))) {
			return 0;
		}
		return (strtolower(strip_tags($a['format_value'])) < strtolower(strip_tags($b['format_value']))) ? -1 : 1;
	}

	protected function sort_values($fields)
	{
		$values = array();
		foreach ($fields as $field_id=>$field_values) {
			uasort($field_values, array($this, '_sort_values_by_format_values'));
			$values[$field_id] = array();
			foreach ($field_values as $value) {
				$values[$field_id][] = $value['value'];
			}
		}
		return $values;
	}

	// Retourne la requte SQL des valeurs stockes dans les base pour un emprunteur ou autre
	protected function _get_query_values($id)
	{
	    $id = intval($id);
	    return "select ".$this->prefix."_custom_champ,".$this->prefix."_custom_origine,".$this->prefix."_custom_small_text, ".$this->prefix."_custom_text, ".$this->prefix."_custom_integer, ".$this->prefix."_custom_date, ".$this->prefix."_custom_float, ".$this->prefix."_custom_order from ".$this->prefix."_custom_values where ".$this->prefix."_custom_origine=".$id;
	}

	public function add_grouped_values()
	{
	    foreach ($this->values as $custom_id=>$custom_values) {
	        //Est-il dans un groupe ?
	        $custom_field_group = $this->get_custom_field_group_from_id($custom_id);
	        if (is_object($custom_field_group)) {
	            $group_name = $custom_field_group->get_name();
	            if (empty($this->values[$group_name])) {
	                $this->values[$group_name] = array();
	                $this->values[$group_name]['name'] = $group_name;
	                $this->values[$group_name]['label'] = $custom_field_group->get_translated_title();
	                $this->values[$group_name]['id'] = $custom_field_group->get_id();
	                $this->values[$group_name]['values'] = array();
	            }
	            if (!empty($custom_values)) {
	                foreach ($custom_values as $custom_key=>$custom_value) {
	                    if (empty($this->values[$group_name]['values'][$custom_key])) {
	                        $this->values[$group_name]['values'][$custom_key] = array();
	                    }
	                    $this->values[$group_name]['values'][$custom_key][] = array(
	                        'id' => $custom_id,
	                        'value' => $custom_value

	                    );
	                }
	            }
	        }
	    }
	}

	public function get_st_prefix()
	{
	    return $this->prefix;
	}
	
	//Rcupration des valeurs stockes dans les base pour un emprunteur ou autre
	public function get_values($id)
	{
        $id = intval($id);
		//Rcupration des valeurs stockes
		$this->values = $this->list_values = array();

		if ((!$this->no_special_fields)&&($id)) {
			$requete=$this->_get_query_values($id);
			$resultat=pmb_mysql_query($requete);
			if(pmb_mysql_num_rows($resultat)) {
				$values = array();
				while ($r=pmb_mysql_fetch_array($resultat)) {
					$values[$r[$this->prefix."_custom_champ"]][]=array(
						'value' => $r[$this->prefix."_custom_".$this->t_fields[$r[$this->prefix."_custom_champ"]]["DATATYPE"]],
						'format_value' => $this->get_formatted_output(array($r[$this->prefix."_custom_".$this->t_fields[$r[$this->prefix."_custom_champ"]]["DATATYPE"]]),$r[$this->prefix."_custom_champ"],true),
					    'group' => $this->get_custom_field_group_from_id($r[$this->prefix."_custom_champ"]),
					    'order' => $r[$this->prefix."_custom_order"]
					);
					$this->list_values[] = $r[$this->prefix . "_custom_" . $this->t_fields[$r[$this->prefix . "_custom_champ"]]["DATATYPE"]];
				}
				$this->values = $this->sort_values($values);
				if (!empty($this->values)) {
				    $this->add_grouped_values();
				}
			}
		}
	}

	public function get_editable_field($id, $idchamp=0, $t_field = array())
	{
	    if (! isset($this->values[$idchamp])) {
	        $this->values[$idchamp] = array();
	    }
	    $t=array();
	    $t["ID"] = $idchamp;
	    $t["TYPE"] = $t_field['TYPE'];
	    $t["NAME"] = $t_field["NAME"];
	    $t["TITRE"] = $t_field["TITRE"];
	    $t["OPAC_SHOW"] = $t_field["OPAC_SHOW"];

	    $field=array();
	    $field["ID"] = $idchamp;
	    $field["NAME"]= $t_field["NAME"];
	    $field["MANDATORY"]= $t_field["MANDATORY"];
	    $field["SEARCH"]= $t_field["SEARCH"];
	    $field["EXPORT"]= $t_field["EXPORT"];
	    $field["EXCLUSION"] = '';
	    if(isset( $t_field["EXCLUSION"])) $field["EXCLUSION"]= $t_field["EXCLUSION"];
	    $field["OPAC_SORT"]= $t_field["OPAC_SORT"];
	    $field["COMMENT"]= $t_field["COMMENT"];
	    $field["ALIAS"]= $t_field["TITRE"];
	    $field["DATATYPE"]= $t_field["DATATYPE"];
	    $field["OPTIONS"]= $t_field["OPTIONS"];
	    $field["VALUES"] = '';
	    if(isset($this->values[$idchamp]))	$field["VALUES"]=$this->values[$idchamp];
	    $field["PREFIX"]=$this->prefix;
	    $field["ID_ORIGINE"] = $id;
	    $t['FIELD'] = $field;

//         $t["NAME"] = $field["NAME"];
	    return $t;
	}

	// Retourne la liste des champs  saisir dans le formulaire de modification/cration d'un emprunteur ou autre
	public function get_editable_fields($id, $from_z3950 = false)
	{
	    $editable_fields = array();
	    if (!$this->no_special_fields) {
	        $groups_fields = array();
	        reset($this->t_fields);
	        foreach ($this->t_fields as $key => $val) {
	            if (!empty($this->t_fields[$key]["GROUP"]) && is_object($this->t_fields[$key]["GROUP"])) {
	                $custom_field_group = $this->t_fields[$key]["GROUP"];
	                $num_group = $custom_field_group->get_id();
	                if (isset($groups_fields[$num_group])) {
	                    $group_key = $groups_fields[$num_group];
	                } else {
	                    $group_key = count($editable_fields);
	                    $groups_fields[$num_group] = $group_key;
	                }
	                if (!isset($editable_fields[$group_key]['FIELDS_GROUPS'])) {
	                    $editable_fields[$group_key]['FIELDS_GROUPS'] = array();
	                }
	                $editable_fields[$group_key]['NAME'] = $custom_field_group->get_name();
	                $editable_fields[$group_key]['TITLE'] = $custom_field_group->get_translated_title();
	                $editable_fields[$group_key]['TITLE_BUTTON_ADD'] = $custom_field_group->get_translated_title_button_add();
	                $editable_fields[$group_key]['FIELDS_GROUPS'][] = $this->get_editable_field($id, $key, $val);
	            } else {
	                $editable_fields[] = $this->get_editable_field($id, $key, $val);
	            }
	        }
	    }
	    return $editable_fields;
	}

	// Affichage des champs  saisir dans le formulaire de modification/cration d'un emprunteur ou autre
	public function show_editable_fields($id, $from_z3950 = false)
	{
	    global $aff_list_empr;
	    global $aff_aggregator_list_empr;
	    $perso = array();
	    $perso["FIELDS"] = array();
	    $perso["CHECK_SCRIPTS"] = '';
	    if (! $this->no_special_fields) {
	        if (! $from_z3950) {
	            $this->get_values($id);
	        }
	        $check_scripts = "";
	        $editable_fields = $this->get_editable_fields($id, $from_z3950);
	        foreach ($editable_fields as $editable_field) {
	            if (!empty($editable_field['FIELDS_GROUPS'])) {
	                foreach ($editable_field['FIELDS_GROUPS'] as $editable_key_group=>$editable_field_group) {
	                    $aff = '';
                        $function_name = $aff_aggregator_list_empr[$editable_field_group['TYPE']] ?? '';
	                    if ($function_name && function_exists($function_name)) {
	                        $aff = $function_name($editable_field_group['FIELD'], $check_scripts);
	                    } else {
	                        $function_name = $aff_list_empr[$editable_field_group['TYPE']];
	                        if (function_exists($function_name)) {
	                            $aff = $function_name($editable_field_group['FIELD'], $check_scripts);
	                        }
	                    }
	                    if (is_array($aff)) {
	                        $editable_field['FIELDS_GROUPS'][$editable_key_group]["AFF"] = $aff['DISPLAY'];
	                        $editable_field['FIELDS_GROUPS'][$editable_key_group]["ADD_EVENT"] = $aff['ADD_EVENT'];
	                    } else {
	                        $editable_field['FIELDS_GROUPS'][$editable_key_group]["AFF"] = $aff;
	                    }
	                }
	            } else {
	                $editable_field["AFF"] = '';
	                //                     $function_name = $aff_list_empr[$this->t_fields[$key]['TYPE']];
	                $function_name = $aff_list_empr[$editable_field['TYPE']];
	                if (function_exists($function_name)) {
	                    $editable_field["AFF"] = $function_name($editable_field['FIELD'], $check_scripts);
	                }
	            }
	            $perso["FIELDS"][] = $editable_field;
	        }
	        // Compilation des javascripts de validit renvoys par les fonctions d'affichage
	        $check_scripts = "<script>function cancel_submit(message) { alert(message); return false;}\nfunction check_form() {\n" . $check_scripts . "\nreturn true;\n}\n</script>";
	        $perso["CHECK_SCRIPTS"] = $check_scripts;
	    } else {
	        $perso["CHECK_SCRIPTS"] = "<script>function check_form() { return true; }</script>";
	    }
	    return $perso;
	}

	public function show_field($key, $val)
	{
        global $val_list_empr;
        global $charset;

		$field=array();
		$titre = translation::get_text($this->t_fields[$key]['idchamp'], $this->prefix."_custom", 'titre',  $val['TITRE']);
		$field['TITRE'] = '<b>'.htmlentities($titre,ENT_QUOTES,$charset).' : </b>';
		$field['TITRE_CLEAN'] = htmlentities($titre,ENT_QUOTES,$charset);
		if (isset($val['OPAC_SHOW'])) {
		    $field['OPAC_SHOW'] = $val['OPAC_SHOW'];
		} else {
		    $field['OPAC_SHOW'] = '';
		}
		if(!isset($this->values[$key])) {
		    $this->values[$key] = array();
		}
		static::$st_prefix = $this->get_st_prefix();
		if(!isset(static::$fields[static::$st_prefix][$key])){
			static::$fields[static::$st_prefix][$key]=array();
			static::$fields[static::$st_prefix][$key]['ID']=$key;
			static::$fields[static::$st_prefix][$key]['NAME']=$this->t_fields[$key]['NAME'];
			static::$fields[static::$st_prefix][$key]['MANDATORY']=$this->t_fields[$key]['MANDATORY'];
			static::$fields[static::$st_prefix][$key]['SEARCH']=$this->t_fields[$key]['SEARCH'];
			static::$fields[static::$st_prefix][$key]['OPAC_SORT']=$this->t_fields[$key]['OPAC_SORT'];
			static::$fields[static::$st_prefix][$key]['COMMENT']=$this->t_fields[$key]['COMMENT'];
			static::$fields[static::$st_prefix][$key]['ALIAS']=$this->t_fields[$key]['TITRE'];
			static::$fields[static::$st_prefix][$key]['DATATYPE']=$this->t_fields[$key]['DATATYPE'];
			static::$fields[static::$st_prefix][$key]['OPTIONS']=$this->t_fields[$key]['OPTIONS'];
			static::$fields[static::$st_prefix][$key]['VALUES']=$this->values[$key];
			static::$fields[static::$st_prefix][$key]['PREFIX']=$this->prefix;
		}
		$field['TYPE']=$this->t_fields[$key]['TYPE'];
		$aff=$val_list_empr[$this->t_fields[$key]['TYPE']](static::$fields[static::$st_prefix][$key],$this->values[$key]);
		if(is_array($aff) && $aff['ishtml'] == true){
			$field['AFF'] = $aff['value'];
			if(isset($aff['details'])) {
				$field['DETAILS'] = $aff['details'];
			}
		} else {
			$field['AFF'] = htmlentities($aff,ENT_QUOTES,$charset);
		}
		$field['ID'] = static::$fields[static::$st_prefix][$key]['ID'];
		$field['NAME'] = static::$fields[static::$st_prefix][$key]['NAME'];
		$field['DATATYPE']=static::$fields[static::$st_prefix][$key]['DATATYPE'];
		$field['VALUES'] = $this->values[$key];
		return $field;
	}

	public function show_group($group)
	{
	    return array(
	           'ID' => $group->get_id(),
	           'NAME' => $group->get_name(),
	           'TITLE' => $group->get_translated_title(),
	    );
	}

	//Affichage des champs en lecture seule pour visualisation d'un fiche emprunteur ou autre...
	public function show_fields($id)
	{
		$perso=array();
		$perso["FIELDS"] = array();
		$perso["FIELDS_GROUPS"] = array();
		//Rcupration des valeurs stockes pour l'emprunteur
		$this->get_values($id);
		if (!$this->no_special_fields) {
			//Affichage champs persos
		    reset($this->t_fields);
			foreach ($this->t_fields as $k_field => $t_field) {
			    $t = $this->show_field($k_field, $t_field);
				$perso['FIELDS'][]=$t;
				if (!empty($t_field['GROUP']) && is_object($t_field['GROUP'])) {
				    $id_group = $t_field['GROUP']->get_id();
				    if (empty($perso["FIELDS_GROUPS"][$id_group])) {
				        $perso["FIELDS_GROUPS"][$id_group] = $this->show_group($t_field['GROUP']);
				    }
				    $perso["FIELDS_GROUPS"][$id_group]['FIELDS'][] = $t;
				}
			}
		}
		return $perso;
	}

	public function get_field_id_from_name($name)
	{
	    $query = "select idchamp from ".$this->prefix."_custom where name='".addslashes($name)."'";
	    $result = pmb_mysql_query($query);
	    return pmb_mysql_result($result, 0, 0);
	}

	public function get_field_name_from_id($id)
	{
	    $query = "select name from ".$this->prefix."_custom where idchamp='".addslashes($id)."'";
	    $result = pmb_mysql_query($query);
	    return pmb_mysql_result($result, 0, 0);
	}

	public function get_formatted_output($values, $field_id)
	{
		global $val_list_empr;

		static::$st_prefix = $this->get_st_prefix();
		if(!isset(static::$fields[static::$st_prefix][$field_id])){
		    if(!empty($this->t_fields[$field_id])){
    			static::$fields[static::$st_prefix][$field_id]=array();
    			static::$fields[static::$st_prefix][$field_id]["ID"]=$field_id;
    			static::$fields[static::$st_prefix][$field_id]["NAME"]=$this->t_fields[$field_id]["NAME"];
    			static::$fields[static::$st_prefix][$field_id]["MANDATORY"]=$this->t_fields[$field_id]["MANDATORY"];
    			static::$fields[static::$st_prefix][$field_id]["SEARCH"]=$this->t_fields[$field_id]["SEARCH"];
    			static::$fields[static::$st_prefix][$field_id]["OPAC_SORT"]=$this->t_fields[$field_id]["OPAC_SORT"];
    			static::$fields[static::$st_prefix][$field_id]["COMMENT"]=$this->t_fields[$field_id]["COMMENT"];
    			static::$fields[static::$st_prefix][$field_id]["ALIAS"]=$this->t_fields[$field_id]["TITRE"];
    			static::$fields[static::$st_prefix][$field_id]["DATATYPE"]=$this->t_fields[$field_id]["DATATYPE"];
    			static::$fields[static::$st_prefix][$field_id]["OPTIONS"]=$this->t_fields[$field_id]["OPTIONS"];
    			static::$fields[static::$st_prefix][$field_id]["VALUES"]=$values;
    			static::$fields[static::$st_prefix][$field_id]["PREFIX"]=$this->prefix;
    		}
		}
		if(!empty($this->t_fields[$field_id])){
    		$aff=$val_list_empr[$this->t_fields[$field_id]["TYPE"]](static::$fields[static::$st_prefix][$field_id],$values);
		}
		if (isset($aff)) {
		    if (is_array($aff)) {
		        return $aff['withoutHTML'];
		    }
    		return $aff;
		}
		return '';
	}

	// Retourne la requte SQL des valeurs stockes dans les base pour un emprunteur ou autre
	protected function _get_query_out_values($id)
	{
	    $id = intval($id);
	    return "select ".$this->prefix."_custom_champ,".$this->prefix."_custom_origine,".$this->prefix."_custom_small_text, ".$this->prefix."_custom_text, ".$this->prefix."_custom_integer, ".$this->prefix."_custom_date, ".$this->prefix."_custom_float, ".$this->prefix."_custom_order from ".$this->prefix."_custom_values join ".$this->prefix."_custom on idchamp=".$this->prefix."_custom_champ  where ".$this->prefix."_custom_origine=".$id;
	}

	protected function get_details($custom_field, $id)
	{
	    return "";
	}

	//Appel par sort_out_values
	protected function _sort_out_values_by_format_values($a,$b)
	{
		if($a['order'] != $b['order']) {
			return ($a['order'] < $b['order']) ? -1 : 1;
		}
		if (strtolower(strip_tags($a['format_value'])) == strtolower(strip_tags($b['format_value']))) {
			return 0;
		}
		return (strtolower(strip_tags($a['format_value'])) < strtolower(strip_tags($b['format_value']))) ? -1 : 1;
	}

	//Appel dans get_out_values
	protected function sort_out_values()
	{

		$fields = $this->values;
		foreach ($fields as $name=>$field) {
			uasort($field['values'], array($this, '_sort_out_values_by_format_values'));
			$this->values[$name]['values'] = $field['values'];
		}
	}

	//Ajoute les valeurs groupees dans le tableau de sortie
	public function add_grouped_out_values()
	{
	    foreach ($this->values as $custom_name=>$custom_field) {
	        $custom_id = $this->get_field_id_from_name($custom_name);
	        //Est-il dans un groupe ?
	        $custom_field_group = $this->get_custom_field_group_from_id($custom_id);
	        if (is_object($custom_field_group)) {
	            $group_name = $custom_field_group->get_name();
	            if (empty($this->values[$group_name])) {
	                $this->values[$group_name] = array();
	                $this->values[$group_name]['name'] = $group_name;
	                $this->values[$group_name]['label'] = $custom_field_group->get_translated_title();
	                $this->values[$group_name]['id'] = $custom_field_group->get_id();
	                $this->values[$group_name]['values'] = array();
	            }
	            if (!empty($custom_field['values'])) {
	                foreach ($custom_field['values'] as $custom_key=>$custom_value) {
	                    if (empty($this->values[$group_name]['values'][$custom_key])) {
	                        $this->values[$group_name]['values'][$custom_key] = array();
	                    }
	                    $this->values[$group_name]['values'][$custom_key][$custom_name] = array(
	                        'id' => $custom_id,
	                        'name' => $custom_name,
	                        'label' => $custom_field['label']
	                    );
	                    if (is_array($custom_value)) {
	                        $this->values[$group_name]['values'][$custom_key][$custom_name] = array_merge(
	                            $this->values[$group_name]['values'][$custom_key][$custom_name],
	                            $custom_value
                            );
	                    } else {
	                        $this->values[$group_name]['values'][$custom_key][$custom_name]['value'] = $custom_value;
	                    }
	                }
	            }
	        }
	    }
	}

	//Rcupration des valeurs stockes dans les base pour un emprunteur ou autre
	public function get_out_values($id)
	{
	    $id = intval($id);
		//Rcupration des valeurs stockes
	    static::$st_prefix = $this->get_st_prefix();
	    if(!isset(static::$out_values[static::$st_prefix][$id])){
			if ((!$this->no_special_fields)&&($id)) {
				$this->values = array() ;
				$requete = $this->_get_query_out_values($id);
				$resultat = pmb_mysql_query($requete);
				while ($r=pmb_mysql_fetch_array($resultat)) {
					$this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['label'] = $this->t_fields[$r[$this->prefix."_custom_champ"]]["TITRE"];
					$this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['id'] = $r[$this->prefix."_custom_champ"];
					$format_value = $this->get_formatted_output(array($r[$this->prefix."_custom_".$this->t_fields[$r[$this->prefix."_custom_champ"]]["DATATYPE"]]),$r[$this->prefix."_custom_champ"],true);
					$this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['values'][] = array(
						'value' => $r[$this->prefix."_custom_".$this->t_fields[$r[$this->prefix."_custom_champ"]]["DATATYPE"]],
						'format_value' => 	$format_value,
						'order' => $r[$this->prefix."_custom_order"],
					    'details' => $this->get_details($this->t_fields[$r[$this->prefix . "_custom_champ"]], $r[$this->prefix . "_custom_" . $this->t_fields[$r[$this->prefix . "_custom_champ"]]["DATATYPE"]])
					);
					if(!isset($this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['all_format_values'])) {
						$this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['all_format_values'] = '';
					}
					$this->values[$this->t_fields[$r[$this->prefix."_custom_champ"]]["NAME"]]['all_format_values'].=$format_value.' ';
				}
				$this->sort_out_values();
				if (!empty($this->values)) {
				    $this->add_grouped_out_values();
				}
            } else {
                $this->values = array();
            }
            static::$out_values[static::$st_prefix][$id] = $this->values;
		}else {
		    $this->values = static::$out_values[static::$st_prefix][$id];
		}
		return static::$out_values[static::$st_prefix][$id];
	}

	public function get_fields_recherche($id) {
		$return_val='';

		$this->get_values($id);
		if (!$this->no_special_fields) {
		    if (!empty($this->t_fields) && is_countable($this->t_fields)) {
    			reset($this->t_fields);
    			foreach ($this->t_fields as $key => $val) {
    				if ($this->t_fields[$key]["SEARCH"] && !empty($this->values[$key]) && is_countable($this->values[$key])) {
    					for ($i=0; $i<count($this->values[$key]); $i++) {
    						$return_val.=$this->values[$key][$i].' ';
    					}
    				}
    			}
		    }
		}
		return stripslashes($return_val);
	}

	public function get_ajax_list($name, $start)
	{
		$values=array();
		reset($this->t_fields);
		foreach ($this->t_fields as $key => $val) {
			if($val['NAME'] == $name) {
				switch ($val['TYPE']) {
					case 'list' :
					    $values = custom_fields_list::get_ajax_list($key, $this->prefix);
						break;
					case 'query_list' :
						$field=array();
						$field['OPTIONS']=$val['OPTIONS'];
						$q=$field['OPTIONS'][0]['QUERY'][0]['value'];
						$r = pmb_mysql_query($q);
						if(pmb_mysql_num_rows($r)) {
							while ($row=pmb_mysql_fetch_row($r)) {
								$values[$row[0]]=$row[1];
							}
						}
						break;
				}
				break;
			}
		}
		if (count($values) && $start && trim($start) != '%') {
			$filtered_values=array();
			foreach($values as $k=>$v) {
				if (strtolower(substr($v, 0, strlen($start)))==strtolower($start)) {
					$filtered_values[$k]=$v;
				}
			}
			return $filtered_values;
		}
		return $values;
	}

	public function get_val_field($id_elt,$name) {
		if (!$this->no_special_fields) {
			$this->get_values($id_elt);
			foreach($this->t_fields as $key=>$val){
				if($val["NAME"] == $name){
					//$this->p_perso->get_formatted_output($this->p_perso->values[$perso_voulus[$i]],$perso_voulus[$i])
					return $this->get_formatted_output($this->values[$key],$key);
				}
			}
		}
		return "";
	}

	public function get_field_form($id, $field_name, $values){
		global $aff_list_empr_search,$charset;
		$field=array();
		$field['ID']=$id;
		$field['NAME']=$this->t_fields[$id]['NAME'];
		$field['MANDATORY']=$this->t_fields[$id]['MANDATORY'];
		$field['ALIAS']=$this->t_fields[$id]['TITRE'];
		$field['COMMENT']=$this->t_fields[$id]['COMMENT'];
		$field['DATATYPE']=$this->t_fields[$id]['DATATYPE'];
		$field['OPTIONS']=$this->t_fields[$id]['OPTIONS'];
		$field['VALUES']=$values;
		$field['PREFIX']=$this->prefix;

		$r = '';
        $function_name = $aff_list_empr_search[$this->t_fields[$id]['TYPE']];
        if (function_exists($function_name)) {
            $check_scripts = '';
            $r = $function_name($field, $check_scripts, $field_name);
        }
		return $r;
	}

	public function get_rgaa_label($id, $field_name) {
	    $class_name = "custom_fields_".$this->t_fields[$id]['TYPE'];
	    if (class_exists($class_name)) {
	        $field=array();
	        $field['ID']=$id;
	        $field['NAME']=$this->t_fields[$id]['NAME'];
	        $field['OPTIONS']=$this->t_fields[$id]['OPTIONS'];
	        return $class_name::get_rgaa_label($field, $field_name);
	    }
	    return '';
	}

	// Gnre le champ perso ditable (pour formulaire), avec les donnes issues d'un formulaire
	public function get_field_form_whith_form_value($id){
		global $aff_list_empr, $charset;

		$field=array();
		$field['ID']=$id;
		$field['NAME']=$this->t_fields[$id]['NAME'];
		$field['MANDATORY']=$this->t_fields[$id]['MANDATORY'];
		$field['ALIAS']=$this->t_fields[$id]['TITRE'];
		$field['COMMENT']=$this->t_fields[$id]['COMMENT'];
		$field['DATATYPE']=$this->t_fields[$id]['DATATYPE'];
		$field['OPTIONS']=$this->t_fields[$id]['OPTIONS'];

		$name = $field['NAME'];
		$values = array();
		global ${$name};
		$value=${$name};
		if(!empty($value)) {
    		for ($i=0; $i<count($value); $i++) {
    			if($value[$i]) {
    				$values[] = $value[$i];
    			}
    		}
	    }
		$field["VALUES"] = $values;
		$field['PREFIX'] = $this->prefix;

		$aff = '';
		$function_name = $aff_list_empr[$this->t_fields[$id]['TYPE']];
		if (function_exists($function_name)) {
			$check_scripts = '';
			$aff = $function_name($field, $check_scripts);
		}

		return $aff;
	}

	//Lecture des champs de recherche
	public function read_search_fields_from_form() {

		$perso=array();
		reset($this->t_fields);
		foreach ($this->t_fields as $key => $val) {
			if ($this->t_fields[$key]["SEARCH"]) {
				$t=array();
				$t["ID"]=$key;
				$t["DATATYPE"]=$val["DATATYPE"];
				$t["NAME"]=$val["NAME"];
				$t["TITRE"]=$val["TITRE"];
				$t["COMMENT"]=$val["COMMENT"];
				$name = $this->t_fields[$key]["NAME"];
				$values = array();
				if($val["NAME"] == $name) {
					global ${$name};
					$value=${$name};
					if(is_array($value)) {
						for ($i=0; $i<count($value); $i++) {
							if($value[$i]) {
								$values[] = $value[$i];
							}
						}
					}
				}
				$t["VALUE"]=$values;
				$perso["FIELDS"][]=$t;
			}
		}
		return $perso;
	}

	//Enregistrement des champs perso soumis lors de la saisie d'une fichie emprunteur ou autre...
	public function rec_fields_perso($id) {
		//Enregistrement des champs personaliss
		$requete="delete from ".$this->prefix."_custom_values where ".$this->prefix."_custom_origine=$id";
		pmb_mysql_query($requete);
		$requete = "delete from ".$this->prefix."_custom_dates where ".$this->prefix."_custom_origine=$id";
		pmb_mysql_query($requete);
		reset($this->t_fields);
		foreach ($this->t_fields as $key => $val) {
			$name=$val["NAME"];
			global ${$name};
			$value=${$name};
			if (is_array($value) && count($value)) {
				for ($i=0; $i<count($value); $i++) {
					if (isset($value[$i]) && $value[$i]!=="") {
						$requete="insert into ".$this->prefix."_custom_values (".$this->prefix."_custom_champ,".$this->prefix."_custom_origine,".$this->prefix."_custom_".$val["DATATYPE"].",".$this->prefix."_custom_order) values($key,$id,'".$value[$i]."',$i)";
						pmb_mysql_query($requete);

						if ($this->t_fields[$key]["TYPE"] == 'date_flot') {
							$interval = explode("|||", $value[$i]);
							$date_type = $interval[0];

							$date_start_signe = 1;
							$date_end_signe = 1;
							if (substr($interval[1], 0, 1) == '-') {
								// date avant JC
								$date_start_signe = -1;
								$interval[1] = substr($interval[1], 1);
							}
							if (substr($interval[2], 0, 1) == '-') {
								// date avant JC
								$date_end_signe = -1;
								$interval[2] = substr($interval[2], 1);
							}
							// annes saisie infrieures  4 digit
							if (strlen($interval[1]) < 4)	$interval[1] = str_pad($interval[1], 4, '0', STR_PAD_LEFT);
							if ($interval[2] && strlen($interval[2]) < 4)	$interval[2] = str_pad($interval[2], 4, '0', STR_PAD_LEFT);

							$date_start = detectFormatDate($interval[1], 'min');
							$date_end = detectFormatDate($interval[2], 'max');

							if ($date_start == '0000-00-00') $date_start = '';
							if ($date_end == '0000-00-00') $date_end = '';

							if ($date_start || $date_end) {
								if (!$date_end) {
									$date_end = detectFormatDate($interval[1], 'max');
									$date_end_signe = $date_start_signe;
								}
								// format en integer
								$date_start = str_replace('-', '', $date_start) * $date_start_signe;
								$date_end = str_replace('-', '', $date_end) * $date_end_signe;
								if ($date_end < $date_start) {
									$date = $date_start;
									$date_start = $date_end;
									$date_end = $date;
								}
								$requete = "insert into ".$this->prefix."_custom_dates (".$this->prefix."_custom_champ,".$this->prefix."_custom_origine,
										".$this->prefix."_custom_date_type,".$this->prefix."_custom_date_start,".$this->prefix."_custom_date_end,".$this->prefix."_custom_order)
											values($key,$id,$date_type,'".$date_start."','".$date_end."',$i)";
								pmb_mysql_query($requete);
							}
						}
					}
				}
			}
		}
	}

	public function get_sort_type() {
	    switch ($this->prefix) {
	        case 'author':
	            return 'authors';
	        case 'categ':
	            return 'categories';
	        case 'publisher':
	            return 'publishers';
	        case 'collection':
	            return 'collections';
	        case 'subcollection':
	            return 'subcollections';
	        case 'serie':
	            return 'series';
	        case 'indexint':
	            return 'indexint';
	        case 'skos':
	            return 'concepts';
	        case 'authperso':
	            return 'authperso';
		}
	}

	public function gen_liste_field($select_name = "p_perso_liste", $selected_id = 0, $msg_no_select='') {
	    global $msg;

	    $requete = "select idchamp, name, titre, type, datatype, multiple, obligatoire, ordre ,search, export,exclusion_obligatoire, opac_sort from ".$this->prefix."_custom order by ordre";
	    return gen_liste($requete, "idchamp", "titre", $select_name, "", $selected_id, 0, $msg["parperso_no_field"], 0, $msg_no_select, 0);
	}

	// Validation des valeurs des champs soumis lors de la saisie d'une fiche emprunteur ou autre...
	public function check_submited_fields()
	{
		global $chk_list_empr, $charset;

		$nberrors = 0;
		$this->error_message = "";

		if (! $this->no_special_fields) {
			reset($this->t_fields);
			foreach ($this->t_fields as $key => $val) {
				$check_message = "";
				$field = array();
				$field["ID"] = $key;
				$field["NAME"] = $this->t_fields[$key]["NAME"];
				$field["MANDATORY"] = $this->t_fields[$key]["MANDATORY"];
				$field["ALIAS"] = $this->t_fields[$key]["TITRE"];
				$field["OPTIONS"] = $this->t_fields[$key]["OPTIONS"];
				$field["DATATYPE"] = $this->t_fields[$key]["DATATYPE"];
				$field["PREFIX"] = $this->prefix;
				$field["SEARCH"] = $this->t_fields[$key]["SEARCH"];
				$field["EXPORT"] = $this->t_fields[$key]["EXPORT"];
				$field["FILTERS"] = (! empty($this->t_fields[$key]["FILTERS"]) ? $this->t_fields[$key]["FILTERS"] : '');
				$field["EXCLUSION"] = $this->t_fields[$key]["EXCLUSION"];
				$field["OPAC_SORT"] = $this->t_fields[$key]["OPAC_SORT"];
				$field["COMMENT"] = $this->t_fields[$key]["COMMENT"];
				global ${$val["NAME"]};
				$field['VALUES'] = ${$val["NAME"]};
				eval($chk_list_empr[$this->t_fields[$key]["TYPE"]] . "(\$field,\$check_message);");
				if ($check_message != "") {
					$nberrors ++;
					$this->error_message .= "<p>" . $check_message . "</p>";
				}
			}
		}
		return $nberrors;
	}

	/**
	 * Validation du formulaire de creation
	 * (inutilisee en OPAC)
	 *
	 */
	public function check_form()
	{
	}

	/**
	 * (inutilisee en OPAC)
	 *
	 * @param int $idchamp
	 * @return void
	 */
	public function show_edit_form($idchamp = 0)
	{}

	/**
	 * (inutilisee en OPAC)
	 *
	 * @return void
	 */
	public function proceed_save()
	{}

	/**
	 * (inutilisee en OPAC)
	 *
	 * @return void
	 */
	public function proceed_edit_group()
	{}

	/**
	 * (inutilisee en OPAC)
	 *
	 * @return void
	 */
	public function proceed_save_group()
	{}
}
