<?php

// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_animationslist_datasource_all_animations.class.php,v 1.2.6.1.2.1 2025/06/27 10:08:21 qvarin Exp $
use Pmb\Animations\Orm\AnimationOrm;

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class cms_module_animationslist_datasource_all_animations extends cms_module_common_datasource_animations_list
{
    public function __construct($id = 0)
    {
        parent::__construct($id);
        $this->sortable = true;
        $this->limitable = true;
        $this->paging = true;
    }

    /*
     * On dfini les slecteurs utilisable pour cette source de donne
     */
    public function get_available_selectors()
    {
        return [];
    }


    /*
     * Rcupration des donnes de la source...
     */
    public function get_datas()
    {
        $query = $this->buildQuery();
        if (empty($query)) {
            return false;
        }

        $animations = [];
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $animations[] = intval($row['id_animation']);
            }
            pmb_mysql_free_result($result);
            $animations = $this->filter_datas('animations', $animations);
        }

        if (!is_countable($animations) || !count($animations)) {
            return false;
        }

        $data = $this->sort_animations($animations);
        $data['title'] = "";

        // Pagination
        if ($this->paging && isset($this->parameters['paging_activate']) && $this->parameters['paging_activate'] == "on") {
            $data['paging'] = $this->inject_paginator($data['animations']);
            $data['animations'] = $this->cut_paging_list($data['animations'], $data['paging']);
        } elseif ($this->parameters["nb_max_elements"] > 0) {
            $data['animations'] = array_slice($data['animations'], 0, $this->parameters["nb_max_elements"]);
        }

        return $data;
    }
}
