<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_audit_type_ui.class.php,v 1.1.6.1 2025/07/29 13:38:10 dbellamy Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_audit_type_ui extends list_audit_ui {


	protected function init_default_selected_filters() {
	    $this->selected_filters = array();
	}

	protected function init_default_pager() {
	    parent::init_default_pager();
	    $this->pager['all_on_page'] = true;
	}

	/**
	 * Initialisation du tri par dfaut appliqu
	 */
	protected function init_default_applied_sort() {
	    $this->add_applied_sort('quand', 'desc');
	}

	protected function init_default_columns() {
		$this->add_column('applicant');
		$this->add_column('name');
		$this->add_column('user_name');
		$this->add_column('action');
		$this->add_column('quand');
		$this->add_column('info');
	}

	protected function init_default_settings() {
		parent::init_default_settings();
		$this->set_setting_display('search_form', 'visible', false);
		$this->set_setting_display('search_form', 'export_icons', false);
		$this->set_setting_display('query', 'human', false);
		$this->set_setting_display('pager', 'visible', false);
		$this->set_setting_column('default', 'align', 'left');
	}
}