<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_entity_record_content_form.class.php,v 1.1.4.5 2025/12/01 14:00:18 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_entity_record_content_form extends interface_entity_content_form {
	
    protected function _init_tabs_data() {
        global $pmb_map_activate, $pmb_nomenclature_activate;
        
        // Titres
        $this->_add_tab_data('el0', '712', '236', true);
        // Editeurs & Collection
        $this->_add_tab_data('el2', '249');
        // ISBN, EAN ou no. commercial
        $this->_add_tab_data('el3', '255');
        // Collation
        $this->_add_tab_data('el4', '258', '257');
        // Notes
        $this->_add_tab_data('el5', '264', '263'); //title $msg[264] ??
        // Oeuvres/Expressions
        $this->_add_tab_data('el230', 'catal_onglet_titre_uniforme', 'aut_menu_titre_uniforme');
        // Langues de la publication
        $this->_add_tab_data('el7', '710');
        // Lien (ressource lectronique)
        $this->_add_tab_data('el8', '274');
        // Champs personnaliss
        $this->_add_tab_data('el9', 'notice_champs_perso');
        // Map
        if ($pmb_map_activate) {
            $this->_add_tab_data('el14', 'notice_map_onglet_title');
        }
        // Nomenclature
        if ($pmb_nomenclature_activate) {
            $this->_add_tab_data('el15', 'notice_nomenclature_onglet_title');
        }
    }
    
    protected function _init_elements_titles_data() {
        //Titre propre
        $this->_add_element_data('f_tit1', 'el0Child_0' , '237');
        // Titre propre d'un auteur diffrent
        $this->_add_element_data('f_tit2', 'el0Child_1', '238');
        // Titre parallle
        $this->_add_element_data('f_tit3', 'el0Child_2', '239');
        // Complment du titre
        $this->_add_element_data('f_tit4', 'el0Child_3', '240');
    }
    
    protected function _init_elements_code_data() {
        // ISBN, EAN ou no. commercial
        $this->_add_element_data('f_cb', 'el3Child_0', '255');
    }
    
    protected function _init_elements_collation_data() {
        // Importance matrielle (nombre de pages, d'lments...)
        $this->_add_element_data('f_npages', 'el4Child_0', '259');
        // Autres caractristiques matrielle (ill., ...)
        $this->_add_element_data('f_ill', 'el4Child_1', '260');
        // Format
        $this->_add_element_data('f_size', 'el4Child_2', '261');
        // Prix
        $this->_add_element_data('f_prix', 'el4Child_3', '4050');
        // Matriel d'accompagnement
        $this->_add_element_data('f_accomp', 'el4Child_4', '262');
    }
    
    protected function _init_elements_data() {
        $this->_init_elements_titles_data();
        $this->_init_elements_code_data();
        $this->_init_elements_collation_data();
        
        // Note generale
        $this->_add_element_data('f_n_gen', 'el5Child_0', '265');
        //Note de contenu
        $this->_add_element_data('f_n_contenu', 'el5Child_1', '266');
        //Rsum/Extrait
        $this->_add_element_data('f_n_resume', 'el5Child_2', '267');
        
        // URL associee
        $this->_add_element_data('f_lien', 'el8Child_0', '275');
        // Format lectronique de la ressource
        $this->_add_element_data('f_eformat', 'el8Child_1', '276');
        
        // commentaire de gestion
        $this->_add_element_data('f_commentaire_gestion', 'el10Child_1', 'notice_commentaire_gestion');
        
    }
    
    protected function get_template_tab() {
        global $notice_tab_form_tpl;
        
        return $notice_tab_form_tpl;
    }
    
    public function get_display_tab($uid, $content) {
        global $charset;
        
        $tab = $this->get_tab_data($uid);
        
        $display = $this->get_template_tab();
        $display = str_replace('!!id!!', $tab['uid'], $display);
        $display = str_replace('!!expandBase_button!!', get_expandBase_button($tab['uid'], $tab['title_code'], $tab['expanded']), $display);
        if ($tab['uid'] == 'el30') {
            //Juste pour la retro-compatibilite de l'affichage de l'ISSN avec balise HTML
            $display = str_replace('!!label!!', $tab['label'], $display);
        } else {
            $display = str_replace('!!label!!', htmlentities($tab['label'], ENT_QUOTES, $charset), $display);
        }
        $display = str_replace('!!title!!', htmlentities($tab['title'], ENT_QUOTES, $charset), $display);
        $display = str_replace('!!content!!', $content, $display);
        return $display;
    }
    
    public static function get_instance_interface_element($uid, $name, $label_code='', $display_type='row') {
        return interface_entity_record_element::get_instance($uid, $name, $label_code, $display_type);
    }
    
    public function add_record_element($name) {
        $data = $this->get_element_data($name);
        $interface_element = interface_entity_record_element::get_instance($data['uid'], $name, $data['label_code']);
        $this->elements[$name] = $interface_element;
        $this->add_grid_element($name);
        return $interface_element;
    }
    
    public function add_element_code($name, $value = '') {
        global $msg;
        
        $element = $this->add_record_element("f_".$name);
        $attributes = ['data-form-name' => "f_".$name, 'readonly' => ''];
        $element->add_input_node('text', $value, $attributes)
        ->set_class('saisie-20emr');
        $element->add_input_node('button', $msg['parcourir'])
        ->set_id("f_".$name."_button_browse")
        ->set_name("f_".$name."_button_browse")
        ->set_click("openPopUp('./catalog/setcb.php?notice_id=".$this->object_id."', 'getcb')");
        $element->add_input_node('button', $msg['raz'])
        ->set_id("f_".$name."_button_raz")
        ->set_name("f_".$name."_button_raz")
        ->set_click("this.form.f_cb.value='';");
        $element->set_display_nodes_separator('&nbsp;');
        return $element;
    }
    
    public function add_element_input_text($name, $value = '') {
        $element = $this->add_record_element("f_".$name);
        $element->add_input_node('text', $value, ['data-form-name' => "f_".$name]);
        return $element;
    }
    
    public function add_element_input_url($name, $value = '') {
        $element = $this->add_record_element("f_".$name);
        $attributes = ['data-form-name' => "f_".$name];
        if ($name == 'lien') {
            $attributes['onchange'] = 'chklnk_f_lien(this);';
            $element->add_html_node("<div id='f_lien_check' style='display:inline'></div>");
        }
        $element->add_input_node('url', $value, $attributes);
        return $element;
    }
    
    public function add_element_textarea($name, $content = '') {
        $element = $this->add_record_element("f_".$name);
        $element->add_textarea_node($content, 0, 5)
        ->set_class('saisie-80em')
        ->set_attributes(['wrap' => 'virtual', 'data-form-name' => "f_".$name]);
        return $element;
    }
    
    public function add_element_authority($name, $value = '', $properties = []) {
        $what = $properties['what'];
        $completion = $properties['completion'];
        $hidden = $properties['hidden'];
        if(empty($hidden['name'])) {
            $hidden['name'] = "f_".$name."_id";
        }
        if(empty($hidden['value'])) {
            $property = $name."_id";
            $hidden['value'] = $this->{$property};
        }
        $element = $this->add_record_element("f_".$name);
        $element->add_authority_node($this->{$name}, $completion)
        ->set_class('saisie-30emr')
        ->set_hidden_name($hidden['name'])
        ->set_hidden_value($hidden['value'])
        ->set_openPopUpUrl("./select.php?what=".$what."&caller=notice&param1=".$hidden['name']."&param2=f_".$name."&deb_rech=".pmb_escape()."(this.form.f_".$name.".value)")
        ->set_forceSelectorDialog($this->is_force_dialog($what))
        ->set_forceSelectorPopUp($this->is_force_popup($what));
        
        return $element;
    }
}