<?php

namespace Pmb\Ocr\Controller;

use encoding_normalize;
use parameter;
use Pmb\Common\Controller\Controller;
use Pmb\Ocr\Models\OcrExplnumsModel;

class ApiController extends Controller
{
    /**
     * Save the config
     *
     * @return void
     */
    public function configSave(): void
    {
        if (empty($this->data)) {
            $this->ajaxError('No data', 400);
        }

        switch ($this->data->service) {
            case 2:
                $this->updateConfigServer();
                break;

            case 1:
                if (OcrExplnumsModel::isOcrByServer()) {
                    // On passe sur une ocrisation en local
                    // On vide la table ocr_explnums
                    pmb_mysql_query('TRUNCATE TABLE ocr_explnums');
                }

                $this->updateConfig();
                break;

            default:
                $this->ajaxError('Invalid service', 400);
                break;
        }
    }

    /**
     * Save the config
     *
     * @return void
     */
    protected function updateConfig()
    {
        if (empty($this->data->path)) {
            $this->ajaxError('Missing data', 400);
        }

        $config = [
            'service' => $this->data->service,
            'path' => $this->data->path,
        ];

        $this->updateParameter($config);
    }

    /**
     * Save the config server
     *
     * @return void
     */
    protected function updateConfigServer()
    {
        if (empty($this->data->url) || empty($this->data->salt) || empty($this->data->token)) {
            $this->ajaxError('Missing data', 400);
        }

        if (!filter_var($this->data->url, FILTER_VALIDATE_URL)) {
            $this->ajaxError('Invalid URL', 400);
        }

        if (!is_string($this->data->salt)) {
            $this->ajaxError('Invalid salt', 400);
        }

        if (!is_string($this->data->token)) {
            $this->ajaxError('Invalid token', 400);
        }

        $configServer = [
            'service' => $this->data->service,
            'url' => $this->data->url,
            'salt' => $this->data->salt,
            'token' => $this->data->token,
        ];

        $this->updateParameter($configServer);
    }

    /**
     * Update the parameter
     *
     * @param array $config
     * @return void
     */
    protected function updateParameter($config)
    {
        parameter::update('pmb', 'ocr_config', encoding_normalize::json_encode($config));
        $this->ajaxJsonResponse(['success' => true]);
    }
}