<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SourceOAI.php,v 1.2.2.2 2025/06/27 14:20:50 rtigero Exp $

namespace Pmb\ImportExport\Models\Sources\SourceOAI;

use oai20;
use Pmb\Common\Helper\Helper;
use Pmb\ImportExport\Models\Sources\Source;

class SourceOAI extends Source
{
    protected const OAI_ENCODING = "UTF-8";

    private $oai = null;

    public function initSync()
    {
        //On vrifie que l'OAI est accessible
        if (empty($this->contextParameters["OAIMetadataFormat"]) || self::OAITest($this->baseParameters)["error"]) {
            return false;
        }

        $params = [
            "type" => "URL",
            "uri" => $this->baseParameters["url"],
            "mode" => "r",
            "context" => [
                "options" => [],
                "params" => [
                    "timeout" => $this->baseParameters["timeout"]
                ]
            ]
        ];
        $this->chunk = new $this->baseParameters["entryFormat"]($params, $this->getChunkParameters());
        return true;
    }

    /**
     * Retourne la liste des sets prsents dans l'OAI
     *
     * @param \stdClass $data
     * @return array
     */
    public static function OAISets($data)
    {
        $result = array();
        $oai = self::getOAI(Helper::toArray($data));
        $sets = $oai->list_sets();
        foreach ($sets as $value => $set) {
            $result[] = [
                'value' => $value,
                'label' => ! empty($set['name']) ? $set['name'] . ' (' . $value . ')' : $value
            ];
        }
        return $result;
    }

    /**
     * Retourne la liste des formats prsents dans l'OAI
     *
     * @param \stdClass $data
     * @return array
     */
    public static function OAIMetadataFormats($data)
    {
        $result = array();
        $oai = self::getOAI(Helper::toArray($data));
        $formats = $oai->list_metadata_formats();
        foreach ($formats as $format) {
            $result[] = [
                'value' => $format["PREFIX"],
                'label' => $format["PREFIX"]
            ];
        }
        return $result;
    }

    /**
     * Teste la connexion  l'OAI
     *
     * @param \stdClass $data
     * @return array
     */
    public static function OAITest($data)
    {
        $oai = self::getOAI(Helper::toArray($data));
        if ($oai->error) {
            return [
                'error' => true,
                'errorMessage' => $oai->error_message
            ];
        }
        return [
            'error' => false
        ];
    }

    /**
     * Instancie la class oai20 et retourne l'instance
     *
     * @param array $data
     * @return oai20
     */
    private static function getOAI($data)
    {
        $oai = new oai20($data["url"], static::OAI_ENCODING, $data["timeout"], $data["cleanHTML"], $data["keepUrl"]);
        return $oai;
    }

    public function closeSync()
    {
        unset($this->chunk);
    }

    private function getChunkParameters()
    {
        return array_merge(
            $this->baseParameters[$this->baseParameters["entryFormat"]],
            $this->contextParameters,
            $this->baseParameters
        );
    }
}
