<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: RdfEntitiesIntegratorImportExport.php,v 1.4.2.2 2025/06/27 14:21:04 rtigero Exp $

namespace Pmb\ImportExport\Models\Integrators;

use rdf_entities_integrator;

class RdfEntitiesIntegratorImportExport extends rdf_entities_integrator
{
    //Intgrateur driv pour l'import export

    public const INTEGRATORS_NAMESPACE = "Pmb\\ImportExport\\Models\\Integrators\\RdfEntitiesIntegrators\\";

    protected static $insertedEntities = array();

    protected $from_importexport = true;

    public function get_entity_integrator_from_type_uri($type_uri)
    {
        $integrator_class = static::INTEGRATORS_NAMESPACE;
        switch ($type_uri) {
            default:
                $is_cms = false;
                $type = substr($type_uri, strpos($type_uri, '#') + 1);
                $type = strtolower($type);

                $integrator_class .= 'rdf_entities_integrator_' . $type;
                if (strpos($type, 'article') !== false) {
                    $integrator_class = 'rdf_entities_integrator_article';
                    $is_cms = true;
                }
                if (strpos($type, 'section') !== false) {
                    $integrator_class .= 'rdf_entities_integrator_section';
                    $is_cms = true;
                }
                if (strpos($type, 'authperso') !== false) {
                    $authperso =  preg_split("#_([\d]+)#", $type, 0, PREG_SPLIT_NO_EMPTY | PREG_SPLIT_DELIM_CAPTURE);
                    $integrator_class = static::INTEGRATORS_NAMESPACE . 'rdf_entities_integrator_authperso';
                    $integrator = new $integrator_class($this->store);
                    $integrator->set_authperso_num($authperso[1]);
                    return $integrator;
                }
                if (class_exists($integrator_class)) {
                    $integrator = new $integrator_class($this->store);
                    if ($is_cms) {
                        $type_explode = explode('_', $type);
                        $num_type = $type_explode[count($type_explode) - 1];
                        if (is_numeric($num_type)) {
                            $integrator->set_cms_type($num_type);
                        }
                    }
                    return $integrator;
                }
                return null;
        }
    }


    protected function add_linked_queries_element($linked_query_data, $external_field_value)
    {

        if (!$external_field_value) {
            // Le champ a ete vide
            return null;
        }
        if (!isset($this->linked_queries_elements[$linked_query_data['table']])) {
            $this->linked_queries_elements[$linked_query_data['table']] = array(
                'reference_field_name' => $linked_query_data['reference_field_name'] ?? "",
                'external_field_name' => $linked_query_data['external_field_name'] ?? "",
                'other_fields' => $linked_query_data['other_fields'] ?? array(),
                'external_field_values' => array()
            );
        }

        $this->linked_queries_elements[$linked_query_data['table']]['external_field_values'][] = $external_field_value;
    }

    protected function handle_property($property_uri, $values)
    {
        if (isset($this->map_fields[$property_uri])) {
            $this->base_query_elements[$this->map_fields[$property_uri]] = $values[0]['value'];
        }

        if (isset($this->foreign_fields[$property_uri])) {
            if ($values[0]['type'] === 'uri') {
                if (! in_array($values[0]['value'], static::$insertedEntities)) {
                    $integrated_entity = $this->integrate_entity($values[0]['value'], true);
                    $this->entity_data['children'][] = $integrated_entity;
                    if ($integrated_entity['id']) {
                        $this->base_query_elements[$this->foreign_fields[$property_uri]] = $integrated_entity['id'];
                    }
                } else {
                    $foreign_id = $this->store->get_property($values[0]['value'], 'pmb:identifier');
                    if (! empty($foreign_id)) {
                        $this->base_query_elements[$this->foreign_fields[$property_uri]] = $foreign_id[0]['value'];
                    }
                }
            }
        }

        if (isset($this->linked_entities[$property_uri])) {
            foreach ($values as $value) {
                if ($value['type'] === 'uri') {
                    if (! in_array($value['value'], static::$insertedEntities)) {
                        $integrated_entity = $this->integrate_entity($value['value'], true);
                        $this->entity_data['children'][] = $integrated_entity;
                        if (array_key_exists('id', $integrated_entity)) {
                            $external_field_value = $integrated_entity['id'];
                        }
                    } else {
                        $identifier = $this->store->get_property($value['value'], 'pmb:identifier');
                        //Peut tre vide en cas d'intgrations imbriques mutuellement, ne devrait pas empcher la gnration des liens
                        if (empty($identifier)) {
                            continue;
                        }
                        $external_field_value = $identifier[0]['value'];
                    }
                }

                if ($value['type'] === 'literal') {
                    $external_field_value = $value['value'];
                }
                if (isset($external_field_value)) {
                    $this->add_linked_queries_element($this->linked_entities[$property_uri], $external_field_value);
                }
            }
        }

        if (isset($this->special_fields[$property_uri])) {
            $arguments = $this->special_fields[$property_uri]["arguments"];
            $arguments[] = $values;
            $this->special_callables[] = array('method' => $this->special_fields[$property_uri]["method"], 'arguments' => $arguments);
        }
    }

    public function integrate_itself($uri)
    {
        if (in_array($uri, static::$insertedEntities)) {
            $id = $this->store->get_property($uri, 'pmb:identifier');
            if (empty($id)) {
                return array("id" => 0);
            }
            return array('id' => $id[0]['value']);
        }
        static::$insertedEntities[] = $uri;
        $entityData = parent::integrate_itself($uri);

        //On s'assure que le store contient le pmb:identifier
        $this->store->query("INSERT INTO <" . $this->store->get_config()['store_name'] . "> {
            <" . $uri . "> pmb:identifier \"" . $this->entity_id . "\" .
        }");
        return $entityData;
    }
}
