<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: DocnumsController.php,v 1.15.2.2 2025/06/12 09:13:53 rtigero Exp $

namespace Pmb\Docnums\Controller;

use Pmb\Common\Helper\Helper;
use Pmb\Docnums\Models\Collection;
use Pmb\Docnums\Models\Explnum;
use Pmb\Docnums\Views\DocnumsView;
use upload_folder;

class DocnumsController
{
    protected $vueName = 'docnums/collections';
    protected $data = [];

    public function proceed()
    {
        global $sub, $action, $id, $num_collection;

        $id = intval($id);
        if (!isset($num_collection)) {
            $num_collection = 0;
        }

        switch ($sub) {
            case 'edit':
            case 'add':
                //$this->vueName = 'docnums/add';
                switch ($action) {
                    case 'save':
                        global $f_nom, $f_url, $conservervignette, $f_statut_chk, $f_explnum_statut, $f_url_vignette, $msg;

                        print <<<HTML
                            <div class='row'>
                                <div class='msg-perio'>
                                    {$msg['maj_encours']}
                                </div>
                            </div>
                        HTML;

                        $explnum = new Explnum($id);
                        $explnum->mise_a_jour(
                            0,
                            0,
                            $f_nom,
                            $f_url,
                            0,
                            $conservervignette,
                            $f_statut_chk,
                            $f_explnum_statut,
                            array(),
                            0,
                            $f_url_vignette
                        );

                        break;
                    default:
                        $explnum = new Explnum($id);
                        print '<h1 class="section-title">' . $this->getBreadcrumb("docnum_add_docunum_label") . '</h1>';
                        print $explnum->explnum_form("./catalog.php?categ=docnum_collections&sub=add&action=save&id=" . $id);
                        break;
                }

                break;
            default:
                global $deflt_docnum_collection;
                if(! isset($deflt_docnum_collection)) {
                    $deflt_docnum_collection = 0;
                }
                $collection = new Collection();

                $this->data["list"] = $collection->getList(null, false, 'name ASC');
                $this->data["selected"] = 0;

                foreach ($this->data["list"] as $collection) {
                    if ($collection->id == $id || $collection->id == $num_collection) {
                        $this->data["selected"] = $collection->id;
                    }
                }
                $this->data["upload_folders"] = upload_folder::get_upload_folders();
                $this->data["lenders"] = Explnum::getLenders();
                $this->data["locations"] = Explnum::getDocsLocation();
                $this->data["licences"] = Explnum::getExplnumLicences();
                $this->data["default_collection"] = intval($deflt_docnum_collection);
                $this->data["breadcrumb"] = $this->getBreadcrumb("collections");
                $this->render();
                break;
        }
    }

    /**
     * Generation vue
     *
     * @param array $data
     */
    protected function render(array $data = [])
    {
        global $pmb_url_base;
        $vueJsView = new DocnumsView($this->vueName, array_merge(Helper::toArray($this->data), [
            "url_base" => $pmb_url_base,
            "url_webservice" => $pmb_url_base . "rest.php/docnums/",
            "vign_url" => $pmb_url_base . "vig_num_collections.php",
            "docnum_url" => $pmb_url_base . "doc_num_collections.php"
        ], Helper::toArray($data)));
        print $vueJsView->render();
    }

    /**
     * Retourne la liste des documents numriques d'une notice donnee
     *
     * @param integer $idNotice
     * @return void
     */
    public function fetchDocnums(int $idNotice)
    {
        global $pmb_explnum_order;
        $type = TYPE_NOTICE;

        $query = "SELECT explnum_id, explnum_nom, explnum_mimetype FROM explnum WHERE";
        if (TYPE_NOTICE === $type) {
            $query .= " explnum_notice='" . intval($idNotice) . "'";
            $query .= " UNION SELECT explnum_id, explnum_nom, explnum_mimetype FROM explnum, bulletins
			WHERE bulletin_id = explnum_bulletin AND bulletins.num_notice='" . intval($idNotice) . "'";
        } else {
            $query .= " explnum_bulletin='" . intval($idNotice) . "'";
        }

        if ($pmb_explnum_order) {
            $query .= " order by " . $pmb_explnum_order;
        } else {
            $query .= " order by explnum_mimetype, explnum_id ";
        }

        $docnums = [];
        $result = pmb_mysql_query($query);
        if (pmb_mysql_num_rows($result)) {
            while ($row = pmb_mysql_fetch_assoc($result)) {
                $docnums[] = [
                    'id' => intval($row['explnum_id']),
                    'name' => join(" - ", [$row['explnum_nom'], $row['explnum_mimetype']])
                ];
            }
            pmb_mysql_free_result($result);
        }

        $this->ajaxJsonResponse($docnums);
    }

    /**
     * Retourne un JSON et on stop PHP
     *
     * @param mixed $data
     */
    protected function ajaxJsonResponse($data, $code = null)
    {
        if (!is_array($data) && !is_object($data)) {
            $data = [$data];
        }
        if (null !== $code) {
            http_response_code($code);
        }
        ajax_http_send_response(\encoding_normalize::utf8_normalize($data));
        exit;
    }

    protected function getBreadcrumb(string $sectionCode)
    {
        global $msg;

        $breadcrum = "{$msg['docnum_collections_menu']} {$msg['menu_separator']} {$msg[$sectionCode]}";

        return $breadcrum;
    }
}
