<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_display.class.php,v 1.1.4.3 2025/11/05 15:19:16 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path, $include_path;
require_once("$class_path/marc_table.class.php");
require_once("$class_path/author.class.php");
require_once("$class_path/editor.class.php");
require_once("$class_path/collection.class.php");
require_once("$class_path/subcollection.class.php");
require_once("$class_path/serie.class.php");
require_once("$class_path/serialcirc_diff.class.php");
require_once("$include_path/notice_authors.inc.php");
require_once("$include_path/isbn.inc.php");

global $tdoc, $fonction_auteur;
if (!isset($tdoc)) $tdoc = marc_list_collection::get_instance('doctype');
if (!isset($fonction_auteur)) {
	$fonction_auteur = new marc_list('function');
	$fonction_auteur = $fonction_auteur->table;
}

// dfinition de la classe d'affichage des entits en liste pour selecteur
class selector_display {
    
    public $id = 0;		//id entite
    public $responsabilites =	array("responsabilites" => array(),"auteurs" => array());  //auteurs
    
    public $base_url = '';					//URL a associer aux elements cliquables
    public $action = '';					//action a effectuer pour retour des parametres
    public $action_values = array();		//tableau des elements  modifier dans l'action
    
    public $code = '';			//isbn ou code EAN de la notice  afficher
    public $prix = '0.00';		//prix renvoye
    
    public $header = '';		//entete
    public $result	= '';		//affichage final
    public $isbd = '';			//isbd notice
    
    public $nom_acte = '';			//nom de l'acte
    
    public $form_checker = ''; //Affichage d'une case  cocher sur le template
    
    // constructeur
    public function __construct($id, $base_url, $form_checker='') {
        $this->id=intval($id);
        $this->base_url=$base_url;
        $this->form_checker=$form_checker;
    }
    
    // rcupration des valeurs en table
    public function getData() {
        
    }
    
    public function get_notice_id() {
        return $this->id;
    }
    
    // creation header
    public function doHeader() {
        
    }
    
    // creation contenu
    public function doContent() {
        
    }
    
    protected function getCheckbox() {
        global $charset;
        
        $checkbox ="<input type='checkbox' name='".$this->form_checker."[]' id='".$this->form_checker."[".$this->id."]' value='".$this->id."'";
        if ($this->action) {
            if (count($this->action_values)) {
                foreach($this->action_values as $v) {
                    $checkbox.=" attr_".$v."=\"".htmlentities($this->$v,ENT_QUOTES,$charset)."\"";
                }
            }
        }
        $checkbox.=">";
        return $checkbox;
    }
    
    public function finalizeHeaderFromAction() {
        global $charset;
        
        if ($this->action) {
            $this->header = str_replace('!!display!!', $this->header, $this->action);
            $this->header = str_replace('!!id!!', $this->id, $this->header);
            
            if (count($this->action_values)) {
                foreach($this->action_values as $v) {
                    $this->header = str_replace("!!$v!!", htmlentities(addslashes($this->$v),ENT_QUOTES,$charset), $this->header);
                }
            }
        }
    }
    
    public function finalize() {
        
    }
    
    //creation formulaire
    public function doForm() {
        $this->getData();
        $this->responsabilites = get_notice_authors($this->get_notice_id()) ;
        $this->doHeader();
        $this->doContent();
        $this->doNomActe();
        $this->finalize();
    }
    
    public function getNomActe() {
        return '';
    }
    
    //generation du nom de l'acte
    public function doNomActe() {
        if (empty($this->nom_acte)) {
            $this->nom_acte = $this->getNomActe();
        }
    }
    
}
