<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_content_form.class.php,v 1.2.4.6 2025/12/03 15:50:33 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path.'/translation.class.php');

class interface_content_form {
	
	protected $name;
	
	protected $zones = [];
	
	protected $elements = [];
	
	protected $grid_model = 'default';
	
	protected $grid_elements = [];
	
	protected $current_element = 0;
	
	public function __construct($name = ''){
		$this->name = $name;
	}
			
	public function add_zone($name, $label_code='', $elements = []) {
		$interface_zone = new interface_zone($name);
		$interface_zone->set_label_code($label_code);
		if(!empty($elements)) {
			foreach ($elements as $element_name) {
				$interface_zone->add_element($this->elements[$element_name]);
// 				unset($this->elements[$element_name]);
			}
		}
		$this->zones[$name] = $interface_zone;
		return $interface_zone;
	}
	
	public static function get_instance_interface_element($uid, $name, $label_code='', $display_type='row') {
	    return interface_element::get_instance($uid, $name, $label_code, $display_type);
	}
	
	public function add_element($name, $label_code='', $display_type='row') {
		$interface_element = new interface_element($name);
		$interface_element->set_label_code($label_code)
		->set_display_type($display_type);
		$this->elements[$name] = $interface_element;
		$this->add_grid_element($name);
		return $interface_element;
	}
	
	public function add_inherited_element($inherited_name, $name, $label_code='') {
		$classname = 'interface_element_'.$inherited_name;
		$interface_element = new $classname($name);
		$interface_element->set_label_code($label_code);
		$this->elements[$name] = $interface_element;
		$this->add_grid_element($name);
		return $interface_element;
	}
	
	protected function get_uid_custom_fields_group($fields_group, $field_property='NAME') {
	    $uid = '';
	    foreach ($fields_group as $field) {
	        if ($uid) {
	            $uid .= "_";
	        }
	        $uid .= $field[$field_property];
	    }
	    return $uid;
	}
	
	protected function get_uid_custom_field($custom_field, $settings=[]) {
	    $uid = $settings['uid_prefix'] ?? '';
	    $field_property = $settings['field_property'] ?? 'NAME';
	    if (!empty($custom_field['FIELDS_GROUPS'])) {
	        $uid .= $this->get_uid_custom_fields_group($custom_field['FIELDS_GROUPS'], $field_property);
	    } else {
	        $uid .= $custom_field[$field_property];
	    }
	    return $uid;
	}
	
	protected function get_html_node_custom_fields_group($fields_group) {
	    global $msg;
	    
	    $add_events = [];
	    $html_node = "<div class='row customfields_aggregator_group'>";
	    foreach ($fields_group as $field) {
	        $html_node .= "<div class='customfields_aggregator_group_cell'>";
	        $html_node .= "<div class='row'><label>".$field["TITRE"]."</label></div>";
	        if (!empty($field["COMMENT_DISPLAY"])) {
	           $html_node .= "<div class='row'>".$field["COMMENT_DISPLAY"]."</div>";
	        }
	        $html_node .= "<div class='row'>".$field["AFF"]."</div>";
	        $html_node .= "</div>";
	        if (!empty($field["ADD_EVENT"])) {
	            $add_events[] = $field['ADD_EVENT'];
	        }
	    }
	    if (!empty($add_events)) {
	        $html_node .= "<div class='customfields_aggregator_group_cell customfields_aggregator_group_cell_button_add'>";
	        $interface_node_button = new interface_node_button();
	        $interface_node_button->set_value($msg['custom_fields_add_button'])
	        ->set_onclick(implode(';', $add_events));
	        $html_node .= $interface_node_button->get_display();
	        $html_node .= "</div>";
	    }
	    $html_node .= "</div>";
	    return $html_node;
	}
	
	protected function add_custom_fields_element($custom_field, $settings=[]) {
	    $uid = $this->get_uid_custom_field($custom_field, $settings);
	    $interface_element = $this->get_instance_interface_element($uid, $custom_field["NAME"]);
	    if (!empty($custom_field['FIELDS_GROUPS']) && is_countable($custom_field['FIELDS_GROUPS'])) {
	        $interface_element->set_display_type('fieldset');
	        $interface_element->set_label($custom_field["TITLE"]);
	        $interface_element->add_html_node($this->get_html_node_custom_fields_group($custom_field['FIELDS_GROUPS']));
	    } else {
	        $interface_element->set_label($custom_field["TITRE"]);
	        if (!empty($custom_field["COMMENT_DISPLAY"])) {
    	        $interface_element->add_html_node($custom_field["COMMENT_DISPLAY"]);
	        }
	        $interface_element->add_html_node($custom_field["AFF"]);
	    }
	    return $interface_element;
	}
	
	public function add_custom_fields_elements($custom_fields, $settings=[]) {
	    $elements = [];
	    foreach ($custom_fields as $custom_field) {
	        $elements[] = $this->add_custom_fields_element($custom_field, $settings);
	    }
	    return $elements;
	}
	
	public function get_element($name) {
		return $this->elements[$name];
	}
	
	public function set_grid_model($grid_model) {
		$this->grid_model = $grid_model;
	}
	
	public function add_grid_element($name) {
		$this->grid_elements[$name] = array(
			'display' => 'row'	
		);
	}
	
	public function set_display_grid_element($name, $display) {
		$this->grid_elements[$name]['display'] = $display;
	}
	
	protected function get_display_column_element($element, $number) {
	    $number = intval($number);
	    $this->current_element++;
	    $display = '';
	    if ($this->current_element % $number == 1) {
	        $display .= "<div class='row'>";
	    }
	    $display .= $element->get_display();
	    if ($this->current_element % $number == 0 || $this->current_element == count($this->elements)) {
	        $display .= "</div>";
	    }
	    return $display;
	}
	
	protected function get_display_element($element) {
	    switch($this->grid_model) {
	        case 'flat_column_25':
	            return $element->get_display_flat('25');
	        case 'flat_column_3':
	            return $element->get_display_flat('3');
	        case 'flat_column_40':
	            return $element->get_display_flat('40');
	        case 'flat_column_2_right':
	            return $element->get_display_flat('2', 'right');
	        case 'flat_column_25_right':
	            return $element->get_display_flat('25', 'right');
	        case 'flat_column_4_right':
	            return $element->get_display_flat('4', 'right');
	        case 'tr_column_2_right':
	            return $element->get_display_tr('2', 'right');
	        case 'column_3':
	            return $this->get_display_column_element($element, 3);
	        default:
	            return $element->get_display();
	    }
	}
	
	public function get_display_elements() {
		$display = '';
		foreach ($this->elements as $element) {
		    $display .= $this->get_display_element($element);
		}
		return $display;
	}
	
	public function get_display_zones() {
		$display = '';
		foreach ($this->zones as $zone) {
			$display .= $zone->get_display();
		}
		return $display;
	}
	
	public function get_display() {
		$display = '';
		if(!empty($this->zones)) {
			$display .= $this->get_display_zones();
		} else {
			$display .= $this->get_display_elements();
		}
		return $display;
	}
}