<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_datasource_segment_records.class.php,v 1.1.4.2 2025/08/26 14:22:52 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_datasource_segment_records extends cms_module_common_datasource_records_list
{

	public function __construct($id = 0)
	{
		parent::__construct($id);
		$this->paging = true;
	}

	/*
	 * On dfini les slecteurs utilisable pour cette source de donne
	 */
	public function get_available_selectors()
	{
		return array(
			"cms_module_common_selector_segments"
		);
	}

	/*
	 * Rcupration des donnes de la source...
	 */
	public function get_datas()
	{
		global $opac_url_base;

		$return = array();
		$selector = $this->get_selected_selector();
		if ($selector) {
			$value = $selector->get_value();
			$segment_id = intval($value[0]);
			$records = array();
			if ($segment_id != 0) {
				$search_segment = search_segment::get_instance($segment_id);
				$table = $search_segment->get_set()->make_search();
				$query = "select notice_id from $table";
				$result = pmb_mysql_query($query);
				if (pmb_mysql_num_rows($result)) {
					while ($row = pmb_mysql_fetch_object($result)) {
						$records[] = $row->notice_id;
					}
				}
				$return['records'] = $this->filter_datas("notices", $records);
			}

			if (!is_countable($return['records']) || !count($return['records'])) {
				return false;
			}

			//On trie soit depuis la datasource soit depuis le segment selon le paramtrage
			if (0 == $this->parameters['keep_segment_sort']) {
				$return = $this->sort_records($return['records']);
			} else {
				$return['records'] = $search_segment->get_sort()->sort_data($return['records'], $table);
			}

			$return["title"] = $this->msg["cms_module_common_datasource_segment_records_title"];
			$return["source_infos"] = array();
			$return["source_infos"][] = array(
				"name" => $search_segment->get_label(),
				"url" => $opac_url_base . 'index.php?lvl=search_segment&id=' . $segment_id,
				"id" => $segment_id,
				"type" => "segment",
				"thumbnail_url" => $search_segment->get_logo()
			);

			// Pagination
			if ($this->paging && isset($this->parameters['paging_activate']) && $this->parameters['paging_activate'] == "on") {
				$return["paging"] = $this->inject_paginator($return['records']);
				$return['records'] = $this->cut_paging_list($return['records'], $return["paging"]);
			}

			return $return;
		}
		return false;
	}

	public function get_form()
	{
		$form = parent::get_form();
		$form .= '
        <div class="row">
            <div class="colonne3">
				<label for="' . $this->get_form_value_name('keep_segment_sort') . '">' . $this->format_text($this->msg['cms_module_common_datasource_segment_records_keep_segment_sort']) . '</label>
			</div>
            <div class="colonne_suite">
                ' . $this->format_text($this->msg['yes']) . ' <input type="radio" ' . ($this->parameters['keep_segment_sort'] == 1 ? 'checked="checked"' : '') . ' name="' . $this->get_form_value_name('keep_segment_sort') . '" value="1"/>
                ' . $this->format_text($this->msg['no']) . ' <input type="radio" ' . ($this->parameters['keep_segment_sort'] == 0 ? 'checked="checked"' : '') . ' name="' . $this->get_form_value_name('keep_segment_sort') . '" value="0"/>
			</div>
        </div>';

		return $form;
	}

	public function save_form()
	{
		$this->parameters['keep_segment_sort'] = $this->get_value_from_form('keep_segment_sort');
		return parent::save_form();
	}
}
