<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_entity_record_expl_content_form.class.php,v 1.1.4.5 2025/12/08 11:45:29 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_entity_record_expl_content_form extends interface_entity_content_form {
	
    protected $id_notice;
    
    protected $id_bulletin;
    
    protected function _init_elements_data() {
        global $pmb_expl_show_dates;
        
        // Code-barres
        $this->_add_element_data('f_ex_cb', 'el0Child_0', '291');
        // Cote
        $this->_add_element_data('f_ex_cote', 'el0Child_1_a', '296');
        // Type de document
        $this->_add_element_data('f_ex_typdoc', 'el0Child_1_b', '294');
        
        // Localisation
        $this->_add_element_data('f_ex_location', 'el0Child_2_a', '298');
        // Proprietaire
        $this->_add_element_data('f_ex_owner', 'el0Child_2_c', '651');
        // Statut
        $this->_add_element_data('f_ex_statut', 'el0Child_3_a', '297');
        // Code statistique
        $this->_add_element_data('f_ex_cstat', 'el0Child_3_b', '299');
        
        //Type antivol
        $this->_add_element_data('type_antivol', 'el0Child_3_c', 'type_antivol');
            
        //Message exemplaire 
        $this->_add_element_data('f_ex_note', 'el0Child_4', 'expl_message');
        
        // Commentaire non bloquant
        $this->_add_element_data('f_ex_comment', 'el0Child_5', 'expl_zone_comment');
        
        // Prix
        $this->_add_element_data('f_ex_prix', 'el0Child_6_a', 'expl_price');
        if ($pmb_expl_show_dates=='1' || $pmb_expl_show_dates=='3') {
            //Date creation
            $this->_add_element_data('exp_cre_date', 'el0Child_6_b_0', 'exp_cre_date');
            //Date modification
            $this->_add_element_data('exp_upd_date', 'el0Child_6_b_1', 'exp_upd_date');
        }
        if ($pmb_expl_show_dates=='2' || $pmb_expl_show_dates=='3') {
            //Date dpt
            $this->_add_element_data('filing_date', 'el0Child_6_c_0', 'filing_date');
            //Date retour
            $this->_add_element_data('return_date', 'el0Child_6_c_1', 'return_date');
        }
    }

    public function add_expl_element($name) {
        $data = $this->get_element_data($name);
        $interface_element = interface_entity_element::get_instance($data['uid'], $name, $data['label_code']);
        $this->elements[$name] = $interface_element;
        $this->add_grid_element($name);
        switch ($name) {
            case 'f_ex_cb':
            case 'f_ex_note':
            case 'f_ex_comment':
                break;
            default:
                $interface_element->set_class('colonne3');
                break;
        }
        return $interface_element;
    }
    
    public function add_element_code($name, $value = '') {
        global $msg;
        
        if ($this->id_notice) {
            $id = $this->id_notice;
        } else {
            $id = $this->id_bulletin;
        }
        $element = $this->add_expl_element("f_".$name);
        $attributes = ['readonly' => 'readonly'];
        $element->add_input_node('text', $value, $attributes)
        ->set_class('saisie-20emr');
        $element->add_input_node('button', $msg['parcourir'])
        ->set_id("f_".$name."_button_browse")
        ->set_name("f_".$name."_button_browse")
        ->set_click("openPopUp('./catalog/expl/setcb.php?id=".$id."', 'getcb')");
        if (file_exists("print_cb.php")) {
            $element->add_input_node('button', $msg['print_print'])
            ->set_id("f_".$name."_button_print")
            ->set_name("f_".$name."_button_print")
            ->set_click("h=new http_request(); h.request(\"print_cb.php?cb=\"+document.getElementById(\"f_ex_cb\").value, false,\"\", false, function(){},function(){},\"impr_cb\")");
        }
        $element->set_display_nodes_separator('&nbsp;');
        return $element;
    }
    
    public function add_element_cote($name, $value = '') {
        global $pmb_prefill_cote_ajax, $pmb_antivol;
        
        $cote_attributes = [];
        if ($this->id_notice) {
            //Remplissage ajax de la cote
            if($pmb_prefill_cote_ajax) {
                $cote_attributes = [
                    'completion' => 'expl_cote',
                    'listfield' => $this->ajax_cote_fields.",f_ex_cb,f_ex_typdoc,f_ex_location,f_ex_owner,f_ex_statut,f_ex_cstat".($pmb_antivol>0 ? ",type_antivol":"")
                ];
            }
        }
        $element = $this->add_expl_element("f_".$name);
        $element->add_input_node('text', $value, $cote_attributes)
        ->set_class('saisie-20em');
        return $element;
    }
    
    public function add_element_query($name, $selected=0) {
        $element = $this->add_expl_element("f_".$name);
        switch ($name) {
            case 'ex_typdoc':
                $table = 'docs_type';
                break;
            case 'ex_owner':
                $table = 'lenders';
                break;
            case 'ex_statut':
                $table = 'docs_statut';
                break;
            case 'ex_cstat':
                $table = 'docs_codestat';
                break;
        }
        $defltvar="deflt_".$table;
        global ${$defltvar};
        if ($selected == 0) {
            $selected = ${$defltvar};
        }
        $element->add_query_node('select', "SELECT * FROM $table order by 2", $selected);
        return $element;
    }
    
    public function add_element_location($name, $selected=0) {
        global $explr_visible_mod, $pmb_droits_explr_localises ;
        
        //visibilit des exemplaires
        if ($pmb_droits_explr_localises) {
            $where_clause_explr = "idlocation in (".$explr_visible_mod.") and";
        } else {
            $where_clause_explr = "";
        }
        $element = $this->add_expl_element("f_".$name);
        $element->add_html_node(gen_liste ("select distinct idlocation, location_libelle from docs_location, docsloc_section where $where_clause_explr num_location=idlocation order by 2 ", "idlocation", "location_libelle", 'f_ex_location', "calcule_section(this);", $selected, "", "","","",0));
        return $element;
    }
    
    public function add_element_price($name, $value='') {
        $element = $this->add_expl_element("f_".$name);
        $element->add_input_node('float', $value);
        return $element;
    }
    
    public function add_element_antivol($name, $selected=0) {
        global $msg, $charset, $pmb_antivol;
        
        if($pmb_antivol) {
            $element = $this->add_expl_element($name);
            $element->add_html_node(exemplaire::gen_antivol_selector($selected));
            return $element;
        }
        $data = $this->get_element_data($name);
        return "<div id='".$data['uid']."' movable='yes' class='colonne3' title=\"".htmlentities($msg[$data['label_code']], ENT_QUOTES, $charset)."\">
			</div>";
    }
    
    public function add_element_text_date($name, $content) {
        $element = $this->add_expl_element($name);
        $element->set_class('colonne2')
        ->set_movable(false);
        $element->add_text_node(format_date($content));
        return $element;
    }

    public function set_id_notice($id_notice) {
        $this->id_notice = intval($id_notice);
        return $this;
    }
    
    public function set_id_bulletin($id_bulletin) {
        $this->id_bulletin = intval($id_bulletin);
        return $this;
    }
}