<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_entity_reader_content_form.class.php,v 1.1.4.4 2025/12/01 14:00:18 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_entity_reader_content_form extends interface_entity_content_form {
	
    protected function _init_elements_simple_data() {
        global $ldap_accessible;
        global $pmb_opac_view_activate;
        
        // Nom
        $this->_add_element_data('form_nom', 'g0_r0_f0', '67');
        // Prnom
        $this->_add_element_data('form_prenom', 'g0_r0_f1', '68');
        // Code-barres
        $this->_add_element_data('f_cb', 'g0_r0_f2', '38');
        // Camra
        
        
        // Adresse 1
        $this->_add_element_data('form_adr1', 'g0_r1_f0', '69');
        // Code postal
        $this->_add_element_data('form_cp', 'g0_r1_f1', '71');
        // Ville
        $this->_add_element_data('form_ville', 'g0_r1_f2', '72');
        // Adresse 2
        $this->_add_element_data('form_adr2', 'g0_r2_f0', '70');
        // Pays
        $this->_add_element_data('form_pays', 'g0_r2_f1', 'empr_pays');
        // Tlphone 1
        $this->_add_element_data('form_tel1', 'g0_r3_f0', '73');
        // Tlphone 2
        $this->_add_element_data('form_tel2', 'g0_r3_f1', '73tel2');
        // E-mail
        $this->_add_element_data('form_mail', 'g0_r3_f2', '58'); // id = form_mail_input
        
        // Profession
        $this->_add_element_data('form_prof', 'g1_r0_f0', '74');
        // Sexe
        $this->_add_element_data('form_sexe', 'g1_r0_f1', '125');
        // Date de naissance
        $this->_add_element_data('form_year', 'g1_r0_f2', '75');
        
        // Categorie
        $this->_add_element_data('form_categ', 'g2_r0_f0', '59');
        // Code statistique
        $this->_add_element_data('form_codestat', 'g2_r0_f1', '60');
        // Ajout  un groupe existant
        $this->_add_element_data('form_ajoutgroupe', 'g2_r0_f2', 'empr_form_ajoutgroupe');
        // Localisation
        $this->_add_element_data('empr_location_id', 'g2_r1_f0', 'empr_location');
        
        // Adhsion
        
        // Fin d'adhsion
        
        // Relance d'adhsion
        
        // Langue
        $this->_add_element_data('empr_lang', 'g4_r0_f0', 'empr_langue_opac');
        // Login
        $this->_add_element_data('form_empr_login', 'g4_r0_f1', 'empr_login');

        // LDAP
        if ($ldap_accessible) {
            $this->_add_element_data('form_ldap', 'g4_r0_f2', 'AuthLDAP');
        }
        // Mot de passe
        $this->_add_element_data('form_empr_password', 'g4_r0_f3', 'empr_password');
        
        // Message
        $this->_add_element_data('form_empr_msg', 'g5_r0_f0', '523');
        
        // Vues OPAC
        if($pmb_opac_view_activate){
            $this->_add_element_data('form_opac_views', 'g4_r1_f0', 'empr_form_opac_view');
        }
    }
    
    protected function _init_elements_advanced_data() {
        global $ldap_accessible;
        global $pmb_opac_view_activate;
        
        // Nom
        $this->_add_element_data('form_nom', 'el0Child_0_a', '67');
        // Prnom
        $this->_add_element_data('form_prenom', 'el0Child_0_b', '68');
        // Code-barres
        $this->_add_element_data('f_cb', 'el0Child_1', '38');
        // Camra
        //         !!camera!! $this->_add_element_data('', 'el0Child_2', '');
        
        // Adresse 1
        $this->_add_element_data('form_adr1', 'el0Child_3_a', '69');
        // Code postal
        $this->_add_element_data('form_cp', 'el0Child_3_b', '71');
        // Ville
        $this->_add_element_data('form_ville', 'el0Child_3_c', '72');
        // Adresse 2
        $this->_add_element_data('form_adr2', 'el0Child_4_a', '70');
        // Pays
        $this->_add_element_data('form_pays', 'el0Child_4_b', 'empr_pays');
        // Tlphone 1
        $this->_add_element_data('form_tel1', 'el0Child_5_a', '73');
        // Tlphone 2
        $this->_add_element_data('form_tel2', 'el0Child_5_b', '73tel2');
        // E-mail
        $this->_add_element_data('form_mail', 'el0Child_5_c', '58'); // id = form_mail_input
        
        // Profession
        $this->_add_element_data('form_prof', 'el0Child_6_a', '74');
        // Sexe
        $this->_add_element_data('form_sexe', 'el0Child_6_b', '125');
        // Date de naissance
        $this->_add_element_data('form_year', 'el0Child_6_c', '75');
        
        // Categorie
        $this->_add_element_data('form_categ', 'el0Child_7_a', '59');
        // Code statistique
        $this->_add_element_data('form_codestat', 'el0Child_7_b', '60');
        // Ajout  un groupe existant
        $this->_add_element_data('form_ajoutgroupe', 'el0Child_7_c', 'empr_form_ajoutgroupe');
        // Localisation
        $this->_add_element_data('empr_location_id', 'el0Child_8', 'empr_location');
        
        // Adhsion
        
        // Fin d'adhsion
        
        // Relance d'adhsion
        
        // Langue
        $this->_add_element_data('empr_lang', 'el0Child_11_a', 'empr_langue_opac');
        // Login
        $this->_add_element_data('form_empr_login', 'el0Child_11_b', 'empr_login');
        
        // Mot de passe
        $this->_add_element_data('form_empr_password', 'el0Child_11_c', 'empr_password');
        // LDAP
        if ($ldap_accessible) {
            $this->_add_element_data('form_ldap', 'el0Child_11_d', 'AuthLDAP');
        } else {
            $this->_add_element_data('form_ldap', 'el0Child_11_d');
        }
        
        
        // Message
        $this->_add_element_data('form_empr_msg', 'el0Child_13', '523');
        
        // Vues OPAC
        if($pmb_opac_view_activate){
            $this->_add_element_data('form_opac_views', 'el0Child_12', 'empr_form_opac_view');
        }
    }
    
    protected function _init_elements_data() {
        global $pmb_form_empr_editables;
        
        if($pmb_form_empr_editables == 2) {
            $this->_init_elements_advanced_data();
        } else {
            $this->_init_elements_simple_data();
        }
    }
    
    public function add_element($name, $label_code='', $display_type='row') {
        $data = $this->get_element_data($name);
        if (empty($label_code)) {
            $label_code = $data['label_code'];
        }
        $interface_element = $this->get_instance_interface_element($data['uid'], $name, $label_code, $display_type);
        $this->elements[$name] = $interface_element;
        $this->add_grid_element($name);
        return $interface_element;
    }
    
    public function add_element_html_value($name, $value) {
        global $charset;
        global $empr_content_form_data;
        
        $element = $this->add_element($name);
        $content = str_replace("!!value!!", htmlentities($value, ENT_QUOTES, $charset), $empr_content_form_data[$name]);
        $element->add_html_node($content);
        return $element;
    }
}