<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: interface_entity_content_form.class.php,v 1.1.4.3 2025/12/01 14:00:18 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class interface_entity_content_form extends interface_content_form {
	
    protected $object_id;
    
    protected $tabs_data = [];
    
    protected $elements_data = [];
    
    public function __construct($name = ''){
        parent::__construct($name);
        $this->_init_tabs_data();
        $this->_init_elements_data();
    }
    
    protected function _add_tab_data($uid, $label_code, $title_code='', $expanded=false) {
        global $msg;
        
        if (!empty($label_code)) {
            $label = $msg[$label_code];
            if (empty($title_code)) {
                $title_code = $label_code;
            }
        }
        if (!empty($title_code)) {
            $title = $msg[$title_code];
        }
        if (empty($title)) {
            $title = $label;
        }
        $this->tabs_data[$uid] = [
            'uid' => $uid, 
            'label_code' => $label_code,
            'label' => $label,
            'title_code' => $title_code,
            'title' => $title,
            'expanded' => $expanded
        ];
    }
    
    protected function _add_element_data($name, $uid, $label_code='') {
        $this->elements_data[$name] = [
            'name' => $name, 
            'uid' => $uid, 
            'label_code' => $label_code
        ];
    }
    
    /**
     * Initialisation des onglets
     */
    protected function _init_tabs_data() {
        
    }
    
    /**
     * Initialisation des lments
     */
    protected function _init_elements_data() {
        
    }
    
    public static function get_instance_interface_element($uid, $name, $label_code='', $display_type='row') {
        return interface_entity_element::get_instance($uid, $name, $label_code, $display_type);
    }
    
    public function get_tab_data($uid) {
        return $this->tabs_data[$uid];
    }
    
    public function get_element_data($name) {
        return $this->elements_data[$name];
    }

    public function set_object_id($object_id) {
        $this->object_id = intval($object_id);
        return $this;
    }
}