<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AnimationListItem.php,v 1.1.4.3 2025/07/21 13:05:45 rtigero Exp $

namespace Pmb\DSI\Models\Item\Entities\Animation\AnimationListItem;

use Pmb\Animations\Models\AnimationModel;
use Pmb\Common\Helper\Helper;
use Pmb\DSI\Models\Item\SimpleItem;

class AnimationListItem extends SimpleItem
{
    public const TYPE = TYPE_ANIMATION;

    public function getTree($parent = true)
    {
        $tree = (new AnimationModel())->getCmsStructure("animations[i]");
        return $parent ? array_merge($tree, parent::getTree()) : $tree;
    }

    public function getLabels($ids)
    {
        if (is_object($ids)) {
            $ids = Helper::toArray($ids);
        }

        $animations = [];
        foreach ($ids as $id) {
            $animation = new AnimationModel($id);
            if (!empty($animation->name)) {
                $animations[$id] = $animation->name;
            }
        }
        return $animations;
    }
}
