<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AnimationSearchModel.php,v 1.1.2.3 2025/06/26 13:22:07 jparis Exp $

namespace Pmb\Animations\Models;

use Pmb\Common\Models\SearchModel;

class AnimationSearchModel extends SearchModel
{
    /**
     * Add Filter
     *
     * @param string $query
     * @param string $labelId
     * @return string
     */
    protected function addFilter(string $query, $labelId)
    {
        if (isset($this->filter)) {

            $clause = [];
            $joinAnimations = ' JOIN anim_animations on anim_animations.id_animation=' . $labelId;
            
            if (!empty($this->filter['status']) && false === array_search(0, $this->filter['status'])) {
                $clause[] = ' num_status IN ('. implode(',', $this->filter['status']) .')';
            }

            if (!empty($this->filter['types']) && false === array_search(0, $this->filter['types'])) {
                $clause[] = ' num_type IN ('. implode(',', $this->filter['types']) .')';
            }

            if (!empty($this->filter['locations']) && false === array_search(0, $this->filter['locations'])) {
                $joinLocations = ' join anim_animation_locations on anim_animation_locations.num_animation=' . $labelId;
                $clause[] = ' anim_animation_locations.num_location IN ('. implode(',', $this->filter['locations']) .')';
            }

            if (!empty($this->filter['communication_type']) && false === array_search(0, $this->filter['communication_type'])) {
                $joinCommunicationType = ' join anim_mailings on anim_mailings.num_animation=' . $labelId;
                $clause[] = ' anim_mailings.num_mailing_type IN ('. implode(',', $this->filter['communication_type']) .')';
            }

            // Gestion du tri
            // Tableau associatif des colonnes valides pour le tri
            $validColumns = [
                'name' => 'anim_animations.name',
                'startDate' => 'anim_events.start_date',
                'endDate' => 'anim_events.end_date',
                'statusLabel' => 'anim_status.label',
                'typeLabel' => 'anim_types.label',
                'calendar' => 'anim_calendar.name'
            ];

            $sortClause = '';
            $joinSort = null;
            if (!empty($this->sort['name']) && isset($validColumns[$this->sort['name']])) {

                switch($this->sort['name']) {
                    case 'startDate':
                    case 'endDate':
                        $joinSort = ' JOIN anim_events ON anim_events.id_event = anim_animations.num_event';
                        break;
                    case 'statusLabel':
                        $joinSort = ' JOIN anim_status ON anim_status.id_status = anim_animations.num_status';
                        break;
                    case 'typeLabel':
                        $joinSort = ' JOIN anim_types ON anim_types.id_type = anim_animations.num_type';
                        break;
                    case 'calendar':
                        $joinSort = ' JOIN anim_calendar ON anim_calendar.id_calendar = anim_animations.num_calendar';
                }

                $column = $validColumns[$this->sort['name']];
                $sortDirection = (isset($this->sort['direction']) && $this->sort['direction'] === 'desc') ? 'DESC' : 'ASC';
                $sortClause = ' ORDER BY ' . $column . ' ' . $sortDirection;
            }

            if (!empty($joinAnimations)) {
                $query .= " " . $joinAnimations;
            }

            if (!empty($joinSort)) {
                $query .= $joinSort;
            }

            if (!empty($clause)) {
                if (!empty($joinLocations)) {
                    $query .= " " . $joinLocations;
                }
                if (!empty($joinCommunicationType)) {
                    $query .= " " . $joinCommunicationType;
                }

                $query .= ' WHERE ' . implode(' AND ', $clause);
            }

            // Ajout du tri
            $query .= $sortClause;
        }
        return $query;
    }
}
