<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: selector_searcher_frais.class.php,v 1.1.4.3 2025/11/05 15:19:15 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

//Classe de recherche pour selecteurs
global $class_path;
require_once("$class_path/sel_searcher.class.php");

class selector_searcher_frais extends sel_searcher {
    
    public $t_query;
    public $cur_typ_query='frais';
    
    public function make_first_search() {
        
        global $msg;
        global $elt_query;
        global $results_show_all;
        
        $aq=new analyse_query(stripslashes($elt_query));
        if ($aq->error) {
            $this->show_form();
            error_message($msg["searcher_syntax_error"],sprintf($msg["searcher_syntax_error_desc"],$aq->current_car,$aq->input_html,$aq->error_message));
        } else {
            $q_count=$aq->get_query_count('frais','libelle','index_libelle','id_frais');
            $r_count = pmb_mysql_query($q_count);
            $n_count = pmb_mysql_result($r_count,0,0);
            $this->nbresults = $n_count;
            
            if(!$results_show_all){
                $q_list = $aq->get_query('frais','libelle','index_libelle','id_frais', '', $this->get_start_page() , $this->get_nb_per_page());
            }else{
                $q_list = $aq->get_query('frais','libelle','index_libelle','id_frais');
            }
            $r_list = pmb_mysql_query($q_list);
            $this->t_query=$r_list;
            if(!$results_show_all){
                $this->nbepage=ceil($this->nbresults/$this->get_nb_per_page());
            }else{
                $this->nbepage=1;
            }
            return ELT_LIST;
        }
    }
    
    public function get_title_elt_list() {
        global $msg;
        
        return $msg['selector_lib_frais'];
    }
    
    public function get_instance_sel_display($row) {
        return new selector_display_frais($row->id_frais, $this->base_url,'sel_searcher_select_');
    }
    
    public function get_js_function_add_selection($callback_set_parent='') {
        global $callback;
        
        $callback_set_parent = "
        set_parent(elt.getAttribute('attr_id'),
        elt.getAttribute('attr_typ_lig'),
		elt.getAttribute('attr_nom_acte'),
		elt.getAttribute('attr_montant'),
		elt.getAttribute('attr_taux_tva'),
		'".$callback."');";
        return parent::get_js_function_add_selection($callback_set_parent);
    }
    
    public function get_title_column_number() {
        global $msg;
        
        return $msg['acquisition_frais_montant'];
    }
}