<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_url.class.php,v 1.4.2.1.2.3 2025/11/18 14:22:48 dgoron Exp $

use Pmb\Common\Library\CSRF\CollectionCSRF;

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_url extends custom_fields {
	
    protected static $type = 'url';
    
	protected static function get_chk_values($name) {
        global ${$name};
        $val = ${$name};
        $value = array();
        if (!empty($val['link']) && is_array($val['link'])) {
            $nb_vals = count($val['link']);
            for ($i = 0; $i < $nb_vals; $i++) {
                if ($val['link'][$i] != "") {
                    $linktarget = '|0';
                    if (!empty($val['linktarget'][$i])) {
                        $linktarget = '|1';
                    }
                    $value[] = $val['link'][$i]."|".$val['linkname'][$i].$linktarget;
                }
            }
        }
        return $value;
    }
    
    public static function val($field, $value) {
        global $charset,$pmb_perso_sep;
        $cut = $field['OPTIONS'][0]['MAXSIZE'][0]['value'];
        $values=format_output($field,$value);
        $ret = "";
        $without = "";
        $details = array();
        for ($i=0;$i<count($values);$i++){
            $val = explode("|",$values[$i]);
            if (isset($val[1]) && $val[1])$lib = $val[1];
            else $lib = ($cut && strlen($val[0]) > $cut ? substr($val[0],0,$cut)."[...]" : $val[0] );
            if( $ret != "") $ret.= $pmb_perso_sep;
            $target = '_blank';
            if (isset($val[2]) && ($val[2] == 0)) {
                $target = '_self';
            }
            $ret .= "<a href='".$val[0]."' target='".$target."'>".htmlentities($lib, ENT_QUOTES, $charset)."</a>";
            if( $without != "") $without.= $pmb_perso_sep;
            $without .= $val[0];
            $details[] = array('url' => $val[0], 'label' => $lib, 'target' => $target);
        }
        return array("ishtml" => true, "value"=>$ret, "withoutHTML" =>$without, "details" => $details);
    }
    
    protected static function get_js_function_add($field) {
        global $msg;
        
        return "<script>
			function add_custom_url_(field_id, field_name, field_size) {
				cpt = document.getElementById('customfield_url_'+field_id).value;
				var check = document.createElement('div');
				check.setAttribute('id',field_name+'_check_'+cpt);
				check.setAttribute('style','display:inline');
				var link_label = document.createTextNode('".$msg['persofield_url_link']."');
				var chklnk = document.createElement('input');
				chklnk.setAttribute('type','button');
				chklnk.setAttribute('value','".$msg['persofield_url_check']."');
				chklnk.setAttribute('class','bouton');
				chklnk.setAttribute('onclick','cp_chklnk_'+field_name+'('+cpt+',this);');
				document.getElementById('customfield_url_'+field_id).value = cpt*1 +1;
				var link = document.createElement('input');
		        link.setAttribute('name',field_name+'[link][]');
		        link.setAttribute('id',field_name+'_link'+cpt);
		        link.setAttribute('type','text');
				link.setAttribute('class','saisie-30em');
		        link.setAttribute('size',field_size);
		        link.setAttribute('value','');
				link.setAttribute('onchange','cp_chklnk_'+field_name+'('+cpt+',this);');
				var lib_label = document.createTextNode('".$msg['persofield_url_linklabel']."');
				var lib = document.createElement('input');
		        lib.setAttribute('name',field_name+'[linkname][]');
		        lib.setAttribute('id',field_name+'_linkname'+cpt);
		        lib.setAttribute('type','text');
				lib.setAttribute('class','saisie-15em');
		        lib.setAttribute('size',field_size);
		        lib.setAttribute('value','');
				var target = document.createElement('input');
				target.setAttribute('name',field_name+'[linktarget][]');
		        target.setAttribute('id',field_name+'_linktarget'+cpt);
		        target.setAttribute('type','checkbox');
		        target.setAttribute('value','1');
		        target.setAttribute('checked','checked');
				var targetlabel = document.createElement('label');
				targetlabel.setAttribute('for',field_name+'_linktarget'+cpt);
				targetlabel.innerHTML = ' ".$msg['persofield_url_linktarget']."';
		        space=document.createElement('br');
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(check);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(link_label);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(link);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(document.createTextNode(' '));
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(chklnk);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(document.createTextNode(' '));
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(lib_label);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(lib);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(document.createTextNode(' '));
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(target);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(targetlabel);
				document.getElementById('spaceformorecustomfieldurl_'+field_id).appendChild(space);
			}
		</script>";
    }
    
    protected static function get_event_button_add($field) {
        $options=$field['OPTIONS'][0];
        return 'add_custom_url_(\''.$field['ID'].'\', \''.addslashes($field['NAME']).'\', \''.addslashes($options['SIZE'][0]['value']).'\')';
    }
    
    public static function get_aff_values($field) {
        $options=$field['OPTIONS'][0];
        $values=$field['VALUES'];
        if (empty($values)) {
            $linktarget_default_checked = (isset($options['LINKTARGET'][0]['value']) && $options['LINKTARGET'][0]['value'] ? 1 : 0);
            $values = array("||".$linktarget_default_checked);
        }
        return $values;
    }
    
    public static function get_display_value($field, $indice, $value) {
        global $msg, $charset;
        
        $options=$field['OPTIONS'][0];
        $avalues = explode("|",$value);
        $display = "<div id='".$field['NAME']."_check_$indice' style='display:inline'></div>";
        $display .= $msg['persofield_url_link']."<input id='".$field['NAME']."_link".$indice."' type='text' class='saisie-30em' name='".$field['NAME']."[link][".$indice."]' data-form-name='".$field['NAME']."_link' onchange='cp_chklnk_".$field["NAME"]."(".$indice.",this);' value='".htmlentities($avalues[0], ENT_QUOTES, $charset)."'>";
        $display .= " <input class=\"bouton\" type='button' value='".$msg['persofield_url_check']."' onclick='cp_chklnk_".$field["NAME"]."(".$indice.",this);'>";
        //$display .= "<br />";
        $display .= "&nbsp;".$msg['persofield_url_linklabel']."<input id='".$field['NAME']."_linkname".$indice."' type='text' class='saisie-15em' size='".$options['SIZE'][0]['value']."' name='".$field['NAME']."[linkname][".$indice."]' data-form-name='".$field['NAME']."_linkname' value='".htmlentities($avalues[1], ENT_QUOTES, $charset)."'>";
        $target_checked = 'checked="checked"';
        //$value_check = 1;
        if (isset($avalues[2]) && ($avalues[2] == 0)) {
            $target_checked = '';
            //$value_check = 0;
        }
        $display .= "&nbsp;<input id='".$field['NAME']."_linktarget".$indice."' type='checkbox' name='".$field['NAME']."[linktarget][".$indice."]' data-form-name='".$field['NAME']."_linktarget' value='1' ".$target_checked."><label for='".$field['NAME']."_linktarget".$indice."'>&nbsp;".$msg['persofield_url_linktarget']."</label>&nbsp;";
        return $display;
    }
    
    public static function get_block_dnd($field, $indice, $html, $value='') {
        $exploded_value = explode("|",$value);
        return parent::get_block_dnd($field, $indice, $html, $exploded_value[0]);
    }
    
    public static function aff($field, &$check_scripts) {
        $ret = parent::aff($field, $check_scripts);
        
        $options=$field['OPTIONS'][0];
        
        $collectionCSRF = new CollectionCSRF();
        
        $ret.= "
	<script>
        var tabTokens_".$field['NAME']." = " . json_encode($collectionCSRF->getArrayTokens()) . ";
		function cp_chklnk_".$field["NAME"]."(indice,element){
			var link = element.form.elements['".$field['NAME']."[link]['+indice+']'];
			if(link.value != ''){
				var wait = document.createElement('img');
				wait.setAttribute('src','".get_url_icon('patience.gif')."');
				wait.setAttribute('align','top');
				while(document.getElementById('".$field['NAME']."_check_'+indice).firstChild){
					document.getElementById('".$field['NAME']."_check_'+indice).removeChild(document.getElementById('".$field['NAME']."_check_'+indice).firstChild);
				}
				document.getElementById('".$field['NAME']."_check_'+indice).appendChild(wait);
                var csrf_token = tabTokens_".$field['NAME']."[0];
                tabTokens_".$field['NAME'].".splice(0, 1);
				var testlink = encodeURIComponent(link.value);
	 			var check = new http_request();
				if(check.request('./ajax.php?module=ajax&categ=chklnk',true,'&timeout=".$options['TIMEOUT'][0]['value']."&link='+testlink+'&csrf_token='+csrf_token)){
					alert(check.get_text());
				}else{
					var result = check.get_text();
					var type_status=result.substr(0,1);
					var img = document.createElement('img');
					var src='';
			    	if(type_status == '2' || type_status == '3'){
						if((link.value.substr(0,7) != 'http://') && (link.value.substr(0,8) != 'https://')) link.value = 'http://'+link.value;
						//impec, on print un petit message de confirmation
						src = '".get_url_icon('tick.gif')."';
					}else{
						//problme...
						src = '".get_url_icon('error.png')."';
						img.setAttribute('style','height:1.5em;');
					}
					img.setAttribute('src',src);
					img.setAttribute('align','top');
					while(document.getElementById('".$field['NAME']."_check_'+indice).firstChild){
						document.getElementById('".$field['NAME']."_check_'+indice).removeChild(document.getElementById('".$field['NAME']."_check_'+indice).firstChild);
					}
					document.getElementById('".$field['NAME']."_check_'+indice).appendChild(img);
				}
			}
		}
	</script>";
        return $ret;
    }
    
    public static function aff_search($field,&$check_scripts,$varname) {
        global $charset;
        
        $options = $field['OPTIONS'][0];
        $values = $field['VALUES'];
        if(!isset($values[0])) {
            $values[0] = '';
        }
        $ret="<input id=\"".$varname."\" type=\"text\" size=\"".$options['SIZE'][0]['value']."\" name=\"".$varname."[]\" value=\"".htmlentities($values[0],ENT_QUOTES,$charset)."\">";
        return $ret;
    }
    
    public static function get_rgaa_label($field, $varname) {
        return $field['NAME']."_linkname0";
    }
}