# Connecteur MusicMe pour PMB

Connecteur d'enrichissement permettant d'ajouter des liens vers le service de streaming musical MusicMe sur les notices de votre catalogue PMB.

## Fonctionnalits

- Enrichissement des notices avec des liens de recherche MusicMe
- Redirection automatique vers la recherche d'albums sur la plateforme MusicMe
- Configuration simple avec URL personnalisable

## Installation

### 1. Fichiers requis

Les fichiers du connecteur doivent tre prsents dans :
- **Gestion** : `/admin/connecteurs/in/musicme/`
- **OPAC** : `/opac_css/admin/connecteurs/in/musicme/`

Structure des fichiers :
```
musicme/
   manifest.xml
   musicme.class.php
   messages/
      fr_FR.xml
      en_UK.xml
   README.md
```

### 2. Activation dans PMB

1. Aller dans **Administration > Connecteurs > Connecteurs externes**
2. Cliquer sur **Ajouter une source**
3. Slectionner **MusicMe** dans la liste des connecteurs
4. Configurer les paramtres

## Configuration

### Paramtres de la source

Lors de la cration d'une source MusicMe, vous devez configurer :

#### URL MusicMe
**Champ** : `musicme_url`
**Valeur par dfaut** : `https://app.mt.musicme.com`
**Description** : URL de base de la plateforme MusicMe

Options possibles :
- **URL gnrique** : `https://app.mt.musicme.com` (par dfaut)
- **URL personnalise** : `https://votre-bibliotheque.mt.musicme.com` (si vous avez une instance ddie)

### Exemple de configuration

```
URL MusicMe: https://app.mt.musicme.com
```

## Utilisation

### Enrichissement de notices

1. Aller sur une notice dans PMB (gestion ou OPAC)
2. L'onglet **Enrichissement** affiche le bouton MusicMe
3. Cliquer sur **"Rechercher sur MusicMe"**
4. Une nouvelle fentre s'ouvre avec les rsultats de recherche sur MusicMe

### Recherche automatique

Le connecteur utilise le titre de la notice (champ `tit1`) pour effectuer la recherche sur MusicMe. La recherche porte sur :
- Albums
- Artistes
- Titres correspondants

## Architecture technique

### Classe principale

**Fichier** : `musicme.class.php`

```php
class musicme extends connector
{
    public const MUSICME_BASE_URL = "https://app.mt.musicme.com";

    public function get_id() // Retourne "musicme"
    public function enrichment_is_allow() // Retourne ENRICHMENT_YES
    public function getEnrichment($notice_id, $source_id, ...) // Gnre l'enrichissement
}
```

### Mthodes principales

#### `getEnrichment($notice_id, $source_id, $type, $enrich_params)`
Gnre le contenu d'enrichissement pour une notice :
- Rcupre le titre de la notice
- Construit l'URL de recherche MusicMe
- Retourne le bouton de recherche

#### `source_get_property_form($source_id)`
Gnre le formulaire de configuration de la source avec l'URL MusicMe.

#### `make_serialized_source_properties($source_id)`
Srialise et enregistre les paramtres de configuration.

### Format des donnes

**Paramtres stocks** (srialiss) :
```php
[
    'musicme_url' => 'https://app.mt.musicme.com'
]
```

**URL gnre** :
```
https://app.mt.musicme.com/search?q={titre_encod}
```

## Messages d'interface

### Franais (`fr_FR.xml`)

| Code | Message |
|------|---------|
| `musicme_title` | MusicMe |
| `musicme_url` | URL MusicMe |
| `musicme_url_help` | URL de base pour les liens MusicMe |
| `musicme_search_button` | Rechercher sur MusicMe |
| `musicme_error_config` | Configuration MusicMe incomplte |
| `musicme_no_title` | Impossible de rcuprer le titre de la notice |

### Anglais (`en_UK.xml`)

Messages quivalents en anglais.

## Personnalisation

### Modifier l'URL par dfaut

diter `musicme.class.php`, ligne ~199 :

```php
$musicme_url = $parameters['musicme_url'] ?? 'https://votre-url-personnalisee.mt.musicme.com';
```

### Ajouter des paramtres de recherche

Modifier la mthode `getEnrichment()` pour personnaliser l'URL de recherche :

```php
// Au lieu de :
$search_url = $musicme_url . '/search?q=' . $search_query;

// Ajouter des paramtres :
$search_url = $musicme_url . '/search?q=' . $search_query . '&filter=albums&sort=popularity';
```

### Changer le champ source

Par dfaut, le connecteur utilise le titre (`tit1`). Pour utiliser un autre champ :

```php
// Remplacer dans getEnrichment() :
$query = "SELECT tit1 FROM notices WHERE notice_id = " . intval($notice_id);

// Par exemple, pour utiliser l'auteur :
$query = "SELECT author FROM notices WHERE notice_id = " . intval($notice_id);
```

## Logo du connecteur

Pour ajouter un logo MusicMe visible dans l'enrichissement :

1. Placer un fichier SVG ou PNG dans `/images/connecteurs/musicme.svg`
2. Le logo sera automatiquement affich avec le bouton d'enrichissement

Format recommand :
- **Type** : SVG (vectoriel) ou PNG (transparent)
- **Dimensions** : 100x30 pixels (ratio 3:1)
- **Poids** : < 10 Ko

## Dpannage

### Le bouton n'apparat pas

**Vrifications** :
1. Le connecteur est activ dans PMB
2. Une source MusicMe est cre et configure
3. L'URL est correctement renseigne
4. Les fichiers de messages sont prsents

### Erreur "Configuration incomplte"

**Cause** : L'URL MusicMe n'est pas configure
**Solution** : Aller dans la configuration de la source et renseigner l'URL

### La recherche ne retourne rien

**Causes possibles** :
- Le titre de la notice est vide
- Les caractres spciaux ne sont pas bien encods
- L'URL MusicMe est incorrecte

**Solutions** :
- Vrifier que les notices ont un titre
- Tester l'URL dans un navigateur
- Vrifier les logs PMB

## volutions possibles

### Fonctionnalits futures

- [ ] Recherche avance avec filtres (genre, artiste, label)
- [ ] Affichage des pochettes d'albums dans l'enrichissement
- [ ] Intgration du lecteur d'extraits audio
- [ ] Support de l'authentification SSO/CAS pour le streaming
- [ ] Import automatique des mtadonnes MusicMe

### Pour contribuer

Ce connecteur est bas sur le modle du connecteur Arte Campus. Pour ajouter des fonctionnalits :

1. **Fork** le dpt PMB
2. **Modifier** `musicme.class.php`
3. **Tester** dans un environnement de dveloppement
4. **Soumettre** une pull request avec documentation

## Ressources

### Documentation MusicMe

- **Site officiel** : https://www.musicme.com
- **Catalogue** : Environ 1 million d'albums
- **Formats** : Streaming + tlchargement MP3
- **Genres** : Tous styles musicaux

### Documentation PMB

- **Connecteurs** : https://doc.sigb.net/pmb/connecteurs
- **Enrichissement** : https://doc.sigb.net/pmb/enrichissement
- **API** : https://doc.sigb.net/pmb/api

### Contact MusicMe

Pour obtenir une instance ddie ou des identifiants d'accs :
- **Email** : herve@musicme.com (Herv Chiron)
- **Support** : Via le site musicme.com

## Licence

 2025 PMB Services / www.sigb.net

Ce connecteur est distribu sous **licence CeCILL** (compatible GPL).

Vous tes libre de :
- Utiliser le connecteur
- Le modifier
- Le redistribuer

Dans le respect de la licence CeCILL.

## Historique

### Version 1.0 (2025-10-09)
- Cration initiale du connecteur
- Enrichissement avec lien de recherche MusicMe
- Configuration URL personnalisable
- Support multilingue (FR/EN)

## Support

Pour toute question ou problme :

- **Forum PMB** : https://www.sigb.net/forum/
- **Documentation** : https://doc.sigb.net/
- **Email** : support@sigb.net

---

*Connecteur dvelopp pour PMB par Gregor Neveu - PMB Services*
