<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: resa_planning_func.inc.php,v 1.47.8.3 2025/07/01 15:41:20 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $include_path;
require_once($include_path."/mail.inc.php") ;

// defines pour flag affichage info de gestion
if (!defined('NO_INFO_GESTION')) define ('NO_INFO_GESTION', 0); // 0 >> aucune info de gestion : liste simple
if (!defined('GESTION_INFO_GESTION')) define ('GESTION_INFO_GESTION', 1); // pour traitement des prvisions
if (!defined('LECTEUR_INFO_GESTION')) define ('LECTEUR_INFO_GESTION', 2); // pour affichage en fiche lecteur
if (!defined('EDIT_INFO_GESTION')) define ('EDIT_INFO_GESTION', 3); // pour affichage en dition

function planning_list($idnotice=0, $idbulletin=0, $idempr=0, $order='', $where='', $info_gestion=NO_INFO_GESTION, $url_gestion='', $ancre='') {
	global $msg,$charset;
	global $montrerquoi, $f_loc_empr, $f_loc_ret ;
	global $pmb_lecteurs_localises, $deflt2docs_location;
	global $deflt_docs_location, $deflt_resas_location;

	if($info_gestion == GESTION_INFO_GESTION) {
	    $list_resa_planning_circ_ui = new list_resa_planning_circ_ui();
	    return $list_resa_planning_circ_ui->get_display_list();
	}
	
	if($info_gestion == NO_INFO_GESTION) {
	    if ($idnotice) {
	        $list_resa_planning_ui = new list_resa_planning_catalog_record_ui(array('id_notice' => $idnotice));
	        if (count($list_resa_planning_ui->get_objects())) {
	            return $list_resa_planning_ui->get_display_list();
	        }
	        return '';
	    } elseif ($idbulletin) {
	        $list_resa_planning_ui = new list_resa_planning_catalog_bulletin_ui(array('id_bulletin' => $idbulletin));
	        if (count($list_resa_planning_ui->get_objects())) {
	            return $list_resa_planning_ui->get_display_list();
	        }
	        return '';
	    }
	    
	}

	$q_loc = 'select idlocation, location_libelle FROM docs_location order by location_libelle';
	$r_loc = pmb_mysql_query($q_loc);

	//Tableau + selecteur de localisations emprunteurs / nb de previsions
	$tab_loc_empr = array();
	if(!isset($f_loc_empr)) {
		$f_loc_empr=$deflt2docs_location;
	}
	if($pmb_lecteurs_localises) {
		if(pmb_mysql_num_rows($r_loc)) {
			pmb_mysql_data_seek($r_loc,0);
			while($o=pmb_mysql_fetch_object($r_loc)) {
				$tab_loc_empr[$o->idlocation] = htmlentities($o->location_libelle,ENT_QUOTES,$charset);
			}
		}
	}

	if(!isset($f_loc_ret)) {
		if($deflt_resas_location) {
			$f_loc_ret=$deflt_resas_location;
		} else {
			$f_loc_ret=$deflt_docs_location;
		}
	}

	$aff_final = "<script type='text/javascript'>
		var ajax_func_to_call=new http_request();
		var f_caller='';
		var param1='';
		var param2='';
		var id;
		function func_callback(p_caller,p_id,p_date,p_param1,p_param2) {
			f_caller = p_caller;
			param1 = p_param1;
			param2 = p_param2;
			id = p_id;
			var url_func = './ajax.php?module=circ&categ=resa_planning&sub=update_resa_planning&id='+p_id+'&date='+p_date+'&param1='+p_param1;
			ajax_func_to_call.request(url_func,0,'',1,func_callback_ret,0,0);
		}

		function func_callback_ret() {
			if (param1 == '1') document.forms[f_caller].elements['resa_date_debut['+id+']'].value = ajax_func_to_call.get_text();
			if (param1 == '2') document.forms[f_caller].elements['resa_date_debut['+id+']'].value = ajax_func_to_call.get_text();
			document.forms[f_caller].elements[param2].value = ajax_func_to_call.get_text();
		}
	</script>";

	$clause = '';
	switch ($info_gestion) {

		case NO_INFO_GESTION:
		default:
			$clause .= " AND resa_planning.resa_remaining_qty!=0 ";
			break;
	}

	if (!$order) {
		$order="empr_nom, empr_prenom, tit, resa_idnotice, resa_date " ;
	}
	$nb_prev=0;
	$q = "select resa_planning.id_resa, resa_planning.resa_idnotice, resa_planning.resa_idbulletin, resa_planning.resa_date, resa_planning.resa_date_debut, resa_planning.resa_date_fin, resa_planning.resa_validee, resa_planning.resa_confirmee, resa_planning.resa_idempr, resa_planning.resa_qty, resa_planning.resa_remaining_qty, resa_planning.resa_loc_retrait, ";
	$q.= "trim(concat(if(series_m.serie_name <>'', if(notices_m.tnvol <>'', concat(series_m.serie_name,', ',notices_m.tnvol,'. '), concat(series_m.serie_name,'. ')), if(notices_m.tnvol <>'', concat(notices_m.tnvol,'. '),'')), if(series_s.serie_name <>'', if(notices_s.tnvol <>'', concat(series_s.serie_name,', ',notices_s.tnvol,'. '), series_s.serie_name), if(notices_s.tnvol <>'', concat(notices_s.tnvol,'. '),'')), ifnull(notices_m.tit1,''),ifnull(notices_s.tit1,''),' ',ifnull(bulletin_numero,''), if (mention_date, concat(' (',mention_date,')') ,''))) as tit, ";
	$q.= "concat(empr_nom,', ',empr_prenom) as empr_nom_prenom, id_empr, empr_cb, empr_location, ";
	$q.= "if(resa_planning.resa_date_fin>=sysdate() or resa_planning.resa_date_fin='0000-00-00',0,1) as perimee, ";
	$q.= "date_format(resa_planning.resa_date_debut, '".$msg['format_date']."') as aff_resa_date_debut, ";
	$q.= "if(resa_planning.resa_date_fin='0000-00-00', '', date_format(resa_planning.resa_date_fin, '".$msg['format_date']."')) as aff_resa_date_fin, ";
	$q.= "date_format(resa_planning.resa_date, '".$msg['format_date']."') as aff_resa_date, " ;
	$q.= "ifnull(notices_m.typdoc,notices_s.typdoc) as typdoc ";
	$q.= "FROM resa_planning ";
	$q.= "LEFT JOIN notices as notices_m on resa_idnotice = notices_m.notice_id ";
	$q.= "LEFT JOIN series as series_m on notices_m.tparent_id = series_m.serie_id ";
	$q.= "LEFT JOIN bulletins on resa_idbulletin = bulletins.bulletin_id ";
	$q.= "LEFT JOIN notices as notices_s on bulletin_notice = notices_s.notice_id ";
	if ($montrerquoi!='toresa') {
		$q.= "LEFT JOIN series as series_s on notices_s.tparent_id = series_s.serie_id, ";
	} else {
		$q.= "LEFT JOIN series as series_s on notices_s.tparent_id = series_s.serie_id ";
		$q.= "JOIN resa on resa.resa_planning_id_resa = resa_planning.id_resa, ";
	}
	$q.= "empr ";
	$q.= "WHERE resa_planning.resa_idempr = id_empr ";
	if ($clause) $q.= $clause;

	if ($idnotice) $q.= "and notices_m.notice_id = '".$idnotice."' ";
	if ($idbulletin) $q.= "and bulletin_id = '".$idbulletin."' ";
	if ($idempr) $q.= "and id_empr = '".$idempr."' ";
	$q.= "order by ".$order;

	$r = pmb_mysql_query($q) or die("Erreur SQL !=$q");
	$nb_prev = pmb_mysql_num_rows($r);

	if (!$nb_prev) {
		switch ($info_gestion) {
			case NO_INFO_GESTION:
			default:
				return '';
		}
		return $aff_final ;
	}

	//Entete Tableau
	$aff_final .= "	<script type='text/javascript' src='./javascript/sorttable.js'></script>
				<table width='100%' class='sortable'>
					<tr>";

	$aff_final .= '<th>'.htmlentities($msg['empr_nom_prenom'], ENT_QUOTES, $charset).'</th>
			'.($pmb_lecteurs_localises ? '<th>'.htmlentities($msg['resa_planning_loc_empr'], ENT_QUOTES, $charset).'</th>' :'');

	$aff_final .= '<th>'.htmlentities($msg['374'], ENT_QUOTES, $charset).'</th>
		<th>'.htmlentities($msg['resa_planning_date_debut'], ENT_QUOTES, $charset).'</th>
		<th>'.htmlentities($msg['resa_planning_date_fin'], ENT_QUOTES, $charset).'</th>';

	$aff_final .= '</tr>';
	$odd_even=0;

	//Contenu tableau
	while ($data = pmb_mysql_fetch_object($r)) {

		if ($odd_even==0) {
			$aff_final .= "<tr class='odd' onmouseover=\"this.className='surbrillance'\" onmouseout=\"this.className='odd'\">";
			$odd_even=1;
		} else if ($odd_even==1) {
			$aff_final .= "<tr class='even' onmouseover=\"this.className='surbrillance'\" onmouseout=\"this.className='even'\">";
			$odd_even=0;
		}

		//Nom lecteur
		if (SESSrights & CIRCULATION_AUTH) {
		    $aff_final .= "<td><a href=\"./circ.php?categ=pret&form_cb=".rawurlencode($data->empr_cb)."\">".htmlentities($data->empr_nom_prenom,  ENT_QUOTES, $charset)."</a></td>";
		} else {
		    $aff_final .= '<td>'.htmlentities($data->empr_nom_prenom, ENT_QUOTES, $charset).'</td>';
		}
		//Localisation lecteur
		if ($pmb_lecteurs_localises) {
		    $aff_final.= '<td>'.$tab_loc_empr[$data->empr_location].'</td>';
		}

		//Date prevision
		$aff_final.= '<td style="text-align:center;">'.$data->aff_resa_date.'</td>';
		$aff_final.= "<td style='text-align:center;'>".$data->aff_resa_date_debut.'</td>';
		$aff_final.= "<td style='text-align:center;'>".$data->aff_resa_date_fin." </td>";
		$aff_final.= "</tr>";
	}
	$aff_final.= "</table>";
	$aff_final.= "<div class='row'></div>";
	return $aff_final ;
}

function resa_planning_loc_retrait($id_resa) {
	global $transferts_choix_lieu_opac, $transferts_site_fixe;

	$res_trans = 0;

	switch ($transferts_choix_lieu_opac) {
		case "2":
			//retrait de la resa sur lieu fix
			$res_trans = $transferts_site_fixe;
		break;
		case "3":
			//retrait de la resa sur lieu exemplaire
			//==>on fait rien !
		break;
		case "1":
		default:
			//retrait de la resa sur lieu lecteur
			//on recupere la localisation de l'emprunteur
			$rqt = "SELECT empr_location FROM resa_planning INNER JOIN empr ON resa_idempr = id_empr WHERE id_resa='".$id_resa."'";
			$res = pmb_mysql_query($rqt);
			$res_trans = pmb_mysql_result($res,0) ;
		break;

	}
	return $res_trans;
}