<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: sphinx_fill.php,v 1.15.2.1.2.1 2025/07/29 08:53:56 qvarin Exp $

if (php_sapi_name() !== 'cli') {
    die('This script can only be run from the command line.');
}

$base_path = __DIR__ . '/../..';
$class_path = $base_path . '/classes';
$include_path = $base_path . '/includes';
$base_noheader = 1;
$base_nocheck = 1;
$base_nobody = 1;
$base_nosession = 1;

ini_set('display_errors', 0);
error_reporting(0);

$_SERVER['REQUEST_URI'] = '';
$_SERVER['HTTP_USER_AGENT'] = '';

define('SPHINX_FILL_ENTITIES', [
    'records',
    'titres_uniformes',
    'series',
    'categories',
    'collections',
    'subcollections',
    'authperso',
    'indexint',
    'authors',
    'concepts',
    'explnums',
    'publishers',
]);

function sphinxFillHelp()
{
    echo "Usage :" . PHP_EOL;
    echo "  php sphinx_fill.php <entity> [options]" . PHP_EOL;
    echo PHP_EOL;
    echo "Exemples :" . PHP_EOL;
    echo "  php sphinx_fill.php                           (all entities are indexed by default)" . PHP_EOL;
    echo "  php sphinx_fill.php records                   (records are indexed)" . PHP_EOL;
    echo "  php sphinx_fill.php records explnums --db=pmb (records and explnums are indexed in the pmb database)" . PHP_EOL;
    echo PHP_EOL;
    echo "Options :" . PHP_EOL;
    echo "  --db=<database>                               Database name" . PHP_EOL;
    echo "  -h, --help                                    Display this help" . PHP_EOL;
    echo PHP_EOL;
    echo "Entities :                                      Optional, all entities are indexed by default" . PHP_EOL;
    foreach (SPHINX_FILL_ENTITIES as $entity) {
        echo "  $entity" . PHP_EOL;
    }
    exit;
}

function sphinxFillUnknownEntity($entity = '')
{
    if (empty($entity)) {
        echo "No known entity." . PHP_EOL;
    } else {
        echo "Unknown entity: $entity" . PHP_EOL;
    }
    echo "Use entities: " . PHP_EOL;
    foreach (SPHINX_FILL_ENTITIES as $entity) {
        echo "  $entity" . PHP_EOL;
    }
    exit(1);
}

// Rcuprer les arguments en ligne de commande
$argv = $_SERVER['argv'];
if (! is_array($argv)) {
    $argv = [];
}

// Supprimer le nom du script lui-mme
array_shift($argv);

global $database;

// Recherche de l'argument --db dans les arguments fournis pour rcuprer le nom de la base de donnes
foreach ($argv as $key => $arg) {
    if (strpos($arg, '--db=') === 0) {
        $database = substr($arg, 5);
        unset($argv[$key]);
        break;
    }

    if ($arg === '--help' || $arg === '-h') {
        sphinxFillHelp();
    }
}
require_once $include_path . '/init.inc.php';

//On inclut les messages pour viter les warnings dans les inclusions de fichiers qui utilisent $msg
global $msg, $lang;
$messages = new XMLlist("$include_path/messages/$lang.xml", 0);
$messages->analyser();
$msg = $messages->table;

require_once $class_path . '/parametres_perso.class.php';
require_once $class_path . '/sphinx/sphinx_records_indexer.class.php';
require_once $class_path . '/sphinx/sphinx_titres_uniformes_indexer.class.php';

require_once 'progress_bar.php';

// Si aucun argument n'est fourni, utiliser toutes les entites rpertoriees
$entities = SPHINX_FILL_ENTITIES;

// Si des arguments sont fournis, utiliser ceux-ci comme entites a traiter
if (!empty($argv)) {
    $entities = $argv;
    foreach ($entities as $entity) {
        if (!in_array($entity, SPHINX_FILL_ENTITIES)) {
            sphinxFillUnknownEntity($entity);
        }
    }
}

global $database;
echo "SPHINX FILL" . PHP_EOL;
echo "  Database: " . LOCATION . PHP_EOL;
echo "  Indexing started at: " . date('Y-m-d H:i:s') . PHP_EOL . PHP_EOL;

$flag = false;
foreach ($entities as $entity) {
    $index_class = 'sphinx_' . $entity . '_indexer';
    if (class_exists($index_class)) {
        $flag = true;

        $sconf = new $index_class();
        $sconf->checkExistingIndexes();
        print $sconf->fillIndexes([], true);
    }
}

if (!$flag) {
    sphinxFillUnknownEntity();
}
