<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_storyplay_view_storyplay.class.php,v 1.3.2.2 2025/10/30 08:11:43 gneveu Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

class cms_module_storyplay_view_storyplay extends cms_module_common_view_django
{
    public function __construct($id = 0)
    {
        parent::__construct($id);
        $this->default_template = '
<div class="storyplay">
    <img
        src="./images/connecteurs/storyplayr.png"
        alt="{{ msg.storyplay }}"
    />
    <a
        class="bouton"
        href="{{ connector.url_connexion_cas }}"
        aria-label="{{ msg.storyplay }}"
    >
        {{ msg.storyplay_access }}
    </a>
</div>';
    }

    /**
     * Renvoie les structures de donnes du module
     *
     * @return array
     */
    public function get_format_data_structure()
    {
        return array_merge(
            parent::get_format_data_structure(),
            [
                [
                    'var' => 'connector',
                    'desc' => $this->msg['connector_vars_view_desc'],
                    'children' => [
                        [
                            'var' => 'connector.url_connexion_cas',
                            'desc' => $this->msg['connector_url_connexion_cas_vars_view_desc'],
                        ],
                    ]
                ]
            ]
        );
    }

    /**
     * Rendu du module
     *
     * @param false|array{connector: int} $data
     * @return string
     */
    public function render($data)
    {
        // Enrichissement des donnes avec les informations du connecteur
        if (!empty($data['connector'])) {
            $connector_id = intval($data['connector']);

            // Rcupration de l'URL du connecteur depuis la base
            $query = "SELECT PARAMETERS FROM connectors_sources WHERE id_connector = 'storyplay' AND source_id = " . $connector_id;
            $result = pmb_mysql_query($query);

            if ($result && pmb_mysql_num_rows($result)) {
                $row = pmb_mysql_fetch_assoc($result);
                $params = unserialize($row['PARAMETERS']);

                $storyplay_url = $params['storyplay_url'] ?? 'https://www.storyplayr.com';
                $storyplay_url_server_cas = $params['storyplay_url_server_cas'] ?? '';
                $storyplay_bibli_id = $params['storyplay_bibli_id'] ?? '';
                $url = $this->build_storyplay_link($storyplay_url, $storyplay_url_server_cas, $storyplay_bibli_id);

                // Prparation des donnes pour le template
                $data['connector'] = [
                    'url_connexion_cas' => $url,
                ];
            }
        }
        return parent::render($data);
    }

    /**
     * Construction du lien CAS Storyplay
     *
     * @param string $storyplay_url
     * @param string $storyplay_url_server_cas
     * @param string $storyplay_bibli_id
     * @return string
     */
    protected function build_storyplay_link($storyplay_url, $storyplay_url_server_cas, $storyplay_bibli_id)
    {
        return $storyplay_url_server_cas . '?service=' . urlencode($storyplay_url . '?mediathequeid=' . $storyplay_bibli_id);
    }
}
