<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_role_rights_ui.class.php,v 1.1.4.2 2025/09/04 07:24:48 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_role_rights_ui extends list_ui {
	
    protected static $module_name;
    
    protected static $list_tabs_instance;
    
    protected $list_tabs_ui;
    
    protected $list_tabs_data;
    
    protected static $list_subtabs_instance;
    
    protected $list_subtabs_ui;
    
    protected $list_subtabs_data;
    
    protected function fetch_data() {
        $this->objects = array();
        $this->_init_role_rights();
        $this->pager['nb_results'] = count($this->objects);
        $this->messages = "";
    }
    
    protected function get_object_instance($row) {
        return (object) $row;
    }
    
    /**
     * Initialisation des droits
     */
    protected function _init_role_rights() {
        
    }
    
    protected function init_default_applied_group() {
        $this->applied_group = array(0 => 'section_label');
    }
    
    /**
     * Initialisation des colonnes disponibles
     */
    protected function init_available_columns() {
        $this->available_columns =
        array('main_fields' =>
            array(
                'label' => '103',
            )
        );
        $this->available_columns['custom_fields'] = array();
    }
    
    protected function init_default_columns() {
        $this->add_column('label');
    }
    
    protected static function _get_list_tabs_instance() {
        if (!isset(static::$list_tabs_instance[static::$module_name])) {
            $list_tabs_class_name = "list_tabs_".static::$module_name."_ui";
            if (class_exists($list_tabs_class_name)) {
                $list_tabs_class_name::set_no_check_rights(true);
                static::$list_tabs_instance[static::$module_name] = $list_tabs_class_name::get_instance();
            } else {
                static::$list_tabs_instance[static::$module_name] = null;
            }
        }
        return static::$list_tabs_instance[static::$module_name];
    }
    
    protected function _get_list_tabs_ui() {
        if (!isset($this->list_tabs_ui)) {
            $this->list_tabs_ui = static::_get_list_tabs_instance();
        }
        return $this->list_tabs_ui;
    }
    
	protected function _get_list_tabs_data() {
	    if (!isset($this->list_tabs_data)) {
	        $this->list_tabs_data = [];
	        $list_tabs_ui = $this->_get_list_tabs_ui();
	        if ($list_tabs_ui !== null) {
                $this->list_tabs_data = $list_tabs_ui->get_objects_data();
            }
	    }
	    return $this->list_tabs_data;
	}
	
	protected static function _get_list_subtabs_instance() {
	    if (!isset(static::$list_subtabs_instance[static::$module_name])) {
	        $list_subtabs_class_name = "list_subtabs_".static::$module_name."_ui";
	        if (class_exists($list_subtabs_class_name)) {
	            $list_subtabs_class_name::set_no_check_rights(true);
	            $list_subtabs_ui = $list_subtabs_class_name::get_instance();
	            static::$list_subtabs_instance[static::$module_name] = $list_subtabs_ui;
	        } else {
	            static::$list_subtabs_instance[static::$module_name] = null;
	        }
	    }
	    return static::$list_subtabs_instance[static::$module_name];
	}
	
	protected function _get_list_subtabs_ui() {
	    if (!isset($this->list_subtabs_ui)) {
	        $this->list_subtabs_ui = static::_get_list_subtabs_instance();
	    }
	    return $this->list_subtabs_ui;
	}
	
	protected function _get_list_subtabs_data() {
	    if (!isset($this->list_subtabs_data)) {
	        $this->list_subtabs_data = [];
            $list_subtabs_ui = $this->_get_list_subtabs_ui();
            if ($list_subtabs_ui !== null) {
                $list_subtabs_class_name = "list_subtabs_".static::$module_name."_ui";
                $tabs = $this->_get_list_tabs_data();
                foreach ($tabs as $objects) {
                    foreach($objects as $object) {
                        $list_subtabs_class_name::set_categ($object['categ']);
                        $list_subtabs_class_name::set_sub($object['sub']);
                        $list_subtabs_ui->reload_data();
                        $this->list_subtabs_data[$object['label_code']] = $list_subtabs_ui->get_objects_data();
                    }
                }
            }
	    }
	    return $this->list_subtabs_data;
	}
	
	protected function init_default_pager() {
	    parent::init_default_pager();
	    $this->pager['all_on_page'] = true;
	}
	
	protected function get_object_data($object) {
	    return $object;
	}
	
	public static function set_module_name($module_name) {
	    static::$module_name = $module_name;
	}
}