<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_forms_ui.class.php,v 1.7.4.7 2025/09/05 09:05:26 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path;
require_once($class_path."/forms/form.class.php");

class list_forms_ui extends list_ui {
    
    protected $tabs_instances = array();
    
    protected $tabs = array();
    
    protected $subtabs_instances = array();
    
    protected $subtabs = array();
    
    protected function fetch_data() {
        $this->objects = array();
        $this->_init_forms();
        $this->pager['nb_results'] = count($this->objects);
        $this->messages = "";
    }
    
    /**
     * Module Circulation : ajout des formulaires
     */
    public function add_circ_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'circ', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Circulation : initialisation des formulaires
     */
    protected function _init_circ_forms() {
        $this->add_circ_form('empr_form', 'emprunteur', 'empr_create');
        
        //Groupes de lecteurs
        $this->add_circ_form('group_form', 'group', 'groups');
        
        //Groupes d'exemplaires
        $this->add_circ_form('groupexpl', 'groupexpl', 'groupexpl');
        
        //Paniers - Gestion
        $this->add_circ_form('cart_form', 'empr_caddie', 'caddie', 'gestion', '&quoi=panier');
        $this->add_circ_form('maj_proc', 'empr_caddie_procs', 'caddie', 'gestion', '&quoi=procs');
        $this->add_circ_form('classementGen_form', 'classementGen', 'caddie', 'gestion', '&quoi=classementGen');
        
        //Paniers - Actions
        $this->add_form('form_message', 'mailing_empr', '', 'redige');
        
    }
    
    /**
     * Module Catalogue : ajout des formulaires
     */
    public function add_catalog_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'catalog', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Catalogue : initialisation des formulaires
     */
    protected function _init_catalog_forms() {
        $this->add_catalog_form('notice', 'notice', 'create_form');
        $this->add_catalog_form('notice', 'serial', 'serials', 'serial_form');
        $this->add_catalog_form('notice', 'bulletinage', 'serials', 'bulletinage');
        $this->add_catalog_form('notice', 'analysis', 'serials', 'analysis');
        
        //Paniers - Gestion
        $this->add_catalog_form('cart_form', 'caddie', 'caddie', 'gestion', '&quoi=panier');
        $this->add_catalog_form('maj_proc', 'caddie_procs', 'caddie', 'gestion', '&quoi=procs');
        $this->add_catalog_form('classementGen_form', 'classementGen', 'caddie', 'gestion', '&quoi=classementGen');
        
        //Etageres
        $this->add_catalog_form('etagere_form', 'etagere', 'etagere', 'edit_etagere');
        $this->add_catalog_form('etagere_constitution_form', 'etagere_caddies', 'etagere', 'constitution');
    }
    
    /**
     * Module Autorits : ajout des formulaires
     */
    public function add_autorites_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'autorites', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Autorits : initialisation des formulaires
     */
    protected function _init_autorites_forms() {
        //Autorits
        $this->add_autorites_form('saisie_auteur', 'author', 'auteurs', 'author_form');
        $this->add_autorites_form('thes_form', 'thesaurus', 'categories', 'thes_form');
        $this->add_autorites_form('saisie_editeur', 'editor', 'editeurs', 'editeur_form');
        $this->add_autorites_form('saisie_collection', 'collection', 'collections', 'collection_form');
        $this->add_autorites_form('saisie_sub_collection', 'subcollection', 'souscollections', 'collection_form');
        $this->add_autorites_form('saisie_serie', 'serie', 'series', 'serie_form');
        $this->add_autorites_form('saisie_indexint', 'indexint', 'indexint', 'indexint_form');
        $this->add_autorites_form('saisie_titre_uniforme', 'titre_uniforme', 'titres_uniformes', 'titre_uniforme_form');
        
        //Autorits perso
        $this->add_autorites_form('saisie_authperso', 'authperso', 'authperso', 'authperso_form');
        
        //Paniers - Gestion
        $this->add_autorites_form('cart_form', 'authorities_caddie', 'caddie', 'gestion', '&quoi=panier');
        $this->add_autorites_form('maj_proc', 'authorities_caddie_procs', 'caddie', 'gestion', '&quoi=procs');
        $this->add_autorites_form('classementGen_form', 'classementGen', 'caddie', 'gestion', '&quoi=classementGen');
    }
    
    /**
     * Module Editions : ajout des formulaires
     */
    public function add_edit_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'edit', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Editions : initialisation des formulaires
     */
    protected function _init_edit_forms() {
        //Etats
        $this->add_edit_form('editions_state_form', 'editions_state', 'state');
        
        //Modles de planche de codes-barres
        $this->add_edit_form('barcodes_sheet_form', 'barcodes_sheet', 'barcodes_sheets', 'models');
        //Modles de planche d'tiquettes
        $this->add_edit_form('sticks_sheet_form', 'sticks_sheet', 'sticks_sheet', 'models');
        
        //Templates
        $this->add_edit_form('notice_tpl_form', 'notice_tpl', 'tpl', 'notice');
        $this->add_edit_form('serialcirc_tpl_form', 'serialcirc_tpl', 'tpl', 'serialcirc');
        $this->add_edit_form('bannette_tpl_form', 'bannette_tpl', 'tpl', 'bannette');
        $this->add_edit_form('print_cart_tpl', 'print_cart_tpl', 'tpl', 'print_cart_tpl');
    }
    
    /**
     * Module D.S.I. : ajout des formulaires
     */
    public function add_dsi_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'dsi', $categ, $sub, $url_extra);
    }
    
    /**
     * Module D.S.I. : initialisation des formulaires
     */
    protected function _init_dsi_forms() {
        //Bannettes
        $this->add_dsi_form('saisie_bannette', 'bannette', 'bannettes', 'pro');
        $this->add_dsi_form('saisie_bannette', 'bannette', 'bannettes', 'abo');
        
        //Equations
        $this->add_dsi_form('saisie_equation', 'equation', 'equations', 'gestion');
        //Classements
        $this->add_dsi_form('saisie_classement', 'classements', 'options', 'classements');
        //Flux RSS
        $this->add_dsi_form('saisie_rss_flux', 'rss_flux', 'fluxrss', 'definition');
    }
    
    /**
     * Module Acquisitions. : ajout des formulaires
     */
    public function add_acquisition_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'acquisition', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Acquisitions. : initialisation des formulaires
     */
    protected function _init_acquisition_forms() {
        global $acquisition_rent_requests_activate;
        
        //Achats
        $this->add_acquisition_form('remform', 'offres_remises', 'ach', 'fourn');
        if ($acquisition_rent_requests_activate) {
            //Demandes de location
            $this->add_acquisition_form('account_form', 'rent_account', 'rent', 'requests');
            if (SESSrights & ACQUISITION_ACCOUNT_INVOICE_AUTH) {
                $this->add_acquisition_form('account_form', 'rent_account', 'rent', 'accounts');
                $this->add_acquisition_form('invoice_form', 'rent_invoice', 'rent', 'invoices');
            }
        }
        
    }
    
    /**
     * Module Demandes. : ajout des formulaires
     */
    public function add_demandes_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'demandes', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Demandes. : initialisation des formulaires
     */
    protected function _init_demandes_forms() {
        
        $this->add_demandes_form('modif_dmde', 'demandes', 'gestion');
        $this->add_demandes_form('modif_action', 'demandes_actions', 'action');
        //      $this->add_demandes_form('modif_note', 'demandes_note', 'gestion');
        
        //FAQ
        $this->add_demandes_form('faq_question_form', 'faq_question', 'faq', 'question');
        
    }
    
    /**
     * Module Administration : ajout des formulaires
     */
    public function add_admin_form($name, $model_name, $categ, $sub='', $url_extra='') {
        $this->add_form($name, $model_name, 'admin', $categ, $sub, $url_extra);
    }
    
    /**
     * Module Administration : initialisation des formulaires
     */
    protected function _init_admin_forms() {
        global $pmb_sur_location_activate, $pmb_map_activate, $pmb_nomenclature_activate;
        global $pmb_gestion_financiere, $pmb_gestion_abonnement, $pmb_gestion_financiere_caisses;
        global $pmb_scan_request_activate, $demandes_active, $faq_active;
        global $acquisition_gestion_tva, $acquisition_sugg_categ;
        
        //Exemplaires
        $this->add_admin_form('typdocform', 'docs_type', 'docs', 'typdoc');
        $this->add_admin_form('locationform', 'docs_location', 'docs', 'location');
        if($pmb_sur_location_activate) {
            $this->add_admin_form('surlocform', 'sur_location', 'docs', 'sur_location');
        }
        $this->add_admin_form('typdocform', 'docs_section', 'docs', 'section');
        $this->add_admin_form('typdocform', 'docs_statut', 'docs', 'statut');
        $this->add_admin_form('typdocform', 'docs_codestat', 'docs', 'codstat');
        $this->add_admin_form('lenderform', 'lender', 'docs', 'lenders');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'docs', 'perso');
        
        //Notices
        $this->add_admin_form('orinotform', 'origine_notice', 'notices', 'orinot');
        $this->add_admin_form('statutform', 'notice_statut', 'notices', 'statut');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'notices', 'perso');
        if($pmb_map_activate) {
            $this->add_admin_form('map_echelleform', 'map_echelle', 'notices', 'map_echelle');
            $this->add_admin_form('map_projectionform', 'map_projection', 'notices', 'map_projection');
            $this->add_admin_form('map_refform', 'map_ref', 'notices', 'map_ref');
        }
        $this->add_admin_form('ongletform', 'notice_onglet', 'notices', 'onglet');
        $this->add_admin_form('notice_usageform', 'notice_usage', 'notices', 'notice_usage');
        
        //Autorits
        $this->add_admin_form('origin', 'origin', 'authorities', 'origins');
        $this->add_admin_form('statutform', 'authorities_statut', 'authorities', 'statuts');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=author');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=categ');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=publisher');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=collection');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=subcollection');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=serie');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=tu');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'authorities', 'perso', '&type_field=indexint');
        $this->add_admin_form('authperso', 'authperso_admin', 'authorities', 'authperso');
        
        //Documents numriques
        $this->add_admin_form('statutform', 'explnum_statut', 'docnum', 'statut');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'docnum', 'perso');
        $this->add_admin_form('explnumlicenceform', 'explnum_licence', 'docnum', 'licence');
        if ($this->filters['depth'] > 2) {
            $this->add_admin_form('explnumlicenceprofileform', 'explnum_licence_profile', 'docnum', 'licence');
            $this->add_admin_form('explnumlicencerightform', 'explnum_licence_right', 'docnum', 'licence');
        }
        
        //Etats des collections
        $this->add_admin_form('emplacementform', 'arch_emplacement', 'collstate', 'emplacement');
        $this->add_admin_form('supportform', 'arch_type', 'collstate', 'support');
        $this->add_admin_form('statutform', 'arch_statut', 'collstate', 'statut');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'collstate', 'perso');
        
        //Abonnements
        $this->add_admin_form('typdocform', 'abts_periodicite', 'abonnements', 'periodicite');
        $this->add_admin_form('statusform', 'abts_status', 'abonnements', 'status');
        
        //Lecteurs
        $this->add_admin_form('categform', 'empr_categ', 'empr', 'categ');
        $this->add_admin_form('statutform', 'empr_statut', 'empr', 'statut');
        $this->add_admin_form('lenderform', 'empr_codestat', 'empr', 'codstat');
        $this->add_admin_form('parperso_form', 'parametres_perso', 'empr', 'parperso');
        
        //Utilisateurs
        $this->add_admin_form('groupform', 'users_groups', 'users', 'groups');
        
        //Contenu ditorial
        $this->add_admin_form('cms_editorial_type_form', 'cms_editorial_type', 'cms_editorial', 'type');
        $this->add_admin_form('cms_editorial_publication_state_form', 'cms_editorial_publications_state', 'cms_editorial', 'publication_state');
        
        //Prts
        $this->add_admin_form('parperso_form', 'parametres_perso', 'loans', 'perso');
        
        //Facettes en gestion
        if ($this->filters['depth'] > 2) {
            $this->add_admin_form('facettes_set_form', 'facettes_set', 'gestion', 'facettes');
        }
        $this->add_admin_form('facette_form', 'facette', 'gestion', 'facettes');
        $this->add_admin_form('facette_form', 'facette', 'gestion', 'facettes_authorities');
        
        //Infopages
        $this->add_admin_form('infopagesform', 'infopage', 'infopages');
        
        //Facettes
        $this->add_admin_form('facette_form', 'facette', 'opac', 'facettes');
        $this->add_admin_form('facette_form', 'facette', 'opac', 'facettes_authorities');
        $this->add_admin_form('facette_form', 'facette', 'opac', 'facettes_animations');
        $this->add_admin_form('facette_form', 'facette', 'opac', 'facettes_external');
        $this->add_admin_form('form_compare', 'facette_search_compare', 'opac', 'facettes_comparateur');
        
        //Statistiques
        $this->add_admin_form('addview', 'stat_view', 'opac', 'stat', '&section=view_list');
        $this->add_admin_form('request_form', 'stat_query', 'opac', 'stat');
        
        //Vues OPAC
        $this->add_admin_form('opac_view_form', 'opac_view', 'opac', 'opac_view', '&section=list');
        
        //Formulaire de contact
        $this->add_admin_form('contact_form_form', 'contact_form', 'contact_forms');
        $this->add_admin_form('contact_form_object_form', 'contact_form_object', 'contact_forms', 'objects');
        
        //Page de maintenance
        $this->add_admin_form('admin_opac_maintenance_form', 'maintenance_page', 'opac', 'maintenance');
        
        //Cookies & traceurs
        $this->add_admin_form('analytics_service_form', 'analytics_service', 'opac', 'analytics_services');
        
        //Actions Personnalisables
        $this->add_admin_form('maj_proc', 'procs', 'proc', 'proc');
        
        //Actions classements
        $this->add_admin_form('proc_clas_form', 'procs_classement', 'proc', 'clas');
        
        //Nomenclatures
        if($pmb_nomenclature_activate) {
            $this->add_admin_form('nomenclature_family_form', 'nomenclature_family', 'family', 'family');
            $this->add_admin_form('nomenclature_family_musicstand_form', 'nomenclature_musicstand', 'family', 'family_musicstand');
            $this->add_admin_form('nomenclature_formation_form', 'nomenclature_formation', 'formation', 'formation');
            $this->add_admin_form('nomenclature_formation_type_form', 'nomenclature_type', 'formation', 'formation_type');
            $this->add_admin_form('nomenclature_voice_form', 'nomenclature_voice', 'voice', 'voice');
            $this->add_admin_form('nomenclature_instrument_form', 'nomenclature_instrument', 'instrument', 'instrument');
        }
        
        //Gestion financire
        if (($pmb_gestion_financiere)&&($pmb_gestion_abonnement==2)) {
            $this->add_admin_form('type_abts_form', 'type_abt', 'finance', 'abts');
        }
        if (($pmb_gestion_financiere)) {
            $this->add_admin_form('transactype', 'transactype', 'finance', 'transactype');
            $this->add_admin_form('transaction_payment_method', 'transaction_payment_method', 'finance', 'transaction_payment_method');
        }
        if (($pmb_gestion_financiere)&&($pmb_gestion_financiere_caisses)) {
            $this->add_admin_form('caisse', 'cashdesk', 'finance', 'cashdesk');
        }
        
        //Conversions/Exports
        $this->add_parameters_form('export_param_form', 'export_param', 'convert', 'paramgestion');
        $this->add_parameters_form('export_param_form', 'export_param', 'convert', 'paramopac');
        
        //Rcolteur
        // 		$this->add_admin_form('harvest', 'harvest', 'profil');
        // 		$this->add_admin_form('harvest', 'harvest', 'profil_import');
        
        //Z39.50
        $this->add_admin_form('zbibform', 'z_bib', 'z3950', 'zbib');
        
        //Gestionnaire de tches
        $this->add_admin_form('planificateur_form', 'scheduler_planning', 'planificateur', 'manager');
        if ($this->filters['depth'] > 2) {
            $this->add_admin_form('planificateur_global_form', 'scheduler_tasks_type', 'planificateur', 'manager');
        }
        
        //Services externes
        $this->add_admin_form('form_esuser', 'es_esuser', 'external_services', 'esusers');
        $this->add_admin_form('form_esgroup', 'es_esgroup', 'external_services', 'esusergroups');
        
        //Connecteurs
        $this->add_admin_form('source_form', 'connecteurs', 'connecteurs', 'in');
        $this->add_admin_form('form_categ', 'connectors_categ', 'connecteurs', 'categ');
        // 		$this->add_admin_form('form_outauth', '', 'connecteurs', 'out_auth');
        $this->add_admin_form('form_outset', 'connector_out_set', 'connecteurs', 'out_sets');
        $this->add_admin_form('form_outsetcateg', 'connector_out_setcateg', 'connecteurs', 'categout_sets');
        // 		$this->add_admin_form('enrichment', 'connecteurs', 'enrichment');
        
        //Acquisitions
        $this->add_admin_form('coordform', 'entites', 'acquisition', 'entite');
        $this->add_admin_form('exerform', 'exercices', 'acquisition', 'compta');
        if ($acquisition_gestion_tva) {
            $this->add_admin_form('tvaform', 'tva_achats', 'acquisition', 'tva');
        }
        $this->add_admin_form('typeform', 'types_produits', 'acquisition', 'type');
        $this->add_admin_form('fraisform', 'frais', 'acquisition', 'frais');
        $this->add_admin_form('modeform', 'paiements', 'acquisition', 'mode');
        $this->add_admin_form('budgform', 'budgets', 'acquisition', 'budget');
        if ($this->filters['depth'] > 2) {
            $this->add_admin_form('rubform', 'rubriques', 'acquisition', 'budget');
        }
        if($acquisition_sugg_categ=='1') {
            $this->add_admin_form('categform', 'suggestions_categ', 'acquisition', 'categ');
        }
        $this->add_admin_form('srcform', 'suggestion_source', 'acquisition', 'src');
        $this->add_admin_form('lgstatform', 'lgstat', 'acquisition', 'lgstat');
        $this->add_admin_form('pricing_system_form', 'rent_pricing_system', 'acquisition', 'pricing_systems');
        if ($this->filters['depth'] > 2) {
            $this->add_admin_form('pricing_system_grid_form', 'rent_pricing_system_grid', 'acquisition', 'pricing_systems');
        }
        $this->add_admin_form('threshold_form', 'threshold', 'acquisition', 'thresholds');
        
        //Demandes
        if($demandes_active) {
            $this->add_admin_form('simple_list_form', 'demandes_theme', 'demandes', 'theme');
            $this->add_admin_form('simple_list_form', 'demandes_type', 'demandes', 'type');
            $this->add_admin_form('parperso_form', 'parametres_perso', 'demandes', 'perso');
        }
        
        //FAQ
        if($faq_active) {
            $this->add_admin_form('simple_list_form', 'faq_theme', 'faq', 'theme');
            $this->add_admin_form('simple_list_form', 'faq_type', 'faq', 'type');
        }
        
        //Template de mail
        $this->add_admin_form('mailtpl', 'mailtpl', 'mailtpl', 'build');
        
        //Numrisations
        if($pmb_scan_request_activate) {
            $this->add_admin_form('scan_request_status_form', 'scan_request_status', 'scan_request', 'status');
            $this->add_admin_form('scan_request_priority_form', 'scan_request_priority', 'scan_request', 'priorities');
        }
        
        $this->add_admin_form('module_form', 'module_model', 'interface', 'modules');
        $this->add_admin_form('selector_form', 'selector_model', 'interface', 'selectors');
        
        //Envoi de mails
        $this->add_admin_form('mail_setting_form', 'mail_setting', 'mails', 'settings');
    }
    
    /**
     * Entits
     */
    protected function _init_entity_forms() {
        //Autorits
        // 		$this->add_form('auteur', 'autorites', 'auteurs', 'author_form');
        // 		$this->add_form('editeur', 'autorites', 'editeurs', 'editeur_form');
        // 		$this->add_form('collection', 'autorites', 'collections', 'collection_form');
        // 		$this->add_form('subcollection', 'autorites', 'souscollections', 'collection_form');
        // 		$this->add_form('serie', 'autorites', 'series', 'serie_form');
        // 		$this->add_form('indexint', 'autorites', 'indexint', 'indexint_form');
        
        //Notices
        // 		$this->add_form('notice', 'catalog', 'create_form');
        // 		$this->add_form('serial', 'catalog', 'serials', 'serial_form');
        // 		$this->add_form('bulletinage', 'catalog', 'serials', 'bulletinage');
        // 		$this->add_form('analysis', 'catalog', 'serials', 'analysis');
        
    }
    
    protected function _init_forms() {
        if (!empty($this->filters['modules'])) {
            foreach ($this->filters['modules'] as $module) {
                $method_name = "_init_".$module."_forms";
                $this->{$method_name}();
            }
        } else {
            $this->_init_admin_forms();
            $this->_init_circ_forms();
            $this->_init_catalog_forms();
            $this->_init_autorites_forms();
            $this->_init_edit_forms();
            $this->_init_dsi_forms();
            $this->_init_acquisition_forms();
            $this->_init_demandes_forms();
            $this->_init_entity_forms();
        }
    }
    
    protected function get_form_model_instance($name, $model_name, $module, $categ, $sub='', $url_extra='') {
        $form = new form();
        $form->set_name($name);
        $form->set_model_name($model_name);
        $form->set_module($module);
        $form->set_categ($categ);
        $form->set_sub($sub);
        $form->set_url_extra($url_extra);
        return $form;
    }
    
    public function add_form($name, $model_name, $module, $categ, $sub='', $url_extra='') {
        if(empty($this->filters['modules']) || (!empty($this->filters['modules']) && in_array($module, $this->filters['modules']))) {
            $form = $this->get_form_model_instance($name, $model_name, $module, $categ, $sub, $url_extra);
            $this->add_object($form);
        }
    }
    
    public function add_parameters_form($name, $model_name, $module, $categ, $sub='', $url_extra='') {
        if(empty($this->filters['modules']) || (!empty($this->filters['modules']) && in_array($module, $this->filters['modules']))) {
            $form = $this->get_form_model_instance($name, $model_name, $module, $categ, $sub, $url_extra);
            $form->set_actions_buttons(['edition']);
            $this->add_object($form);
        }
    }
    
    /**
     * Initialisation des filtres disponibles
     */
    protected function init_available_filters() {
        $this->available_filters['main_fields'] = array(
            'modules' => 'admin_menu_modules'
        );
        $this->available_filters['custom_fields'] = array();
    }
    
    /**
     * Initialisation des filtres de recherche
     */
    public function init_filters($filters=array()) {
        
        $this->filters = array(
            'modules' => array(),
            'depth' => 3 //Profondeur d'apparition du formulaire
        );
        parent::init_filters($filters);
    }
    
    /**
     * Initialisation des colonnes disponibles
     */
    protected function init_available_columns() {
        $this->available_columns =
        array('main_fields' =>
            array(
                'label' => '103',
                'name' => 'Nom du formulaire',
                'tab' => 'tab',
                'subtab' => 'subtab',
                'model_name' => 'model_name',
                'module' => 'module',
                'categ' => 'categ',
                'sub' => 'sub',
                'url_extra' => 'url_extra',
                'section' => 'section',
                'initialization' => 'initialization'
            )
        );
        $this->available_columns['custom_fields'] = array();
    }
    
    protected function init_default_applied_sort() {
        $this->add_applied_sort('label');
    }
    
    protected function init_default_applied_group() {
        $this->applied_group = array(0 => 'module', 1 => 'section');
        // 		$this->applied_group = array(0 => 'module');
    }
    
    protected function init_no_sortable_columns() {
        $this->no_sortable_columns = array(
            'label', 'tab', 'subtab'
        );
    }
    
    protected function init_default_selected_filters() {
        $this->add_selected_filter('modules');
    }
    
    protected function init_default_pager() {
        parent::init_default_pager();
        $this->pager['all_on_page'] = true;
    }
    
    public function set_filters_from_form() {
        $this->set_filter_from_form('modules');
        parent::set_filters_from_form();
    }
    
    protected function init_default_columns() {
        $this->add_column('label');
        $this->add_column('tab');
        $this->add_column('subtab');
        $this->add_column('initialization');
    }
    
    protected function init_default_settings() {
        parent::init_default_settings();
        // 		$this->set_setting_display('search_form', 'visible', false);
        $this->set_setting_display('search_form', 'options', true);
        $this->set_setting_display('search_form', 'export_icons', false);
        $this->set_setting_display('query', 'human', false);
        $this->set_setting_column('default', 'align', 'left');
        $this->settings['objects']['default']['display_mode'] = 'expandable_table';
        // 		$this->settings['grouped_objects']['default']['display_mode'] = 'expandable_table';
        $this->settings['grouped_objects']['level_1']['display_mode'] = 'expandable_table';
    }
    
    protected function get_search_filter_modules() {
        global $msg;
        
        $options = array(
            'catalog' => $msg['6'],
            'autorites' => $msg['132'],
            'edit' => $msg['1100'],
            'dsi' => $msg['dsi_menu'],
            'admin' => $msg['7'],
        );
        sort($options);
        return $this->get_search_filter_multiple_selection('', 'modules', $msg["all"], $options);
    }
    
    protected function _get_object_property_module($object) {
        $list_modules_ui = list_modules_ui::get_instance();
        foreach ($list_modules_ui->get_objects() as $module) {
            if($module->get_name() == $object->get_module()) {
                return $module->get_label();
            }
        }
    }
    
    protected function _get_object_property_label($object) {
        $label = $this->_get_object_property_tab($object);
        $subtab = $this->_get_object_property_subtab($object);
        if($subtab) {
            $label .= " > ".$subtab;
        }
        return $label;
    }
    
    protected function _get_object_property_section($object) {
        global $msg;
        
        $tab = $this->_get_tab_from_object($object);
        if(is_object($tab)) {
            $section = $tab->get_section();
        } else {
            switch ($object->get_model_name()) {
                case 'facette':
                    if ($object->get_categ() == 'gestion') {
                        $section = 'admin_menu_gestion';
                    } else {
                        $section = 'opac_admin_menu';
                    }
                    break;
                case 'facette_search_compare':
                    $section = 'opac_admin_menu';
                    break;
                case 'notice':
                    $section = '4057';
                    break;
                case 'bulletinage':
                    $section = '771';
                    break;
                case 'analysis':
                    $section = '771';
                    break;
                case 'etagere':
                case 'etagere_caddies':
                    $section = 'etagere_menu';
                    break;
            }
        }
        if(!empty($section)) {
            if(isset($msg[$section])) {
                return $msg[$section];
            } else {
                return $section;
            }
        }
        return '';
    }
    
    protected function _get_object_property_initialization($object) {
        if($object->is_substituted()) {
            return 1;
        }
        return 0;
    }
    
    protected function get_cell_content($object, $property) {
        $content = '';
        switch($property) {
            case 'initialization':
                if($object->is_substituted()) {
                    $link = static::get_controller_url_base()."&action=delete&id=".$object->get_id();
                    $content .= $this->get_img_cell_content('initialization.png', 'initialize', $link, 'initialization_confirm');
                }
                break;
            default :
                $content .= parent::get_cell_content($object, $property);
                break;
        }
        return $content;
    }
    
    protected function _get_tabs($module, $categ) {
        if (!isset($this->tabs[$module][$categ])) {
            $this->tabs[$module][$categ] = array();
            $tabs_instance = $this->get_tabs_instance($module);
            $tabs_objects = $tabs_instance->get_objects();
            foreach ($tabs_objects as $tab_object) {
                if($tab_object->get_categ() == $categ) {
                    $this->tabs[$module][$categ][] = $tab_object;
                }
            }
        }
        return $this->tabs[$module][$categ];
    }
    
    protected function _get_tab_from_object($object) {
        $tabs = $this->_get_tabs($object->get_module(), $object->get_categ());
        if(!empty($tabs)) {
            if(count($tabs) == 1) {
                return $tabs[0];
            } else {
                foreach ($tabs as $tab) {
                    if($tab->get_sub() == $object->get_sub()) {
                        return $tab;
                    }
                }
            }
        }
    }
    
    protected function _get_object_property_tab($object) {
        global $msg;
        
        $tab = $this->_get_tab_from_object($object);
        if(is_object($tab)) {
            return $tab->get_label();
        } else {
            switch ($object->get_model_name()) {
                case 'facette':
                    if ($object->get_categ() == 'gestion') {
                        return $msg['gestion_facette'];
                    } else {
                        return $msg['opac_facette'];
                    }
                case 'facette_search_compare':
                    return $msg['opac_facette'];
                case 'notice':
                    return $msg['type_mono'];
                case 'bulletinage':
                    return $msg['type_bull'];
                case 'analysis':
                    return $msg['type_art'];
                case 'etagere':
                    return $msg['etagere_menu_gestion'];
                case 'etagere_caddies':
                    return $msg['etagere_menu_constitution'];
            }
        }
        return '';
    }
    
    protected function _get_subtabs($module, $categ, $sub) {
        if (!isset($this->subtabs[$module][$categ][$sub])) {
            $this->subtabs[$module][$categ][$sub] = array();
            $subtabs_instance = $this->get_subtabs_instance($module, $categ, $sub);
            if (is_object($subtabs_instance)) {
                $subtabs_objects = $subtabs_instance->get_objects();
                foreach ($subtabs_objects as $subtab_object) {
                    if($subtab_object->get_sub() == $sub) {
                        $this->subtabs[$module][$categ][$sub][] = $subtab_object;
                    }
                }
            }
        }
        return $this->subtabs[$module][$categ][$sub];
    }
    
    protected function _get_subtab_from_object($object) {
        $subtabs = $this->_get_subtabs($object->get_module(), $object->get_categ(), $object->get_sub());
        if(!empty($subtabs)) {
            if(count($subtabs) == 1) {
                return $subtabs[0];
            } else {
                foreach ($subtabs as $subtab) {
                    if($subtab->get_sub() == $object->get_sub()) {
                        return $subtab;
                    }
                }
            }
        }
    }
    
    protected function _get_object_property_subtab($object) {
        $subtab = $this->_get_subtab_from_object($object);
        if(is_object($subtab)) {
            return $subtab->get_label();
        }
        return '';
    }
    
    protected function get_default_attributes_format_cell($object, $property) {
        $attributes = array();
        if($object->is_in_database()) {
            $attributes['onclick'] = "window.location=\"".static::get_controller_url_base()."&action=edit&id=".$object->get_id()."\"";
        } else {
            $attributes['onclick'] = "window.location=\"".static::get_controller_url_base()."&action=edit&form_model_name=".$object->get_model_name()."&form_module=".$object->get_module()."\"";
        }
        return $attributes;
    }
    
    public function get_objects_data() {
        $this->add_column_objects_data('name');
        $this->add_column_objects_data('label');
        $this->add_column_objects_data('model_name');
        $this->add_column_objects_data('module');
        $this->add_column_objects_data('categ');
        $this->add_column_objects_data('sub');
        $this->add_column_objects_data('url_extra');
        return parent::get_objects_data();
    }
    
    public function get_tabs_instance($module) {
        $list_tabs_ui_name = "list_tabs_".$module."_ui";
        $list_tabs_ui_name::set_module_name($module);
        if(!isset($this->tabs_instances[$module])) {
            $this->tabs_instances[$module] = new $list_tabs_ui_name();
        }
        return $this->tabs_instances[$module];
    }
    
    public function get_subtabs_instance($module, $categ, $sub="") {
        $list_subtabs_ui_name = "list_subtabs_".$module."_ui";
        $list_subtabs_ui_name::set_module_name($module);
        $list_subtabs_ui_name::set_categ($categ);
        $list_subtabs_ui_name::set_sub($sub);
        if (!empty($sub)) {
            if(!isset($this->subtabs_instances[$module][$categ]) || !is_array($this->subtabs_instances[$module][$categ])) {
                $this->subtabs_instances[$module][$categ] = array();
            }
            if(!isset($this->subtabs_instances[$module][$categ][$sub])) {
                $this->subtabs_instances[$module][$categ][$sub] = new $list_subtabs_ui_name();
            }
            return $this->subtabs_instances[$module][$categ][$sub];
        }
        if(!isset($this->subtabs_instances[$module][$categ])) {
            $this->subtabs_instances[$module][$categ] = new $list_subtabs_ui_name();
        }
        return $this->subtabs_instances[$module][$categ];
    }
    
    public function get_label_from_object($object) {
        return $this->_get_object_property_label($object);
    }
    
    protected function is_allowed_export_list() {
        return true;
    }
}