<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_analysis_caddie_content_ui.class.php,v 1.1.4.3 2025/08/20 08:03:55 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_analysis_caddie_content_ui extends list_caddie_content_ui {
		
    public function get_dataset_title() {
        global $msg, $charset;
        
        if(isset($msg['caddie_de_ANALYSIS'])) {
            return htmlentities($msg['caddie_de_ANALYSIS'], ENT_QUOTES, $charset);
        }
        return parent::get_dataset_title();
    }
    
	protected function _get_query_select() {
	    $query_select = parent::_get_query_select();
	    $query_select .= ", bulletins.*";
	    return $query_select;
	}
	
	protected function _get_query_left_join() {
	    switch (static::$object_type) {
	        case 'NOTI':
	            return parent::_get_query_left_join()."
                    left join analysis on analysis_notice=notices.notice_id
					left join bulletins on analysis_bulletin=bulletins.bulletin_id";
	    }
	    return parent::_get_query_left_join();
	}
	
	protected function _get_query_items_data() {
	    return "SELECT analysis.analysis_notice AS record_id, ".$this->_get_query_select_fields('exemplaires')."
            FROM exemplaires
            JOIN bulletins ON bulletins.bulletin_id = exemplaires.expl_bulletin
            JOIN analysis ON analysis.analysis_bulletin = bulletins.bulletin_id
            WHERE analysis.analysis_notice IN (".implode(',', $this->records_ids).")";
	}

	protected function get_keep_fields($tablename) {
	    parent::get_keep_fields($tablename);
	    if(empty($this->keep_fields[$tablename])) {
    		$this->keep_fields[$tablename] = array();
    		switch (static::$object_type) {
    		    case 'NOTI':
            		switch ($tablename) {
            		    case 'exemplaires':
                		    $this->add_keep_field($tablename, 'expl_id', false);
                		    $this->add_keep_field($tablename, 'expl_cb');
                		    $this->add_keep_field($tablename, 'expl_cote');
                		    $this->add_keep_field($tablename, 'expl_date_depot');
                		    $this->add_keep_field($tablename, 'expl_date_retour');
                		    $this->add_keep_field($tablename, 'expl_note');
                		    $this->add_keep_field($tablename, 'expl_prix');
                		    $this->add_keep_field($tablename, 'expl_lastempr');
                		    $this->add_keep_field($tablename, 'last_loan_date');
                		    $this->add_keep_field($tablename, 'create_date');
                		    $this->add_keep_field($tablename, 'update_date');
                		    $this->add_keep_field($tablename, 'expl_comment');
                		    $this->add_keep_field($tablename, 'expl_nbparts');
                		    break;
            		}
    		}
		}
	    return $this->keep_fields[$tablename];
	}
	
	protected function get_exclude_fields() {
	    $exclude_fields = parent::get_exclude_fields();
	    switch (static::$object_type) {
	        case 'NOTI':
	            $exclude_fields[] = 'expl_notice';
	            $exclude_fields[] = 'expl_bulletin';
	            $exclude_fields[] = 'expl_typdoc';
	            $exclude_fields[] = 'expl_section';
	            $exclude_fields[] = 'expl_statut';
	            $exclude_fields[] = 'expl_location';
	            $exclude_fields[] = 'expl_codestat';
	            $exclude_fields[] = 'expl_owner';
	            $exclude_fields[] = 'type_antivol';
	            $exclude_fields[] = 'transfert_location_origine';
	            $exclude_fields[] = 'transfert_statut_origine';
	            $exclude_fields[] = 'transfert_section_origine';
	            $exclude_fields[] = 'idtyp_doc';
	            $exclude_fields[] = 'tdoc_owner';
	            $exclude_fields[] = 'expl_retloc';
	            $exclude_fields[] = 'expl_abt_num';
	            $exclude_fields[] = 'expl_ref_num';
	            $exclude_fields[] = 'expl_pnb_flag';
	            break;
	        default:
	            break;
	    }
	    return $exclude_fields;
	}
	
	protected function get_main_fields() {
	    $main_fields = parent::get_main_fields();
	    return array_merge(
	        $main_fields,
	        array('bulletin_numero' => '4025', 'mention_date' => 'bulletin_mention_periode', 'date_date' => 'date_parution_bulletin_query',
	        'bulletin_titre' => 'bulletin_mention_titre', 'bulletin_serial' => 'titre_perio_query', 'bulletin_cb' => 'bulletin_code_barre'),
	        $this->get_describe_fields('exemplaires', 'items', 'exemplaires')
	        );
		
	}
	
	protected function init_default_columns() {
	    parent::init_default_columns();
	    switch (static::$object_type) {
	        case 'NOTI':
	            $this->add_column('bulletin_numero');
	            $this->add_column('mention_date');
	            $this->add_column('date_date');
	            $this->add_column('bulletin_titre');
	            $this->add_column('bulletin_serial');
	            $this->add_column('bulletin_cb');
	            break;
	        default:
	            break;
	    }
	}
}