<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_abts_ui.class.php,v 1.1.4.4 2025/10/21 14:17:37 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_abts_ui extends list_ui {
	
	protected function init_default_settings() {
		parent::init_default_settings();
		$this->set_setting_display('search_form', 'unfolded_filters', true);
		$this->set_setting_display('search_form', 'export_icons', false);
		$this->set_setting_display('search_form', 'sorts', false);
		$this->set_setting_display('query', 'human', false);
		$this->set_setting_display('pager', 'visible', false);
		$this->settings['objects']['default']['display_mode'] = 'expandable_div';
		$this->settings['grouped_objects']['level_1']['display_mode'] = 'expandable_div';
		$this->set_setting_column('date_debut', 'datatype', 'date');
		$this->set_setting_column('date_fin', 'datatype', 'date');
	}
	
	protected function init_default_pager() {
		parent::init_default_pager();
		$this->pager['all_on_page'] = true;
	}
	
	protected function get_selection_query($type) {
		$query = '';
		switch ($type) {
			case 'locations':
				$query = 'select idlocation as id, location_libelle as label from docs_location order by label';
				break;
			case 'abts_status':
				$statuses = abts_status::get_ids_bulletinage_active();
				$query = 'select abts_status_id as id, abts_status_gestion_libelle as label from abts_status where abts_status_id IN ('.implode(',', $statuses).') order by label';
				break;
			case 'serials':
				$query = 'SELECT distinct notice_id as id, tit1 as label FROM notices JOIN abts_abts ON num_notice = notice_id ORDER BY label';
				break;
		}
		return $query;
	}
	
	protected function get_search_filter_abts_statut() {
		global $msg;
		return $this->get_search_filter_simple_selection($this->get_selection_query('abts_status'), 'abts_statut', $msg["all"]);
	}
	
	protected function get_search_filter_serials() {
		global $msg;
		return $this->get_search_filter_multiple_selection($this->get_selection_query('serials'), 'serials', $msg["all"]);
	}
	
	protected function _add_query_filters() {
		$this->_add_query_filter_simple_restriction('serial_id', 'num_notice', 'integer');
	}
	
	protected function _get_query_human_location() {
		$docs_location = new docs_location($this->filters['location']);
		return $docs_location->libelle;
	}
	
	protected function _get_query_human_abts_statut() {
		if($this->filters['abts_statut']) {
			$abts_status = new abts_status($this->filters['abts_statut']);
			return $abts_status->gestion_libelle;
		}
		return '';
	}
	
	protected function _get_query_human_serials() {
		if(!empty($this->filters['serials'])) {
			$labels = array();
			foreach ($this->filters['serials'] as $serial_id) {
				$labels[] = notice::get_notice_title($serial_id);
			}
			return implode(', ', $labels);
		}
	}
}