<?php

// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: indexation_animations.class.php,v 1.1.2.2 2025/06/26 08:10:23 qvarin Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) {
    die("no access");
}

global $class_path;
require_once($class_path."/indexation/indexation_entities.class.php");

class indexation_animations extends indexation_entities
{
	/**
	 * Construct
	 *
	 * @param string $xml_filepath
	 * @param string $table_prefix
	 * @param integer $type
	 */
    public function __construct($xml_filepath, $table_prefix, $type = 0)
    {
        $this->fields_prefix = 'anim_animations_fields';
        $this->words_prefix = 'anim_animations_words';
        parent::__construct($xml_filepath, $table_prefix, $type);
    }

	/**
	 * Clean temporary files
	 *
	 * @return void
	 */
    protected function clean_temporary_files()
    {
        netbase_entities::clean_files($this->directory_files);
    }

	/**
	 * Prefix temporary file
	 *
	 * @return string
	 */
    protected function get_prefix_temporary_file()
    {
        if (empty($this->prefix_temporary_file)) {
            $this->prefix_temporary_file = "indexation_anim_animations_".LOCATION;
        }
        return $this->prefix_temporary_file;
    }

	/**
	 * Push elements
	 *
	 * @param array $tab_insert
	 * @param array $tab_field_insert
	 * @return void
	 */
    protected function push_elements($tab_insert, $tab_field_insert)
    {
        if ($tab_insert && count($tab_insert)) {
            $req_insert = "insert into ".$this->table_prefix."_words_global_index(id_animation,code_champ,code_ss_champ,num_word,pond,position,field_position) values ".implode(',', $tab_insert)." ON DUPLICATE KEY UPDATE num_word = num_word";
            file_put_contents($this->directory_files.$this->words_prefix.'_global_index.sql', $req_insert."\n", FILE_APPEND);
        }
        if ($tab_field_insert && count($tab_field_insert)) {
            //la table pour les recherche exacte
            $req_insert = "insert into ".$this->table_prefix."_fields_global_index(id_animation,code_champ,code_ss_champ,ordre,value,lang,pond,authority_num) values ".implode(',', $tab_field_insert)." ON DUPLICATE KEY UPDATE value = value";
            file_put_contents($this->directory_files.$this->fields_prefix.'_global_index.sql', $req_insert."\n", FILE_APPEND);
        }
    }

	/**
	 * Save elements
	 *
	 * @param array $tab_insert
	 * @param array $tab_field_insert
	 * @return void
	 */
    protected function save_elements($tab_insert, $tab_field_insert)
    {
        if ($tab_insert && count($tab_insert)) {
            $req_insert = "insert into ".$this->table_prefix."_words_global_index(id_animation,code_champ,code_ss_champ,num_word,pond,position,field_position) values ".implode(',', $tab_insert)." ON DUPLICATE KEY UPDATE num_word = num_word";
            pmb_mysql_query($req_insert);
        }

        if ($tab_field_insert && count($tab_field_insert)) {
            //la table pour les recherche exacte
            $req_insert = "insert into ".$this->table_prefix."_fields_global_index(id_animation,code_champ,code_ss_champ,ordre,value,lang,pond,authority_num) values ".implode(',', $tab_field_insert)." ON DUPLICATE KEY UPDATE value = value";
            pmb_mysql_query($req_insert);
        }
    }

	/**
	 * Label
	 *
	 * @return string
	 */
    public function get_label()
    {
        global $msg;
        return $msg['nettoyage_reindex_animations'];
    }
}
