<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields_group.class.php,v 1.1.4.2 2025/11/21 09:06:59 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields_group {
	protected $id;
	protected $type = 'notices';
	protected $name = '';
	protected $title = '';
	protected $fields = [];
	
	public function __construct($id=0){
		$this->id = intval($id);
		$this->fetch_data();
	}
	
	protected function fetch_data() {
		if($this->id) {
			$query = "SELECT * FROM custom_fields_groups WHERE id_group=".$this->id;
			$result = pmb_mysql_query($query);
			if(pmb_mysql_num_rows($result)) {
    			$row = pmb_mysql_fetch_object($result);
    			$this->type = $row->group_type;
    			$this->name = $row->group_name;
    			$this->title = $row->group_title;
    			if(!empty($row->group_fields)) {
    			    $fields = encoding_normalize::json_decode($row->group_fields, true);
    			    if (is_array($fields)) {
    			        $this->fields = $fields;
    			    }
    			}
			}
		}
	}
	
	public function get_content_form() {
	    
	    $interface_content_form = new interface_content_form(static::class);
	    $interface_content_form->add_element('name', 'custom_fields_group_name')
	    ->add_input_node('text', $this->name);
	    
	    $interface_content_form->add_element('title', 'custom_fields_group_title')
	    ->add_input_node('text', $this->title)
	    ->set_attributes(array('data-translation-fieldname' => 'group_title'));
	    
	    if($this->id) {
	        // TODO : afficher les champs persos associes
	    }
	    return $interface_content_form->get_display();
	}
	
	public function get_form() {
		global $msg;
		
		$interface_form = new interface_admin_custom_fields_group_form('custom_fields_group_form');
		if(!$this->id){
		    $interface_form->set_label($msg['custom_fields_group_add']);
		}else{
		    $interface_form->set_label($msg['custom_fields_group_edit']);
		}
		$interface_form->set_object_id($this->id)
		->set_confirm_delete_msg(sprintf($msg['custom_fields_group_delete_confirm']))
		->set_content_form($this->get_content_form())
		->set_table_name('custom_fields_groups')
		->set_field_focus('name');
		return $interface_form->get_display();
	}
	
	public function set_properties_from_form() {
	    global $name, $title;
		
		$this->name = stripslashes($name);
		$this->title = stripslashes($title);
	}
	
	public function save() {
		if($this->id) {
			$query = "UPDATE custom_fields_groups SET ";
			$clause = " WHERE id_group=".$this->id;
		} else {
			$query = "INSERT INTO custom_fields_groups SET ";
			$clause = "";
		}
		$query .= "
			group_type='".addslashes($this->type)."',
			group_name='".addslashes($this->name)."',
			group_title='".addslashes($this->title)."',
            group_fields='".addslashes(encoding_normalize::json_encode($this->fields))."'
			".$clause;
		pmb_mysql_query($query);
		if(!$this->id) {
			$this->id = pmb_mysql_insert_id();
		}
		$translation = new translation($this->id, 'custom_fields_groups');
		$translation->update("group_title");
	}
	
	public static function delete($id=0) {
	    $id = intval($id);
		if($id) {
		    translation::delete($id, 'custom_fields_groups');
			$query = "DELETE FROM custom_fields_groups WHERE id_group=".$id;
			pmb_mysql_query($query);
			return true;
		}
		return false;
	}
	
	public function add_field($field_id) {
	    if (!in_array($field_id, $this->fields)) {
	        $this->fields[] = $field_id;
	    }
	}
	
	public function remove_field($field_id) {
	    printr($this->fields);
	    if (in_array($field_id, $this->fields)) {
	        foreach ($this->fields as $key=>$value) {
	            if ($field_id == $value) {
	                unset($this->fields[$key]);
	            }
	        }
	    }
	}
	
	public function get_id(){
		return $this->id;
	}
	
	public function get_type(){
	    return $this->type;
	}
	
	public function get_name(){
	    return $this->name;
	}
	
	public function get_title(){
	    return $this->title;
	}
	
	public function get_fields(){
	    return $this->fields;
	}
	
	public function set_id($id) {
	    $this->id = intval($id);
	}
	
	public function set_type($type) {
		$this->type = $type;
	}
	
	public function get_translated_title() {
	    return translation::get_translated_text($this->id, 'custom_fields_groups', 'group_title', $this->title);
	}
}

