<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: custom_fields.class.php,v 1.2.4.6 2025/11/19 08:55:27 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class custom_fields {
	
    protected static $type = '';
    
    protected static $is_repeatable = false;
    
    public static function get_aff_values($field) {
        return ($field['VALUES'] ? $field['VALUES'] : array(""));
    }
    
    public static function get_formatted_value($field, $value) {
        return $value;
    }
    
    public static function get_display_value($field, $indice, $value) {
        return '';
    }
    
    public static function get_block_dnd($field, $indice, $html, $value='') {
        global $charset;
        
        $field_name = $field['NAME'];
        return "
		<div id='customfield_".static::$type."_".$field_name."_".$indice."'  class='row' dragtype='customfield_".static::$type."_".$field_name."' draggable='yes' recept='yes' recepttype='customfield_".static::$type."_".$field_name."' handler='customfield_".static::$type."_".$field_name."_".$indice."_handle'
			dragicon='".get_url_icon('icone_drag_notice.png')."' dragtext=\"".htmlentities($value, ENT_QUOTES, $charset)."\" downlight=\"customfield_downlight\" highlight=\"customfield_highlight\"
			order='".$indice."' style='' >
			<span id=\"customfield_".static::$type."_".$field_name."_".$indice."_handle\" style=\"float:left; padding-right : 7px\"><img src='".get_url_icon('sort.png')."' style='width:12px; vertical-align:middle' /></span>
			".$html."
		</div>";
    }
    
    public static function get_block_value($value='') {
        switch (static::$type) {
            case 'comment':
            case 'html':
            case 'list':
            case 'marclist':
            case 'query_auth':
            case 'query_list':
            case 'resolve':
            case 'text_i18n':
            case 'text':
            case 'url':
                return $value."<br />";
            default :
                return $value;
        }
    }
    
    public static function get_display_values($field) {
        $options = $field['OPTIONS'][0];
        $values = static::get_aff_values($field);
        $indice = 0;
        $display = '';
        foreach ($values as $value) {
            $formatted_value = static::get_formatted_value($field, $value);
            $display_temp = static::get_display_value($field, $indice, $formatted_value);
            if(isset($options['REPEATABLE'][0]['value']) && $options['REPEATABLE'][0]['value']) {
                $button_add = '';
                if(end($values) == $value) {
                    $button_add=static::get_button_add($field, '', ['id' => 'button_add_'.$field['NAME'].'_'.$field['ID']]);
                }
                $display .= static::get_block_dnd($field, $indice, $display_temp.$button_add, $formatted_value);
            } else {
                $display .= static::get_block_value($display_temp);
            }
            switch (static::$type) {
                case 'comment':
                case 'html':
                    $display .= "<br / >";
                    break;
            }
            $indice++;
        }
        return $display;
    }
    
    public static function aff($field,&$check_scripts) {
        global $msg;
        
        $options = $field['OPTIONS'][0];
        $values = static::get_aff_values($field);
        $afield_name = $field["ID"];
        $ret = "";
        if(isset($options['REPEATABLE'][0]['value']) && $options['REPEATABLE'][0]['value']) {
            $ret .= get_js_function_dnd(static::$type, $field['NAME']);
            switch (static::$type) {
                case 'comment':
                case 'html':
                    $ret .= '<span style="vertical-align:top">';
                    $ret .= static::get_button_add($field);
                    $ret .= '</span>';
                    break;
                default:
                    $ret .= static::get_button_add($field);
                    break;
            }
        }
        $ret .= static::get_display_values($field);
        if (isset($options['REPEATABLE'][0]['value']) && $options['REPEATABLE'][0]['value']) {
            $ret .= '<input id="customfield_'.static::$type.'_'.$afield_name.'" type="hidden" name="customfield_'.static::$type.'_'.$afield_name.'" value="'.(count($values)).'">';
            $cleaned_type = str_replace('_', '', static::$type);
            $ret .= '<div id="spaceformorecustomfield'.$cleaned_type.'_'.$afield_name.'"></div>';
            $ret .= get_custom_dnd_on_add();
            $ret .= static::get_js_function_add($field);
        }
        if ($field['MANDATORY']==1) {
            $caller = get_form_name();
            $check_scripts.="if (document.forms[\"".$caller."\"].elements[\"".$field['NAME']."[]\"].value==\"\") return cancel_submit(\"".sprintf($msg["parperso_field_is_needed"],$field['ALIAS'])."\");\n";
        }
        return $ret;
    }
    
    protected static function get_chk_values($name) {
        global ${$name};
        return ${$name};
    }
    
    protected static function has_chk_mandatory() {
        return false;
    }
    
    public static function chk($field,&$check_message) {
        global $msg;
        
        $name=$field['NAME'];
        global ${$name};
        $val=static::get_chk_values($name);
        
        if(static::has_chk_mandatory()) {
            if ($field['MANDATORY']==1) {
                if ((empty($val))||(!count($val))||((count($val)==1)&&($val[0]==""))) {
                    $check_message=sprintf($msg["parperso_field_is_needed"],$field['ALIAS']);
                    return 0;
                }
            }
        }
        
        $check_datatype_message = "";
        $val_1 = chk_datatype($field, $val, $check_datatype_message);
        if (!empty($check_datatype_message)) {
            $check_message = $check_datatype_message;
            return 0;
        }
        ${$name} = $val_1;
        return 1;
    }
    
//     public static function val($field, $value) {
        
//     }
    
    public static function get_formatted_label_aff_filter($label) {
        return $label;
    }
        
    public static function aff_filter($field,$varname,$multiple) {
        global $charset;
        
        $ret="<select id=\"".$varname."\" name=\"".$varname;
        $ret.="[]";
        $ret.="\" ";
        if ($multiple) $ret.="size=5 multiple";
        $ret.=" data-form-name='".$varname."' >\n";
        
        $values=$field['VALUES'];
        if ($values=="") $values=array();
        $options=$field['OPTIONS'][0];
        if (($options['UNSELECT_ITEM'][0]['VALUE']!="")||($options['UNSELECT_ITEM'][0]['value']!="")) {
            $ret.="<option value=\"".htmlentities($options['UNSELECT_ITEM'][0]['VALUE'],ENT_QUOTES,$charset)."\"";
            if ($options['UNSELECT_ITEM'][0]['VALUE']==$options['DEFAULT_VALUE'][0]['value']) $ret.=" selected";
            $ret.=">".htmlentities($options['UNSELECT_ITEM'][0]['value'],ENT_QUOTES,$charset)."</option>\n";
        }
        $resultat=pmb_mysql_query($options['QUERY'][0]['value']);
        while ($r=pmb_mysql_fetch_row($resultat)) {
            $ret.="<option value=\"".htmlentities($r[0],ENT_QUOTES,$charset)."\"";
            $as=array_search($r[0],$values);
            if (($as!==FALSE)&&($as!==NULL)) $ret.=" selected";
            $ret.=">".htmlentities(static::get_formatted_label_aff_filter($r[0]),ENT_QUOTES,$charset)."</option>\n";
            
        }
        $ret.= "</select>\n";
        return $ret;
    }
    
    public static function get_rgaa_label($field, $varname) {
        return '';
    }
    
    public static function get_button_browse($field, $link) {
        global $msg;
        
        $onclick_event = "openPopUp('".$link."', 'select_perso_".$field['ID']."', 700, 500, -2, -2, 'toolbar=no, dependent=yes, resizable=yes, scrollbars=yes')";
//         return "<input type='button' class='bouton' value='...' onclick=\"".$onclick_event."\" />";
        $interface_node_button = new interface_node_button();
        $interface_node_button->set_value($msg['custom_fields_browse_button'])
        ->set_onclick($onclick_event)
        ->set_aria_label(sprintf($msg['custom_fields_browse_aria_label'], $field['ALIAS']));
        return $interface_node_button->get_display();
    }
    
    protected static function get_event_button_add($field) {
        return '';
    }
    
    public static function get_button_add($field, $onclick_event='', $attrs=[]){
        global $msg;
        
        if (empty($onclick_event)) {
            $onclick_event = static::get_event_button_add($field);
        }
//         return "<input type='button' class='bouton' value='+' onclick=\"".$onclick_event."\" />";
        $interface_node_button = new interface_node_button();
        $interface_node_button->set_value($msg['custom_fields_add_button'])
        ->set_onclick($onclick_event)
        ->set_aria_label(sprintf($msg['custom_fields_add_aria_label'], $field['ALIAS']));
        if (!empty($attrs['id'])) {
            $interface_node_button->set_id($attrs['id']);
        }
        return $interface_node_button->get_display();
    }
    
    public static function get_button_raz($field, $onclick_event='') {
        global $msg;
        
//         return "<input type='button' class='bouton' value='X' onclick=\"".$onclick_event."\" />";
        $interface_node_button = new interface_node_button();
        $interface_node_button->set_value($msg['custom_fields_raz_button'])
        ->set_onclick($onclick_event)
        ->set_aria_label(sprintf($msg['custom_fields_raz_aria_label'], $field['ALIAS']));
        return $interface_node_button->get_display();
    }
    
}