<?php
// +-------------------------------------------------+
// | 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: abts_modele.class.php,v 1.1.4.5 2025/10/10 12:39:06 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

global $class_path, $include_path;
require_once($include_path."/templates/abts_modeles.tpl.php");
require_once($class_path."/serial_display.class.php");
require_once($include_path."/abts_func.inc.php");
require_once($class_path."/abts/abts_abonnement.class.php");

class abts_modele {
    public $modele_id; //Numro du modle
    public $modele_name; //Nom du modle
    public $num_notice; //numro de la notice lie
    public $num_periodicite; //Identifiant de la priodicit
    public $duree_abonnement; //Dure de l'abonnement
    public $date_debut; //Date de dbut de validit du modle
    public $date_fin; //Date de fin de validit du modle
    public $days; //Jours de la semaine exclus
    public $day_month; //Jours du mois exclus
    public $week_month; //Semaine du mois exclue
    public $week_year; //Semaine de l'anne exclue
    public $month_year; //Mois dans l'anne exclu
    public $error; //Erreur
    public $error_message; //Message d'erreur
    public $num_cycle;
    public $num_combien;
    public $num_increment;
    public $num_date_unite;
    public $num_increment_date;
    public $num_increment_day_of_month;
    public $num_increment_month_of_year;
    public $num_depart;
    public $vol_actif;
    public $vol_increment;
    public $vol_date_unite;
    public $vol_increment_numero;
    public $vol_increment_date;
    public $vol_increment_day_of_month;
    public $vol_increment_month_of_year;
    public $vol_cycle;
    public $vol_combien;
    public $vol_depart;
    public $tom_actif;
    public $tom_increment;
    public $tom_date_unite;
    public $tom_increment_numero;
    public $tom_increment_date;
    public $tom_increment_day_of_month;
    public $tom_increment_month_of_year;
    public $tom_cycle;
    public $tom_combien;
    public $tom_depart;
    public $format_aff;
    public $format_periode;
    
    public function __construct($modele_id="") {
        $this->modele_id=intval($modele_id);
        $this->initData();
        $this->getData();
    }
    
    public function initData() {
        $this->modele_name = '';
        $this->num_notice = 0;
        $this->num_periodicite = '';
        $this->duree_abonnement = 12;
        $this->date_debut = '';
        $this->date_fin = '';
        $this->days = '';
        $this->day_month = '';
        $this->week_month = '';
        $this->week_year = '';
        $this->month_year = '';
        $this->num_cycle = 0;
        $this->num_combien = 12;
        $this->num_increment = 0;
        $this->num_date_unite = 1;
        $this->num_increment_date = 12;
        $this->num_increment_day_of_month = 1;
        $this->num_increment_month_of_year = 1;
        $this->num_depart = 1;
        $this->vol_actif = 0;
        $this->vol_increment = 0;
        $this->vol_date_unite = 1;
        $this->vol_increment_numero = 12;
        $this->vol_increment_date = 12;
        $this->vol_increment_day_of_month = 01;
        $this->vol_increment_month_of_year = 01;
        $this->vol_cycle = 0;
        $this->vol_combien = 1;
        $this->vol_depart = 1;
        $this->tom_actif = 0;
        $this->tom_increment = 10;
        $this->tom_date_unite = 2;
        $this->tom_increment_numero = 1;
        $this->tom_increment_date = 1;
        $this->tom_increment_day_of_month = 01;
        $this->tom_increment_month_of_year = 01;
        $this->tom_cycle = 0;
        $this->tom_combien = 1;
        $this->tom_depart = 1;
        $this->format_aff = '';
        $this->format_periode = '';
        $this->error = '';
        $this->error_message = '';
    }
    
    public function getData() {
        
        if ($this->modele_id) {
            $requete = "select * from abts_modeles where modele_id=".$this->modele_id;
            $resultat = pmb_mysql_query($requete);
            if (pmb_mysql_num_rows($resultat)) {
                $r = pmb_mysql_fetch_object($resultat);
                $this->modele_name = $r->modele_name;
                $this->num_notice = $r->num_notice;
                $this->num_periodicite = $r->num_periodicite;
                $this->duree_abonnement = $r->duree_abonnement;
                $this->date_debut = $r->date_debut;
                $this->date_fin = $r->date_fin;
                $this->days = $r->days;
                $this->day_month = $r->day_month;
                $this->week_month = $r->week_month;
                $this->week_year = $r->week_year;
                $this->month_year = $r->month_year;
                $this->num_cycle = $r->num_cycle;
                $this->num_combien = $r->num_combien;
                $this->num_increment = $r->num_increment;
                $this->num_date_unite = $r->num_date_unite;
                $this->num_increment_date = $r->num_increment_date;
                $this->num_increment_day_of_month = $r->num_increment_day_of_month;
                $this->num_increment_month_of_year = $r->num_increment_month_of_year;
                $this->num_depart = $r->num_depart;
                $this->vol_actif = $r->vol_actif;
                $this->vol_increment = $r->vol_increment;
                $this->vol_date_unite = $r->vol_date_unite;
                $this->vol_increment_numero = $r->vol_increment_numero;
                $this->vol_increment_date = $r->vol_increment_date;
                $this->vol_increment_day_of_month = $r->vol_increment_day_of_month;
                $this->vol_increment_month_of_year = $r->vol_increment_month_of_year;
                $this->vol_cycle = $r->vol_cycle;
                $this->vol_combien = $r->vol_combien;
                $this->vol_depart = $r->vol_depart;
                $this->tom_actif = $r->tom_actif;
                $this->tom_increment = $r->tom_increment;
                $this->tom_date_unite = $r->tom_date_unite;
                $this->tom_increment_numero = $r->tom_increment_numero;
                $this->tom_increment_date = $r->tom_increment_date;
                $this->tom_increment_day_of_month = $r->tom_increment_day_of_month;
                $this->tom_increment_month_of_year = $r->tom_increment_month_of_year;
                $this->tom_cycle = $r->tom_cycle;
                $this->tom_combien = $r->tom_combien;
                $this->tom_depart = $r->tom_depart;
                $this->format_aff = $r->format_aff;
                $this->format_periode = $r->format_periode;
            } else {
                $this->error = true;
                $this->error_message = "Le modle demand n'existe pas";
            }
        }
    }
    
    public function set_perio($num_notice) {
        $this->num_notice = 0;
        $requete = "select niveau_biblio from notices where notice_id=".$num_notice;
        $resultat = pmb_mysql_query($requete);
        if (pmb_mysql_num_rows($resultat)) {
            if (pmb_mysql_result($resultat,0,0)=="s")
                $this->num_notice = $num_notice;
        } else {
            $this->error = true;
            $this->error_message = "La notice lie n'existe pas ou n'est pas un priodique";
        }
    }
    
    protected function get_display_cell_label($for, $label) {
        global $charset;
        return "<label for='".$for."' style='all:unset'>".htmlentities($label, ENT_QUOTES, $charset)."</label>";
    }
    
    protected function get_display_cell_checkbox($name, $value, $included) {
        return "<input type='checkbox' value='$value' ".(!$included && $this->modele_id ? "checked='checked'" : "")." id='".$name."_".$value."' name='".$name."[$value]' />";
    }
    
    protected function get_display_cell($name, $value, $included, $label) {
        return "
        <div>
            ".$this->get_display_cell_label($name.'_'.$value, $label)."
            ".$this->get_display_cell_checkbox($name, $value, $included)."
        </div>";
    }
    
    protected function get_calendar_unit_fieldset_content_form($name, $legend, $content) {
        global $charset;
        
        return "
        <fieldset class='abts-fieldset'>
            <legend class='abts-legend'>".htmlentities($legend, ENT_QUOTES, $charset)."</legend>
            <div class='abts-calendar-grid abts-".$name."-grid'>
                ".$content."
            </div>
        </fieldset>";
    }
    
    /**
     * Jours de la semaine exclus
     * @return string
     */
    protected function get_days_content_form() {
        global $msg;
        
        $legend = $msg["abonnements_periodicite_jours_semaine_exclus"];
        $days = "";
        for ($i=1; $i<8; $i++) {
            $tmp = '';
            if (substr($this->days, $i-1, 1)) {
                $tmp = substr($this->days, $i-1, 1);
            }
            $days .= $this->get_display_cell('days', $i, $tmp, $msg["week_days_short_".$i]);
        }
        return $this->get_calendar_unit_fieldset_content_form('days', $legend, $days);
    }
    
    /**
     * Jours du mois exclus
     * @return string
     */
    protected function get_days_month_content_form() {
        global $msg;
        
        $legend = $msg["abonnements_periodicite_jours_mois_exclus"];
        $day_month="";
        for ($j=0;$j<3;$j++) {
            for ($i=0; $i<15; $i++) {
                if (($j*(14+1)+$i+1)>31) break;
                $tmp = '';
                if (substr($this->day_month, ($j*(15)+$i), 1)) {
                    $tmp = substr($this->day_month, ($j*(15)+$i), 1);
                }
                $day_month .= $this->get_display_cell('day_month', ($j*(15)+$i+1), $tmp, ($j*(14+1)+$i+1));
            }
        }
        return $this->get_calendar_unit_fieldset_content_form('days-month', $legend, $day_month);
    }
    
    /**
     * Semaines dans le mois exclues
     */
    protected function get_week_month_content_form() {
        global $msg;
        
        $legend = $msg["abonnements_periodicite_semaines_mois_exclus"];
        $week_month="";
        for ($i=1; $i<7; $i++) {
            $tmp = '';
            if (substr($this->week_month, $i-1, 1)) {
                $tmp = substr($this->week_month, $i-1, 1);
            }
            $week_month .= $this->get_display_cell('week_month', $i, $tmp, $i);
        }
        return $this->get_calendar_unit_fieldset_content_form('week-month', $legend, $week_month);
    }
    
    /**
     * Semaines dans l'anne exclues
     */
    protected function get_week_year_content_form() {
        global $msg;
        
        $legend = $msg["abonnements_periodicite_semaines_annee_exclus"];
        $week_year="";
        $nb_x=15;
        $nb=54;
        for ($j=0;$j<($nb/$nb_x);$j++) {
            for ($i=0; $i<$nb_x; $i++) {
                if (($j*($nb_x)+$i+1)>($nb)) break;
                $tmp = '';
                if (substr($this->week_year, ($j*($nb_x)+$i), 1)) {
                    $tmp = substr($this->week_year, ($j*($nb_x)+$i), 1);
                }
                $week_year .= $this->get_display_cell('week_year', ($j*($nb_x)+$i+1), $tmp, ($j*($nb_x)+$i+1));
            }
        }
        return $this->get_calendar_unit_fieldset_content_form('week-year', $legend, $week_year);
    }
    
    /**
     * Mois dans l'anne exclus
     */
    protected function get_month_year_content_form() {
        global $msg;
        
        $legend = $msg["abonnements_periodicite_mois_annee_exclus"];
        $month_year="";
        $nb_x=6;
        $nb=12;
        for ($j=0;$j<($nb/$nb_x);$j++) {
            for ($i=0; $i<$nb_x; $i++) {
                if (($j*($nb_x)+$i+1)>($nb)) break;
                $tmp = '';
                if (substr($this->month_year, ($j*($nb_x)+$i), 1)) {
                    $tmp = substr($this->month_year, ($j*($nb_x)+$i), 1);
                }
                $month_year .= $this->get_display_cell('month_year', ($j*($nb_x)+$i+1), $tmp, $msg[($j*($nb_x)+$i)+1006]);
            }
        }
        return $this->get_calendar_unit_fieldset_content_form('month-year', $legend, $month_year);
    }
    
    /**
     * Retourne une structure formatte comme un tableau afin de rester rtro-compatible
     * @param array $headers
     * @param array $cells
     * @return string
     */
    protected function get_formatted_grid_content_form($headers = [], $cells = []) {
        if (empty($headers)) {
            return "";
        }
        $formatted_grid = "<div class='abts-grid-table abts-grid-table-".count($headers)."'>";
        foreach ($headers as $header) {
            $formatted_grid .= "<div class='abts-grid-cell abts-grid-header'>";
            if (!empty($header['for'])) {
                $formatted_grid .= "<label for='".$header['for']."' style='all:unset'>".$header['html']."</label>";
            } else {
                $formatted_grid .= $header['html'];
            }
            $formatted_grid .= "</div>";
        }
        foreach ($cells as $cell) {
            $formatted_grid .= "<div class='abts-grid-cell'>";
            $formatted_grid .= $cell['html'];
            $formatted_grid .= "</div>";
        }
        $formatted_grid .= "</div>";
        return $formatted_grid;
    }
    
    protected function get_selector_date_unite($property) {
        global $msg;
        return "
		<select id='".$property."' name='".$property."'>
			<option value='0' ".($this->{$property} == 0 ? "selected='selected'" : "").">".$msg['abonnements_periodicite_unite_jour']."</option>
			<option value='1' ".($this->{$property} == 1 ? "selected='selected'" : "").">".$msg['abonnements_periodicite_unite_mois']."</option>
			<option value='2' ".($this->{$property} == 2 ? "selected='selected'" : "").">".$msg['abonnements_periodicite_unite_annee']."</option>
		</select>";
    }
    
    protected function get_selector_month_of_year($property, $selected = 01) {
        global $msg;
        
        $selector = "<select id='".$property."' name='".$property."'>";
        $months = array($msg[1006],$msg[1007],$msg[1008],$msg[1009],$msg[1010],$msg[1011],$msg[1012],$msg[1013],$msg[1014],$msg[1015],$msg[1016],$msg[1017]);
        foreach ($months as $key=>$label) {
            $value = ($key+1);
            $selector .= "<option value='".$value."' ".($this->{$property} == $value ? "selected='selected'" : "").">".$label."</option>";
        }
        $selector .= "<select>";
        return $selector;
    }
    /**
     * Numrotation:  Numro
     */
    protected function get_numero_content_form() {
        global $msg;
        
        $content_form = "";
        if(!isset($msg["abonnements_incrementation_selon_date_2"])) {
            $msg["abonnements_incrementation_selon_date_2"]= '';
        }
        
        //Actif
        $headers = [
            ['for' => 'facilite', 'html' => $msg["abonnements_actif"]]
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' checked='checked'  disabled='disabled' name='facilite' id='facilite' />"]
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        //Cyclique
        $headers = [
            ['for' => 'num_cycle', 'html' => $msg["abonnements_cyclique"]],
            ['for' => '', 'html' => ''],
            ['for' => '', 'html' => ''],
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' ".($this->num_cycle ?"checked" : "")." name='num_cycle[1]' id='num_cycle'  onClick='gere_num(\"num_cycle\");'/>"],
            ['html' => ""],
            ['html' => ""],
            ['html' => ""],
            ['html' => "<input type='radio' name='num_increment' id='num_increment' value='0' ".($this->num_increment==0 ? "checked" : "").">".$msg["abonnements_incrementation_selon_numero_1"]."<input type='text' size='5' name='num_combien' id='num_combien' value='$this->num_combien'/>".$msg["abonnements_incrementation_selon_numero_2"]],
            ['html' => "<label for='num_depart' style='all:unset'>".$msg["abonnements_numero_depart"]."</label>"],
            ['html' => ""],
            ['html' => "<input type='radio' name='num_increment' id='num_increment1' value='1' ".($this->num_increment==1 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='text' size='5' name='num_increment_date' id='num_increment_date' value='$this->num_increment_date'/>".$this->get_selector_date_unite('num_date_unite').$msg["abonnements_incrementation_selon_date_2"]],
            ['html' => "<input type='text' size='5' name='num_depart' id='num_depart' value='".$this->num_depart."' />"],
            ['html' => ""],
            ['html' => "<input type='radio' name='num_increment' id='num_increment2' value='2' ".($this->num_increment==2 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='number' size='5' name='num_increment_day_of_month' id='num_increment_day_of_month' min='1' max='31' value='$this->num_increment_day_of_month'/>".$this->get_selector_month_of_year('num_increment_month_of_year')],
            ['html' => ""],
                
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        return $content_form;
    }
    
    /**
     * Numrotation: Volume
     * @return string
     */
    protected function get_volume_content_form() {
        global $msg;
        
        $content_form = "";
        
        //Actif
        $headers = [
            ['for' => 'vol_actif', 'html' => $msg["abonnements_actif"]]
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' ".($this->vol_actif && $this->modele_id ? "checked" : "")." name='vol_actif[1]' id='vol_actif'  onClick='gere_num(\"vol_actif\");'/>"]
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        //Incrmentation
        $headers = [
            ['html' => $msg["abonnements_incrementation"]],
            ['html' => '']
        ];
        $cells = [
            ['html' => ''],
            ['html' => "<input type='radio' name='vol_increment' id='vol_increment' value='0' ".($this->vol_increment==0 ? "checked" : "").">".$msg["abonnements_incrementation_selon_numero_1"]."<input type='text' size='5' name='vol_increment_numero' id='vol_increment_numero' value='$this->vol_increment_numero'/>".$msg["abonnements_incrementation_selon_numero_2"]],
            ['html' => ''],
            ['html' => "<input type='radio' name='vol_increment' id='vol_increment1' value='1' ".($this->vol_increment==1 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='text' size='5' name='vol_increment_date' id='vol_increment_date' value='$this->vol_increment_date'/>".$this->get_selector_date_unite('vol_date_unite').$msg["abonnements_incrementation_selon_date_2"]],
            ['html' => ''],
            ['html' => "<input type='radio' name='vol_increment' id='vol_increment2' value='2' ".($this->vol_increment==2 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='number' size='5' name='vol_increment_day_of_month' id='vol_increment_day_of_month' min='1' max='31' value='$this->vol_increment_day_of_month'/>".$this->get_selector_month_of_year('vol_increment_month_of_year')],
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        //Cyclique
        $headers = [
            ['for' => 'vol_cycle', 'html' => $msg["abonnements_cyclique"]],
            ['for' => 'vol_combien', 'html' => $msg["abonnements_combien"]],
            ['for' => 'vol_depart', 'html' => $msg["abonnements_numero_depart"]]
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' ".($this->vol_cycle && $this->modele_id ?"checked":"yes")." name='vol_cycle[1]' id='vol_cycle'  onClick='gere_num(\"vol_cycle\");'/>"],
            ['html' => "<input type='text' size='5' name='vol_combien' id='vol_combien' value='".$this->vol_combien."'/>"],
            ['html' => "<input type='text' size='5' name='vol_depart' id='vol_depart' value='".$this->vol_depart."'/>"]
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        return $content_form;
    }
    
    /**
     * Numrotation: Tome
     * @return string
     */
    protected function get_tome_content_form() {
        global $msg;
        
        $content_form = "";
        
        //Actif
        $headers = [
            ['for' => 'tom_actif', 'html' => $msg["abonnements_actif"]]
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' ".($this->tom_actif && $this->modele_id ? "checked" : "")." name='tom_actif[1]' id='tom_actif'   onClick='gere_num(\"tom_actif\");'/>"]
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        //Incrmentation
        $headers = [
            ['html' => $msg["abonnements_incrementation"]],
            ['html' => '']
        ];
        $cells = [
            ['html' => ''],
            ['html' => "<input type='radio' name='tom_increment' id='tom_increment' value='0' ".($this->tom_increment==0 ? "checked" : "").">".$msg["abonnements_incrementation_selon_volume_1"]."<input type='text' size='5' name='tom_increment_numero' id='tom_increment_numero' value='$this->tom_increment_numero'/>".$msg["abonnements_incrementation_selon_volume_2"]],
            ['html' => ''],
            ['html' => "<input type='radio' name='tom_increment' id='tom_increment1'  value='1' ".($this->tom_increment==1 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='text' size='5' name='tom_increment_date' id='tom_increment_date' value='$this->tom_increment_date'/>".$this->get_selector_date_unite('tom_date_unite').$msg["abonnements_incrementation_selon_date_2"]],
            ['html' => ''],
            ['html' => "<input type='radio' name='tom_increment' id='tom_increment2' value='2' ".($this->tom_increment==2 ? "checked" : "").">".$msg["abonnements_incrementation_selon_date_1"]."<input type='number' size='5' name='tom_increment_day_of_month' id='tom_increment_day_of_month' min='1' max='31' value='$this->tom_increment_day_of_month'/>".$this->get_selector_month_of_year('tom_increment_month_of_year')],
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        
        //Cyclique
        $headers = [
            ['for' => 'tom_cycle', 'html' => $msg["abonnements_cyclique"]],
            ['for' => 'tom_combien', 'html' => $msg["abonnements_combien"]],
            ['for' => 'tom_depart', 'html' => $msg["abonnements_numero_depart"]]
        ];
        $cells = [
            ['html' => "<input type='checkbox' value='1' ".($this->tom_cycle && $this->modele_id ? "checked" : "")." name='tom_cycle[1]' id='tom_cycle' onClick='gere_num(\"tom_cycle\");'/>"],
            ['html' => "<input type='text' size='5' name='tom_combien' id='tom_combien' value='".$this->tom_combien."'/>"],
            ['html' => "<input type='text' size='5' name='tom_depart' id='tom_depart' value='".$this->tom_depart."'/>"]
        ];
        $content_form .= $this->get_formatted_grid_content_form($headers, $cells);
        return $content_form;
    }
    
    public function get_date_debut() {
        if (!$this->date_debut || $this->date_debut == "0000-00-00") {
            return date("Y-m-d",time());
        } else {
            return $this->date_debut;
        }
    }
    public function get_date_fin($date_debut='') {
        if (empty($date_debut)) {
            $date_debut = $this->get_date_debut();
        }
        if (!$this->date_fin || $this->date_fin == "0000-00-00") {
            return pmb_sql_value("SELECT DATE_ADD('".$date_debut."', INTERVAL 1 YEAR)");
        } else {
            return $this->date_fin;
        }
    }
    
    public function get_content_form() {
        global $msg, $charset;
        global $modele_content_form;
        
        $interface_content_form = new interface_content_form(static::class);
        $interface_content_form->add_element('modele_name', 'abonnements_nom_modele')
        ->set_class('colonne2')
        ->add_input_node('text', $this->modele_name);
        
        $interface_content_form->add_element('empty_1')
        ->add_html_node('&nbsp;');
        
        //Priodicit
        $interface_content_form->add_element('num_periodicite', 'abonnements_periodicite')
        ->set_class('colonne2')
        ->add_query_node('select', 'select periodicite_id,libelle from abts_periodicites', $this->num_periodicite)
        ->set_first_option('0', $msg['abonnements_periodicite_manuel']);
        
        //Dure d'abonnement
        $interface_content_form->add_element('duree_abonnement', 'abonnements_duree_abonnement')
        ->set_class('colonne_suite')
        ->add_input_node('integer', $this->duree_abonnement);
        
        $interface_content_form->add_element('empty_2')
        ->add_html_node('&nbsp;');
        
        //Date de dbut
        $interface_content_form->add_element('date_debut', 'abonnements_date_debut')
        ->set_class('colonne2')
        ->add_input_node('date', $this->get_date_debut());
        
        //Date de fin
        $date_fin = $this->get_date_fin();
        $interface_content_form->add_element('date_fin', 'abonnements_date_fin')
        ->set_class('colonne_suite')
        ->add_input_node('date', $date_fin);
        
        $content_form = $interface_content_form->get_display();
        $content_form .= $modele_content_form;
        
        //Jours de la semaine exclus
        $content_form=str_replace("!!days!!",$this->get_days_content_form(),$content_form);
        
        //Jours du mois exclus
        $content_form=str_replace("!!days_month!!",$this->get_days_month_content_form(),$content_form);
        
        //Semaines dans le mois exclues
        $content_form=str_replace("!!week_month!!",$this->get_week_month_content_form(),$content_form);
        
        //Semaines dans l'anne exclues
        $content_form=str_replace("!!week_year!!",$this->get_week_year_content_form(),$content_form);
        
        //Mois dans l'anne exclus
        $content_form=str_replace("!!month_year!!",$this->get_month_year_content_form(),$content_form);
        
        //Numrotation:  Numro
        $content_form=str_replace("!!numero!!",$this->get_numero_content_form(),$content_form);
        
        //Numrotation: Volume
        $content_form=str_replace("!!volume!!",$this->get_volume_content_form(),$content_form);
        
        //Numrotation: Tome
        $content_form=str_replace("!!tome!!",$this->get_tome_content_form(),$content_form);
        
        $format="<table role='presentation'>";
        
        $format_t="<tr>";
        $format_v="<tr>";
        $format_t.="<td><label for='format_aff' style='all:unset'>".$msg["abonnements_format_numero"]."</label></td>";
        $format_v.="<td><input type='text' size='100' name='format_aff' id='format_aff' value='".htmlentities($this->format_aff,ENT_QUOTES,$charset)."'/></td>";
        $format_t.="</tr>";
        $format_v.="</tr>";
        $format.=$format_t."\n".$format_v."\n";
        
        $content_form=str_replace("!!format!!",$format,$content_form);
        
        $format_t="<tr>";
        $format_v="<tr>";
        $format_t.="<td><label for='format_periode' style='all:unset'>".$msg["abonnements_format_periode"]."</label></td>";
        $format_v.="<td><input type='text' size='100' name='format_periode' id='format_periode' value='".htmlentities($this->format_periode,ENT_QUOTES,$charset)."'/></td>";
        $format_t.="</tr>";
        $format_v.="</tr>";
        $format=$format_t."\n".$format_v."\n";
        
        $format.="</table>";
        
        $content_form=str_replace("!!format_periode!!",$format,$content_form);
        
        return $content_form;
    }
    
    public function get_calendar() {
        global $serial_id;
        
        $calend="
			<script type=\"text/javascript\" src='./javascript/select.js'></script>
			<script type=\"text/javascript\" src='./javascript/ajax.js'></script>";
        
        $abts_calendar = new abts_calendar($this->modele_id, 'modele');
        $abts_calendar->set_num_serial($serial_id)
        ->set_date_debut($this->date_debut)
        ->set_date_fin($this->get_date_fin());
        $calend .= $abts_calendar->get_display();
        return $calend;
    }
    
    public function show_form() {
        global $modele_form;
        global $serial_header;
        global $msg;
        global $charset;
        global $tpl_del_bouton,$tpl_copy_bouton;
        
        $r=$serial_header.$modele_form;
        
        if (!$this->modele_id) {
            $r=str_replace('!!page_title!!', $msg[4000].$msg[1003].$msg["abts_modeles_add_title"], $r);
            $r=str_replace('!!libelle_form!!', $msg["abts_modeles_add_title"], $r);
            // 			// Valeur par dfaut
            $this->format_aff = sprintf($msg['abts_no'],"\$NUM;");
            $this->format_periode = sprintf($msg['abts_periode'],"\$DATE;");
        } else {
            $r=str_replace('!!page_title!!', $msg[4000].$msg[1003].$msg["abts_modeles_modify_title"], $r);
            $r=str_replace('!!libelle_form!!', $msg["abts_modeles_modify_title"], $r);
        }
        //Construction du formulaire
        if ($this->modele_id){
            $del_bouton=$tpl_del_bouton;
            $copy_bouton=$tpl_copy_bouton;
        }else{
            $copy_bouton=$del_bouton="";
        }
        $this->getData();
        $r=str_replace("!!del_button!!",$del_bouton,$r);
        $r=str_replace("!!copy_bouton!!",$copy_bouton,$r);
        
        //Remplacement des valeurs
        $r=str_replace("!!modele_id!!",htmlentities($this->modele_id,ENT_QUOTES,$charset),$r);
        
        //Notice mre
        $perio=new serial_display($this->num_notice,1);
        $r=str_replace("!!num_notice_libelle!!",$perio->header,$r);
        $r=str_replace("!!num_notice!!",$this->num_notice,$r);
        
        
        $r=str_replace("!!content_form!!",$this->get_content_form(),$r);
        
        
        global $serial_id;
        $r=str_replace("!!action!!","./catalog.php?categ=serials&sub=modele&serial_id=".$serial_id,$r);
        $r=str_replace("!!serial_id!!",$serial_id,$r);
        
        
        if ($this->modele_id) {
            $r .= $this->get_calendar();
        }
        return $r;
    }
    
    public function gen_date(){
        if($this->modele_id) {
            $dummy = "delete FROM abts_grille_modele WHERE num_modele='".$this->modele_id."' ";
            pmb_mysql_query($dummy);
            
            $date = construitdateheuremysql($this->date_debut);
            $date_fin = construitdateheuremysql($this->date_fin);
            
            //Lire la priodict
            $duree=1;
            $requete="select duree,unite from abts_periodicites where periodicite_id='".$this->num_periodicite."'";
            $resultat=pmb_mysql_query($requete);
            if($r=pmb_mysql_fetch_object($resultat)) {
                $duree=$r->duree;
                $unite=$r->unite;
                do {
                    $dayofweek=pmb_sql_value("SELECT DAYOFWEEK('".$date."')");	//1 = Dimanche, 2 = Lundi, ... 7 = Samedi
                    if($dayofweek==1)$dayofweek=8;
                    $dayofweek--;
                    $day=pmb_sql_value("SELECT DAYOFMONTH('".$date."')");	// 1  31
                    $month=pmb_sql_value("SELECT MONTH('".$date."')");	//1  12
                    $week=pmb_sql_value("SELECT WEEK('".$date."',5)") + 1;//0 ... 53
                    
                    //calcul numero de semaine dans le mois
                    $weekofmonth=intval(($day+7-$dayofweek)/7)+1;
                    
                    //Mois dans l'anne exclu
                    if (substr($this->month_year, $month-1, 1)) {
                        if (substr($this->week_year, $week-1, 1)) {
                            if (substr($this->week_month, $weekofmonth-1, 1)) {
                                if (substr($this->day_month, $day-1, 1)) {
                                    if (substr($this->days, $dayofweek-1, 1)) {
                                        //c'est un jour prvu de rception
                                        $requete = "INSERT INTO abts_grille_modele SET num_modele='".$this->modele_id."', date_parution ='".$date."', type_serie = '1'";
                                        pmb_mysql_query($requete);
                                    }
                                }
                            }
                        }
                    }
                    // Calcul de la date suivante  analyser et la sortie du while
                    if($unite==0) $sql_add="INTERVAL ".$duree." DAY";
                    if($unite==1) $sql_add="INTERVAL ".$duree." MONTH";
                    if($unite==2) $sql_add="INTERVAL ".$duree." YEAR";
                    $date=pmb_sql_value("SELECT DATE_ADD('$date', $sql_add)");
                    $diff=pmb_sql_value("SELECT DATEDIFF('$date_fin','$date')");
                }
                while(($diff>=0) && ($duree != 0));
            }
        }
    }
    
    public function update() {
        global $msg;
        global $include_path;
        global $act;
        
        if(!$this->modele_name)	return false;
        
        // nettoyage des valeurs en entre
        $this->modele_name = clean_string($this->modele_name);
        
        // construction de la requte
        $requete = "SET modele_name='".addslashes($this->modele_name)."', ";
        $requete .= "num_notice='$this->num_notice', ";
        $requete .= "num_periodicite='$this->num_periodicite', ";
        $requete .= "duree_abonnement='$this->duree_abonnement', ";
        $requete .= "date_debut='$this->date_debut', ";
        $requete .= "date_fin='$this->date_fin', ";
        $requete .= "days='$this->days', ";
        $requete .= "day_month='$this->day_month', ";
        $requete .= "week_month='$this->week_month', ";
        $requete .= "week_year='$this->week_year', ";
        $requete .= "month_year='$this->month_year', ";
        
        $requete .= "num_cycle='$this->num_cycle', ";
        $requete .= "num_increment='$this->num_increment', ";
        $requete .= "num_combien='$this->num_combien', ";
        $requete .= "num_date_unite='$this->num_date_unite', ";
        $requete .= "num_increment_date='$this->num_increment_date', ";
        $requete .= "num_increment_day_of_month='$this->num_increment_day_of_month', ";
        $requete .= "num_increment_month_of_year='$this->num_increment_month_of_year', ";
        $requete .= "num_depart='$this->num_depart', ";
        $requete .= "vol_actif='$this->vol_actif', ";
        $requete .= "vol_increment='$this->vol_increment', ";
        $requete .= "vol_date_unite='$this->vol_date_unite', ";
        $requete .= "vol_increment_numero='$this->vol_increment_numero', ";
        $requete .= "vol_increment_date='$this->vol_increment_date', ";
        $requete .= "vol_increment_day_of_month='$this->vol_increment_day_of_month', ";
        $requete .= "vol_increment_month_of_year='$this->vol_increment_month_of_year', ";
        $requete .= "vol_cycle='$this->vol_cycle', ";
        $requete .= "vol_combien='$this->vol_combien', ";
        $requete .= "vol_depart='$this->vol_depart', ";
        $requete .= "tom_actif='$this->tom_actif', ";
        $requete .= "tom_increment='$this->tom_increment', ";
        $requete .= "tom_date_unite='$this->tom_date_unite', ";
        $requete .= "tom_increment_numero='$this->tom_increment_numero', ";
        $requete .= "tom_increment_date='$this->tom_increment_date', ";
        $requete .= "tom_increment_day_of_month='$this->tom_increment_day_of_month', ";
        $requete .= "tom_increment_month_of_year='$this->tom_increment_month_of_year', ";
        $requete .= "tom_cycle='$this->tom_cycle', ";
        $requete .= "tom_combien='$this->tom_combien', ";
        $requete .= "tom_depart='$this->tom_depart', ";
        $requete .= "format_aff='".addslashes($this->format_aff)."', ";
        $requete .= "format_periode='".addslashes($this->format_periode)."' ";
        
        if($this->modele_id) {
            // update: s'assurer que le nom de modle n'existe pas dj
            $dummy = "SELECT * FROM abts_modeles WHERE modele_name='".addslashes($this->modele_name)."' and num_notice='".$this->num_notice."' and modele_id!='".$this->modele_id."' ";
            $check = pmb_mysql_query($dummy);
            if(pmb_mysql_num_rows($check)) {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_modele"], $msg["abonnements_erreur_creation_doublon_modele"]." ($this->modele_name).");
                return FALSE;
            }
            $requete = 'UPDATE abts_modeles '.$requete;
            $requete .= ' WHERE modele_id='.$this->modele_id.' LIMIT 1;';
            if(pmb_mysql_query($requete)) {
                
                if($act=="gen") $this->gen_date();
                return TRUE;
            }else {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_modele"], $msg["abonnements_titre_creation_edition_modele_impossible"]);
                return FALSE;
            }
        } else {
            
            // s'assurer que le modle n'existe pas dj
            $dummy = "SELECT * FROM abts_modeles WHERE modele_name='".addslashes($this->modele_name)."' and num_notice='".$this->num_notice."'";
            $check = pmb_mysql_query($dummy);
            if(pmb_mysql_num_rows($check)) {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_modele"], $msg["abonnements_erreur_creation_doublon_modele"]." ($this->modele_name).");
                return FALSE;
            }
            $requete = 'INSERT INTO abts_modeles '.$requete.';';
            
            if(pmb_mysql_query($requete)) {
                $this->modele_id=pmb_mysql_insert_id();
                
                if($act=="gen") $this->gen_date();
                return TRUE;
            } else {
                require_once("$include_path/user_error.inc.php");
                warning($msg["abonnements_titre_creation_edition_modele"], $msg["abonnements_titre_creation_edition_modele_impossible"]);
                return FALSE;
            }
        }
    }
    
    public function delete() {
        //Je supprime les abonnements lis au modle
        $requete="SELECT abt_id FROM abts_abts_modeles WHERE modele_id='".$this->modele_id."'";
        $res=pmb_mysql_query($requete);
        if(pmb_mysql_num_rows($res)){
            while ($ligne=pmb_mysql_fetch_object($res)) {
                $mon_abt= new abts_abonnement($ligne->abt_id);
                $mon_abt->delete();
            }
        }
        
        $dummy = "delete FROM abts_modeles WHERE modele_id='".$this->modele_id."' ";
        pmb_mysql_query($dummy);
        
        $dummy = "delete FROM abts_grille_modele WHERE num_modele='".$this->modele_id."' ";
        pmb_mysql_query($dummy);
    }
    
    public function set_properties_from_form() {
        global $modele_name, $num_notice, $num_periodicite, $duree_abonnement, $date_debut, $date_fin;
        global $days, $day_month, $week_month, $week_year, $month_year;
        global $num_cycle, $num_combien, $num_depart;
        global $vol_actif,$vol_increment,$vol_date_unite,$vol_increment_numero, $vol_increment_date,$vol_cycle,$vol_combien,$vol_depart;
        global $tom_actif,$tom_increment,$tom_date_unite,$tom_increment_numero, $tom_increment_date,$tom_cycle,$tom_combien,$tom_depart;
        global $format_aff, $format_periode;
        global $vol_increment_day_of_month, $vol_increment_month_of_year;
        global $tom_increment_day_of_month, $tom_increment_month_of_year;
        
        $this->modele_name= stripslashes($modele_name);
        $this->num_notice= $num_notice;
        $this->num_periodicite= $num_periodicite;
        $this->duree_abonnement= $duree_abonnement;
        $this->date_debut=$date_debut;
        $this->date_fin= $date_fin;
        $this->days=$this->calc_selection($days,7);
        $this->day_month=$this->calc_selection($day_month,31);
        $this->week_month=$this->calc_selection($week_month,6);
        $this->week_year= $this->calc_selection($week_year,54);
        $this->month_year=$this->calc_selection($month_year,12);
        $this->num_cycle = 1-$this->calc_selection($num_cycle,1);
        $this->num_combien = $num_combien;
        $this->num_depart = $num_depart;
        $this->vol_actif = 1-$this->calc_selection($vol_actif,1);
        $this->vol_increment = $vol_increment;
        $this->vol_date_unite = $vol_date_unite;
        $this->vol_increment_numero = $vol_increment_numero;
        $this->vol_increment_date = $vol_increment_date;
        $this->vol_increment_day_of_month = $vol_increment_day_of_month;
        $this->vol_increment_month_of_year = $vol_increment_month_of_year;
        $this->vol_cycle = 1-$this->calc_selection($vol_cycle,1);
        $this->vol_combien = $vol_combien;
        $this->vol_depart = $vol_depart;
        $this->tom_actif = 1-$this->calc_selection($tom_actif,1);
        $this->tom_increment = $tom_increment;
        $this->tom_date_unite = $tom_date_unite;
        $this->tom_increment_numero = $tom_increment_numero;
        $this->tom_increment_date = $tom_increment_date;
        $this->tom_increment_day_of_month = $tom_increment_day_of_month;
        $this->tom_increment_month_of_year = $tom_increment_month_of_year;
        $this->tom_cycle = 1-$this->calc_selection($tom_cycle,1);
        $this->tom_combien = $tom_combien;
        $this->tom_depart = $tom_depart;
        $this->format_aff = stripslashes($format_aff);
        $this->format_periode = stripslashes($format_periode);
    }
    
    public function proceed() {
        global $include_path,$charset, $current_module;
        global $act;
        global $serial_id,$msg,$date_parution;
        global $new_serial_id,$num_increment,$num_date_unite,$num_increment_date;
        global $num_increment_day_of_month, $num_increment_month_of_year;
        global $include_path;
        
        switch ($act) {
            case 'update':
                // mise  jour modle
                $this->set_properties_from_form();
                $this->num_increment=$num_increment;
                $this->num_date_unite=$num_date_unite;
                $this->num_increment_date=$num_increment_date;
                $this->num_increment_day_of_month=$num_increment_day_of_month;
                $this->num_increment_month_of_year=$num_increment_month_of_year;
                $this->update();
                print $this->show_form();
                break;
            case 'gen':
                // mise  jour modle
                $this->set_properties_from_form();
                $this->update();
                print $this->show_form();
                break;
            case 'copy':
                // mise  jour modle
                $requete = "select type_serie, numero,date_parution,type_serie,nombre_recu from abts_grille_modele where num_modele='".$this->modele_id."'";
                $resultat=pmb_mysql_query($requete);
                
                //Cration du nouveau modle
                $this->modele_id='';
                $this->num_notice=$new_serial_id;
                $this->modele_name= clean_string($this->modele_name);
                $serial_id=$new_serial_id;
                $this->update();
                $requete = "delete FROM abts_grille_modele WHERE num_modele='".$this->modele_id."'";
                pmb_mysql_query($requete);
                //recopie des infos du calendrier
                if(pmb_mysql_num_rows($resultat)) {
                    while(($r=pmb_mysql_fetch_object($resultat))){
                        $date_parution=$r->date_parution;
                        $type_serie=$r->type_serie;
                        $nombre_recu=$r->nombre_recu;
                        $numero=$r->numero;
                        
                        $requete = "INSERT INTO abts_grille_modele SET num_modele='".$this->modele_id."', date_parution ='".$date_parution."', type_serie = '".$type_serie."', nombre_recu= '".$nombre_recu."'";
                        pmb_mysql_query($requete);
                    }
                }
                print $this->show_form();
                break;
            case 'del':
                // Verif si abonnements associs
                $requete="select abt_name,abts_abts.abt_id as ab_id from abts_abts_modeles,abts_abts where modele_id='".$this->modele_id."' and abts_abts.abt_id=abts_abts_modeles.abt_id";
                $resultat=pmb_mysql_query($requete);
                if (pmb_mysql_num_rows($resultat)) {
                    while(($r=pmb_mysql_fetch_object($resultat))) {
                        $liste.="<a href=\"catalog.php?categ=serials&sub=abon&serial_id=".$this->num_notice."&abt_id=".$r->ab_id."\">".$r->abt_name."</a><br />";
                    }
                    require_once("$include_path/user_error.inc.php");
                    warning(htmlentities($msg["abonnements_titre_effacement_modele"],ENT_QUOTES,$charset), htmlentities($msg["abonnements_effacement_modele_erreur"],ENT_QUOTES,$charset)."<br /><strong>".$liste."</strong>");
                    print $this->show_form();
                    return;
                }
                $this->delete();
                print "<div class='row'><div class='msg-perio'>".$msg['maj_encours']."</div></div>";
                $id_form = md5(microtime());
                $retour = "./catalog.php?categ=serials&sub=view&serial_id=".$serial_id."&view=modele";
                print "<form class='form-".$current_module."' name=\"dummy\" method=\"post\" action=\"".$retour."\" style=\"display:none\">
					<input type=\"hidden\" name=\"id_form\" value=\"".$id_form."\">
					</form>
					<script type=\"text/javascript\">document.dummy.submit();</script>
					</div>";
                break;
            default:
                print $this->show_form();
                break;
        }
    }
    
    public function calc_selection($val,$size){
        $ret='';
        for ($i=0; $i<$size; $i++) {
            if(!isset($val[$i+1])) $ret .='1'; else $ret .='0';
        }
        return $ret;
    }
}