<?xml version="1.0" encoding="iso-8859-1"?>
<!--
****************************************************************************************
 2002-2007 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
****************************************************************************************
$Id: pmbxml2ris_zotero.xsl,v 1.7.2.1 2024/08/28 14:10:15 rtigero Exp $ -->

<xsl:stylesheet version = '1.0'
     xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>
<!-- http://en.wikipedia.org/wiki/RIS_(file_format)#Type_of_reference -->

<xsl:output method="text" encoding="utf-8"/>

<xsl:template match="/">
		<xsl:apply-templates select="descendant::notice"/>
</xsl:template>

<xsl:template match="notice">
	<xsl:call-template name="subtype"/>
	<xsl:call-template name="titre"/>
	<xsl:call-template name="perio_titre"/>
	<xsl:call-template name="bulletin_vol"/>
	<xsl:call-template name="bulletin_num"/>
	<xsl:call-template name="pagination"/>
	<xsl:call-template name="langues"/>
	<xsl:call-template name="date"/>
	<xsl:call-template name="perio_issn"/>
	<xsl:call-template name="auteur"/>
	<xsl:call-template name="resume"/>
	<xsl:call-template name="editeur"/>
	<xsl:call-template name="keywords"/>
	<xsl:call-template name="doi"/>
	<xsl:call-template name="pubmedid"/>
	<xsl:call-template name="notes"/>
	<xsl:call-template name="associated_url"/>
	<xsl:call-template name="permalink"/>
	<xsl:call-template name="docnum_urls"/>
	<xsl:text>ER - &#010;</xsl:text>
	<xsl:text>&#010;</xsl:text>
</xsl:template>

<xsl:template name="code_langue">
	<xsl:param name="entree"/>
	<xsl:variable name="noeudSubst" select="document('../../includes/marc_tables/fr_FR/lang_subst.xml')"/>
	<xsl:variable name="noeud" select="document('../../includes/marc_tables/fr_FR/lang.xml')"/>
	<xsl:choose>
		<xsl:when test="$noeudSubst/XMLlist/entry[@code=$entree]">
			<xsl:value-of select="$noeudSubst/XMLlist/entry[@code=$entree]" />
		</xsl:when>
		<xsl:when test="$noeud/XMLlist/entry[@code=$entree]">
			<xsl:value-of select="$noeud/XMLlist/entry[@code=$entree]" />
		</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template name="titre">
		<xsl:if test="f[@c='200']/s[@c='a']">
			<xsl:text>TI  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='200']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="auteur">
		<xsl:if test="f[@c='700']/s[@c='a']">
			<xsl:choose>
				<xsl:when test=" f[@c='700']/s[@c='b']">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(f[@c='700']/s[@c='a']),', ',normalize-space(f[@c='700']/s[@c='b']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="normalize-space(f[@c='700']/s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:for-each select="f[@c='701']">
			<xsl:choose>
				<xsl:when test=" s[@c='b']">
					<xsl:text>AU  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='b']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>AU  - </xsl:text>
					<xsl:value-of select="normalize-space(s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:for-each select="f[@c='702']">
			<xsl:choose>
				<xsl:when test=" s[@c='b']">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='b']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="normalize-space(s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:if test="f[@c='710']/s[@c='a']">
			<xsl:choose>
				<xsl:when test=" ((f[@c='710']/s[@c='K']!='') and (f[@c='710']/s[@c='M']!='')) ">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(f[@c='710']/s[@c='a']),', ',normalize-space(f[@c='710']/s[@c='K']),', ',normalize-space(f[@c='710']/s[@c='M']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:when test="((s[@c='K']!='') and (s[@c='M']=''))">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(f[@c='710']/s[@c='a']),', ',normalize-space(f[@c='710']/s[@c='K']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="normalize-space(f[@c='710']/s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
		<xsl:for-each select="f[@c='711']">
			<xsl:choose>
				<xsl:when test=" ((s[@c='K']!='') and (s[@c='M']!='')) ">
					<xsl:text>AU  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='K']),', ',normalize-space(s[@c='M']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:when test=" ((s[@c='K']!='') and (s[@c='M']='')) ">
					<xsl:text>AU  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='K']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>AU  - </xsl:text>
					<xsl:value-of select="normalize-space(s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
		<xsl:for-each select="f[@c='712']">
			<xsl:choose>
				<xsl:when test=" ((s[@c='K']!='') and (s[@c='M']!='')) ">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='K']),', ',normalize-space(s[@c='M']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:when test=" ((s[@c='K']!='') and (s[@c='M']='')) ">
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="concat(normalize-space(s[@c='a']),', ',normalize-space(s[@c='K']))"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>A1  - </xsl:text>
					<xsl:value-of select="normalize-space(s[@c='a'])"/>
					<xsl:text>&#010;</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
</xsl:template>
<xsl:template name="editeur">
		<xsl:if test="f[@c='210']/s[@c='c']">
			<xsl:text>PB  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='210']/s[@c='c'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="date">
		<xsl:if test="f[@c='210']/s[@c='d']">
			<xsl:text>PY  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='210']/s[@c='d'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
		<xsl:if test="f[@c='463']/s[@c='d']">
			<xsl:text>DA  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='463']/s[@c='d'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="resume">
		<xsl:if test="f[@c='330']/s[@c='a']">
			<xsl:text>AB  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='330']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="pubmedid">
		<xsl:if test="f[@c='900']/s[@c='n'] = 'pmi_xref_dbase_id'">
			<xsl:text>N1  - PubMed ID: </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='900'][s[@c='n'] = 'pmi_xref_dbase_id']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="doi">
		<xsl:if test="f[@c='900']/s[@c='n'] = 'pmi_doi_identifier'">
			<xsl:text>N1  - doi: </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='900'][s[@c='n'] = 'pmi_doi_identifier']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="subtype">
	<xsl:choose>
		<xsl:when test="f[@c='900']/s[@c='n'] = 'subtype'">
			<xsl:text>TY  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='900'][s[@c='n'] = 'subtype']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="bl = 'a' and hl = '2'">
			<xsl:text>TY  - JOUR&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="bl = 's' and hl = '2'">
			<xsl:text>TY  - JOUR&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="bl = 's' and hl = '1'">
			<xsl:text>TY  - NEWS&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'b'">
			<xsl:text>TY  - MANSCPT&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'c' or dt = 'd'">
			<xsl:text>TY  - MUSIC&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'e' or dt = 'f'">
			<xsl:text>TY  - MAP&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'g' or dt = 'k'">
			<xsl:text>TY  - VIDEO&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'i' or dt = 'j'">
			<xsl:text>TY  - SOUND&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'l'">
			<xsl:text>TY  - ICOMM&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'm'">
			<xsl:text>TY  - COMP&#010;</xsl:text>
		</xsl:when>
		<xsl:when test="dt = 'r'">
			<xsl:text>TY  - FIGURE&#010;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>TY  - BOOK&#010;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="pagination">
	<xsl:if test="f[@c='215']/s[@c='a']">
	<xsl:choose>
		<xsl:when test="substring-after(normalize-space(f[@c='215']/s[@c='a']),'-')">
			<xsl:text>SP  - </xsl:text>
			<xsl:value-of select="substring-before(normalize-space(f[@c='215']/s[@c='a']),'-')"/>
			<xsl:text>&#010;</xsl:text>
			<xsl:text>EP  - </xsl:text>
			<xsl:value-of select="substring-after(normalize-space(f[@c='215']/s[@c='a']),'-')"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>SP  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='215']/s[@c='a'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:if>
</xsl:template>
<xsl:template name="langues">
	<xsl:if test="f[@c='101']/s[@c='a']">
		<xsl:text>LA  - </xsl:text>
			<xsl:call-template name="code_langue">
				<xsl:with-param name="entree" select="normalize-space(f[@c='101']/s[@c='a'])"/>
			</xsl:call-template>
		<xsl:text>&#010;</xsl:text>
	</xsl:if>
</xsl:template>
<xsl:template name="bulletin_vol">
		<xsl:choose>
			<xsl:when test="substring-before(normalize-space(f[@c='463']/s[@c='v']),', ')">
				<xsl:text>VL  - </xsl:text>
				<xsl:value-of select="substring-after(substring-before(normalize-space(f[@c='463']/s[@c='v']),', '),'vol. ')"/>
				<xsl:text>&#010;</xsl:text>
			</xsl:when>
			<xsl:when test="substring-after(normalize-space(f[@c='463']/s[@c='v']),'vol. ')">
				<xsl:text>VL  - </xsl:text>
				<xsl:value-of select="substring-after(normalize-space(f[@c='463']/s[@c='v']),'vol. ')"/>
				<xsl:text>&#010;</xsl:text>
			</xsl:when>
		</xsl:choose>
</xsl:template>
<xsl:template name="bulletin_num">
		<xsl:choose>
			<xsl:when test="substring-after(normalize-space(f[@c='463']/s[@c='v']),'no. ')">
				<xsl:text>IS  - </xsl:text>
				<xsl:value-of select="substring-after(normalize-space(f[@c='463']/s[@c='v']),'no. ')"/>
				<xsl:text>&#010;</xsl:text>
			</xsl:when>
			<xsl:when test="substring-after(normalize-space(f[@c='463']/s[@c='v']),'n ')">
				<xsl:text>IS  - </xsl:text>
				<xsl:value-of select="substring-after(normalize-space(f[@c='463']/s[@c='v']),'n ')"/>
				<xsl:text>&#010;</xsl:text>
			</xsl:when>
			<xsl:when test="normalize-space(f[@c='463']/s[@c='v'])">
				<xsl:text>IS  - </xsl:text>
				<xsl:value-of select="normalize-space(f[@c='463']/s[@c='v'])"/>
				<xsl:text>&#010;</xsl:text>
			</xsl:when>
		</xsl:choose>
</xsl:template>
<xsl:template name="perio_titre">
		<xsl:if test="f[@c='461']/s[@c='t']">
			<xsl:text>JF  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='461']/s[@c='t'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="perio_issn">
		<xsl:if test="f[@c='461']/s[@c='x']">
			<xsl:text>SN  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='461']/s[@c='x'])"/>
			<xsl:text> (ISSN)</xsl:text>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="keywords">
	<xsl:for-each select="f[@c='606']/s[@c='a']">
		<xsl:if test="contains(../s[@c='9'][2],'fr_FR')">
			<xsl:text>KW  - </xsl:text>
			<xsl:value-of select="normalize-space(.)"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
	</xsl:for-each>
	<xsl:for-each select="f[@c='610']/s[@c='a']">
		<xsl:call-template name="explose_kw">
			<xsl:with-param name="motcle" select="normalize-space(.)"/>
		</xsl:call-template>
	</xsl:for-each>
</xsl:template>
<xsl:template name="explose_kw">
	<xsl:param name="motcle"/>
	<xsl:choose>
		<xsl:when test="substring-after($motcle,' ; ')">
			<xsl:text>KW  - </xsl:text>
			<xsl:value-of select="substring-before($motcle,' ; ')"/>
			<xsl:text>&#010;</xsl:text>
			<xsl:call-template name="explose_kw">
					<xsl:with-param name="motcle" select="substring-after($motcle,' ; ')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>KW  - </xsl:text>
			<xsl:value-of select="$motcle"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="notes">
		<xsl:for-each select="f[@c='300']/s[@c='a']">
			<xsl:call-template name="explose_note">
				<xsl:with-param name="contenu" select="."/>
			</xsl:call-template>
		</xsl:for-each>
</xsl:template>
<xsl:template name="explose_note">
	<xsl:param name="contenu"/>
	<xsl:choose>
		<xsl:when test="substring-after($contenu,'&#010;')">
			<xsl:text>N1  - </xsl:text>
			<xsl:value-of select="substring-before($contenu,'&#010;')"/>
			<xsl:text>&#010;</xsl:text>
			<xsl:call-template name="explose_note">
					<xsl:with-param name="contenu" select="substring-after($contenu,'&#010;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>N1  - </xsl:text>
			<xsl:value-of select="$contenu"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template name="associated_url">
		<xsl:if test="f[@c='856']/s[@c='u']">
			<xsl:text>UR  - </xsl:text>
			<xsl:value-of select="normalize-space(f[@c='856']/s[@c='u'])"/>
			<xsl:text>&#010;</xsl:text>
		</xsl:if>
</xsl:template>
<xsl:template name="permalink">
		<xsl:for-each select="f[@c='001']">
			<xsl:text>UR  - </xsl:text>
			<xsl:value-of select="$opac_url_base"/>
			<xsl:text>index.php?lvl=notice_display&amp;id=</xsl:text>
			<xsl:value-of select='.'/>
			<xsl:text>&#010;</xsl:text>
		</xsl:for-each>
</xsl:template>
<xsl:template name="docnum_urls">
		<xsl:for-each select="f[@c='897']/s[@c='a']">
			<xsl:text>L3  - </xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>&#010;</xsl:text>
		</xsl:for-each>
</xsl:template>
</xsl:stylesheet>