<?php

// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: AISettingsOrm.php,v 1.9 2024/03/12 14:06:22 qvarin Exp $

namespace Pmb\AI\Orm;

use encoding_normalize;
use Pmb\Common\Orm\Orm;

class AISettingsOrm extends Orm
{
    /**
     * Table name
     *
     * @var string
     */
    public static $tableName = "ai_settings";

    /**
     * Primary Key
     *
     * @var string
     */
    public static $idTableName = "id_ai_setting";

    /**
     *
     * @var integer
     */
    public $id_ai_setting = 0;

    /**
     *
     * @var string|object
     */
    public $settings_ai_settings = "";

    /**
     *
     * @var integer
     */
    public $active_ai_settings = 0;


    /**
     * La fonction  getAiSettings  rcupre les paramtres de l'IA, les traite et les renvoie dans un
     * tableau.
     *
     * @return array tableau d'objets de paramtres IA avec des proprits supplmentaires telles que
     * `settings_ai_settings`, `active_ai_settings` et `caddie_name`. La proprit
     * `settings_ai_settings` est dcode  partir du format JSON, la proprit `active_ai_settings`
     * est dfinie directement et la proprit `caddie_name` est rcupre  l'aide d'une fonction
     * d'assistance `caddie::get_data_from_id()` base sur
     */

    public function getAiSettings()
    {
        $return = [];
        $settings = $this->findAll();

        foreach($settings as $setting) {
            $setting->settings_ai_settings = json_decode($setting->settings_ai_settings);
            $setting->active_ai_settings = $setting->active_ai_settings;
            // Petit hack pour rcupere le nom du caddie... Car dans la pratique on ne le sauvegarde pas
            $setting->settings_ai_settings->caddie_name = \caddie::get_data_from_id($setting->settings_ai_settings->caddie_id)["name"];
            $setting->unsetStructure();
            $return[] = $setting;
        }
        return $return;
    }


    /**
     * La fonction  getAiSettingsById  rcupre les paramtres AI par leur ID, convertit les
     * paramtres JSON en objet, supprime la structure et renvoie les paramtres.
     *
     * @param id Le paramtre "id" est l'identifiant des paramtres AI que vous souhaitez rcuprer. Il
     * est utilis pour rechercher les paramtres AI dans la base de donnes.
     *
     * @return array tableau d?objets de paramtres AI.
     */
    public function getAiSettingsById($id)
    {
        $return = [];
        $settings = $this->findById($id);

        foreach($settings as $setting) {
            $setting->settings_ai_settings = json_decode($setting->settings_ai_settings);
            $setting->unsetStructure();
            $return[] = $setting;
        }
        return $return;
    }


    /**
     * La fonction  getAiSettingsFindAll  rcupre tous les paramtres AI, convertit la chane JSON
     * en objet, supprime la proprit de structure et renvoie les paramtres modifis.
     *
     * @return array tableau d?objets de paramtres IA.
     */
    public static function getAiSettingsFindAll()
    {
        $return = [];
        $settings = self::findAll();

        foreach($settings as $setting) {
            $setting->settings_ai_settings = json_decode($setting->settings_ai_settings);
            $setting->unsetStructure();
            $return[] = $setting;
        }
        return $return;
    }

    /**
     * La fonction  getAiSettingActive  renvoie l'objet des paramtres AI actuels.
     *
     * @return AiSettingsOrm|null
     */
    public static function getAiSettingActive()
    {
        $setting = self::find("active_ai_settings", "1");
        if (!empty($setting)) {
            $setting[0]->settings_ai_settings = json_decode($setting[0]->settings_ai_settings);
            $setting[0]->unsetStructure();
            return $setting[0];
        }
        return null;
    }


    /**
     * La fonction `formatSettingsAiSettings()` est une mthode au sein de la classe `AISettingsOrm`.
     * Cette fonction est responsable du formatage de la proprit `settings_ai_settings` d'un objet.
     *
     * @return \stdClass
     */
    public function formatSettingsAiSettings()
    {
        $settings_ai_settings = is_string($this->settings_ai_settings) ? encoding_normalize::json_decode($this->settings_ai_settings) : $this->settings_ai_settings;
        if (!is_object($settings_ai_settings)) {
            $settings_ai_settings = new \stdClass();
        }
        return $settings_ai_settings;
    }

}
