<?php

// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: SemanticSearchController.php,v 1.6.2.3 2024/09/24 08:19:59 gneveu Exp $

namespace Pmb\AI\Controller;

use Pmb\AI\Models\AiModel;
use Pmb\AI\Models\SemanticSearchModel;
use Pmb\AI\Orm\AISettingsOrm;
use Pmb\AI\Views\SemanticSearchView;

use Pmb\Common\Controller\Controller;
use Pmb\Common\Orm\SearchPersoOrm;

if (stristr($_SERVER['REQUEST_URI'], basename(__FILE__))) {
    die("no access");
}

class SemanticSearchController extends Controller
{
    /* La ligne `public  = "list";` dclare une proprit publique appele `` et lui
    attribue la valeur "list". Cette proprit est utilise pour dterminer l'action par dfaut 
    effectuer par la mthode `proceed()` si aucun paramtre d'action n'est fourni. Dans ce cas,
    l'action par dfaut est dfinie sur "liste". */
    public $action = "list";


    /**
     * La fonction "proceed" dtermine l'action  entreprendre en fonction du paramtre fourni et
     * excute la mthode correspondante.
     *
     * @param action Le paramtre action est utilis pour dterminer l'action spcifique qui doit
     * tre effectue. Il peut avoir trois valeurs possibles :  modifier ,  ajouter  ou 
     * enregistrer .
     */

    public function proceed($action = "")
    {
        $this->action = $action;

        switch ($action) {
            case 'edit':
            case 'add':
                $this->getFormAction();
                break;
            case 'save':
                $this->saveAction();
                break;
            case 'delete':
                $this->deleteAction();
                break;
            case 'active_semantic_search':
                $this->activeSemanticSearchAction();
                break;
            default:
                $this->listAction();
        }
    }


    /**
     * La fonction setData dfinit la valeur de la proprit data dans une classe PHP.
     *
     * @param data Le paramtre "data" est une variable qui reprsente les donnes que vous souhaitez
     * dfinir pour l'objet. Il peut s'agir de n'importe quel type de donnes, tel qu'une chane, un
     * entier, un tableau ou un objet.
     */

    public function setData($data)
    {
        $this->data = $data;
    }

    /**
     * La fonction  listAction  cre une nouvelle instance de la classe  SemanticSearchView , en
     * transmettant certaines donnes, puis restitue et imprime la vue.
     */

    public function listAction()
    {
        $semanticSearchView = new SemanticSearchView("AI/semanticSearch", [
            "action" => $this->action,
            "semanticsearchlist" => SemanticSearchModel::getSemanticSearchList(),
        ]);
        print $semanticSearchView->render();
    }

    /**
     * La fonction `getFormAction` rcupre l'action du formulaire pour la recherche smantique et
     * restitue la vue correspondante.
     */

    public function getFormAction()
    {
        global $pmb_url_base;

        $semanticSearch = [];
        if (isset($this->data) && is_int($this->data) && AISettingsOrm::exist($this->data)) {
            $aISettingsOrm = new AISettingsOrm($this->data);
            $aISettingsOrm->unsetStructure();
            $semanticSearch = $aISettingsOrm;
        }

        $semanticSearchView = new SemanticSearchView("AI/semanticSearch", [
            "action" => $this->action,
            "semanticsearch" => $semanticSearch,
            "caddieslist" => \caddie_root::get_caddies(["idcaddie", "name"]),
            "url_webservice" => $pmb_url_base . "rest.php/Ai/"
        ]);
        print $semanticSearchView->render();
    }

    /* La fonction `saveAction()` est responsable de la sauvegarde des donnes reues lors de la
    soumission du formulaire. */

    public function saveAction()
    {
        try {
            if (isset($this->data->id) && !empty($this->data->id)) {
                $aiSettingsOrm = new AISettingsOrm($this->data->id);
            } else {
                $aiSettingsOrm = new AISettingsOrm();
            }

            $aiSettingsOrm->settings_ai_settings = json_encode($this->data->settings);
            $aiSettingsOrm->save();

            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    /* La fonction `deleteAction()` est responsable de la suppression d'un enregistrement de la base de
    donnes. Il cre une instance de la classe `AISettingsOrm` avec l'ID de l'enregistrement 
    supprimer, puis appelle la mthode `delete()` sur cette instance pour supprimer
    l'enregistrement. Si la suppression russit, elle renvoie true. Si une exception se produit
    pendant le processus de suppression, il intercepte l'exception et renvoie le message d'erreur. */

    public function deleteAction()
    {
        $Id = intval($this->data);
        if (!AISettingsOrm::exist($id)) {
            http_response_code(404);
            return "Suppression Impossible";
        }

        try {
            $aISettingsOrm = new AISettingsOrm($id);
            $aISettingsOrm->delete();
            return true;
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    /* La fonction `activeSemanticSearchAction()` est une mthode de la classe
    `SemanticSearchController`. Il se charge d'activer une recherche smantique en appelant la
    mthode `setActiveSemanticSearch()` depuis la classe `AiModel`. */

    public function activeSemanticSearchAction()
    {
        if (!isset($this->data) || !AISettingsOrm::exist(intval($this->data))) {
            http_response_code(404);
            return $this->listAction();
        }
        try {
            AiModel::setActiveSemanticSearch(intval($this->data));
            $this->listAction();
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }
}
