// +-------------------------------------------------+
// © 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: actionContainer.js,v 1.12 2018/10/19 13:49:59 vtouchard Exp $

define(['dojo/_base/declare', 'dijit/layout/ContentPane', 'dojo/topic', 'dojo/_base/lang', 'dijit/registry'], function(declare, contentPane, topic, lang, registry) {
    return declare(contentPane, {
        postCreate : function() {
            /** Abonnement aux évenements provenants des classes "helloWidget", et "actionZone" **/
            this.own(
        		topic.subscribe('HomePageCode', lang.hitch(this, this.handleEvents)), 
        		topic.subscribe('HomePageGallery', lang.hitch(this, this.handleEvents)),
        		topic.subscribe('actionZone', lang.hitch(this, this.handleEvents))
            );
        },

        handleEvents : function(evtType, evtArgs) {
            //console.debug('evt received in actionContainer', evtType, evtArgs);
            switch(evtType) {
            /** homepageHidden: evenement envoyé par la classe helloWidget lorsqu'elle reçoit l'evenement "infoLoaded de la classe "infoReader" **/
            case 'homepageHidden':
                this.show();
                break;
            /** erase: evenement envoyé par la classe actionZone lorsqu'un appui sur le bouton retour à la page d'accueil est effectué **/
            case 'erase':
                this.hide();
                break;
            }
        },
        /**
         * Les fonction show() & hide() permettent de masquer/d'afficher la classe
         */
        show : function() {
            if (this.domNode.style.display == "none") {
                this.domNode.style.display = "block";
                registry.byId('mainContainer').resize();
            }
        },
        hide : function() {
            if (this.domNode.style.display != "none") {
                this.domNode.style.display = "none";
                registry.byId('mainContainer').resize();
            }
        }
    });
});
