// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HomePageGalleryKeyboard.js,v 1.1 2018/10/19 13:49:59 vtouchard Exp $

define([
	'dojo/_base/declare', 
	'dijit/_WidgetBase', 
	'dojo/topic', 
	'dojo/_base/lang', 
	'dijit/registry',
	'dojo/dom-construct',
	'dojo/dom-attr',
	'dojo/dom-style',
	'dojo/dom',
	'dojo/on'], function(declare, widget, topic, lang, registry, domConstruct, domAttr, domStyle, dom, on) {
    return declare([widget], {
        field: null,
        
    	buildRendering : function() {        	
        },
        postCreate : function() {
        	this.createKeyboard();
        	this.show();
        	this.own(topic.subscribe('keyboard', lang.hitch(this, this.handleEvents)));
        },
        handleEvents: function(evtType, evtArgs){
        	switch(evtType){
        		case 'cbReady':
        			this.hide();
        			break;
        	}
        },
        createKeyboard: function(){        	
        	var fieldContainer = domConstruct.create('div', {
        		id:'keyboard-field-container', 
        		'class':'keyboard-field-container',
        	}, this.domNode);

        	this.field = domConstruct.create('div', {
        		id:'keyboard-field', 
        		'class':'keyboard-field',
        		innerHTML: '&nbsp;'
        	}, fieldContainer);
        	
        	var returnButton = domConstruct.create('button', {
        		id:'keyboard-field-return', 
        		'class':'keyboard-field-return',
        		innerHTML: '<i class="fa fa-arrow-left" aria-hidden="true"></i>'
        	}, fieldContainer);
        	on(returnButton, 'click', lang.hitch(this, this.letterRemoved));
        	
        	
        	var keyboardLettersContainer = domConstruct.create('div', {
        		id:'keyboard-letters-container', 
        		'class':'keyboard-letters-container uk-grid', 
        		innerHTML: ''
        	}, this.domNode);
        	
        	for(var i=65 ; i<91 ; i++){
        		this.createLetter(String.fromCharCode(i), 'keyboard-letter', keyboardLettersContainer);
        	}
        	this.createLetter('&nbsp;', 'keyboard-letter keyboard-letter-space', keyboardLettersContainer);
        },
        show: function(){
//        	domStyle.set(this.domNode, 'height', '50%');
        	domStyle.set(this.domNode, 'display', 'block');
        },
        hide: function(){
//        	domStyle.set(this.domNode, 'height', '0px');
        	domStyle.set(this.domNode, 'display', 'none');
        },
        letterClicked: function(letter){
        	if(letter == '&nbsp;'){
        		letter = ' ';
        	}
        	this.field.innerHTML = this.field.innerHTML+letter; 
        	this.show();
        	topic.publish('HomePageGalleryKeyboard', 'letterClicked', {letter: letter, search: this.field.innerHTML});
        },
        letterRemoved: function(){
        	this.field.innerHTML = this.field.innerHTML.substr(0, this.field.innerHTML.length-1);
        	if(this.field.innerHTML.replace('&nbsp;', '') == ''){
//        		this.fullScreen();
//        		topic.publish('HomePageGalleryKeyboard', 'fullKeyboard');
        	}
        	topic.publish('HomePageGalleryKeyboard', 'letterRemoved', {search: this.field.innerHTML});
        },
        fullScreen: function(){
        	domStyle.set(this.domNode, 'height', '100%');
        	domStyle.set(this.domNode, 'display', 'block');
        },
        createLetter: function(letter, cssClass, container){
        	var letterNode = domConstruct.create('div', {
        		id:'keyboard-letter-'+letter, 
        		'class': cssClass+' uk-width-1-7',
        		'data-key': letter,
        		style: {
        			/*height: '50%',
        			top: '50%',*/	
        		},
        		innerHTML: '<p>'+letter+'</p>',
        	}, container);
    		on(letterNode, 'click', lang.hitch(this, this.letterClicked, letter));
        },
        clear: function(){
        	this.field.innerHTML = '';
        	this.hide();
        }
    });
});
