// +-------------------------------------------------+
// � 2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: HomePage.js,v 1.1 2018/10/19 13:49:59 vtouchard Exp $

/**
 * 
 * Widget lancé à l'affichage initial
 * C'est lui qui va, selon le paramétrage
 * instancier soit le trombinoscope, 
 * soit la page d'acceuil standard
 */


define([
	'dojo/_base/declare', 
	'dijit/_Widget', 
	'dojo/topic', 
	'dojo/_base/lang', 
	'dijit/registry',
	'app/HomePageCode',
	'app/HomePageGallery',
	'dijit/_Container'
	], function(declare, widget, topic, lang, registry, HomePageCode, HomePageGallery, container) {
    return declare([widget, container], {
        buildRendering : function() {
            this.inherited(arguments);
        },
        postCreate : function() {
        	if(parseInt(dojoConfig.bibloto.appParams.trombinoscope_enabled)){
        		this.addChild(new HomePageGallery());
        	}else{
        		this.addChild(new HomePageCode());
        	}
        	this.own(
    			topic.subscribe("HomePageCode", lang.hitch(this, this.handleEvents)), 
    			topic.subscribe("HomePageGallery", lang.hitch(this, this.handleEvents))
    		);
        },

        /**
         * Fonction handleEvents:
         * Prend en paramètres deux arguments
         * evtType -> Nom de l'event
         * evtArgs -> contenu de l'event
         */
        handleEvents : function(evtType, evtArgs) {
            // console.log('evt received in hellowidget', evtType, evtArgs);
            switch (evtType) {
            /** infosLoaded: Évenement envoyé par la classe infoReader lorsqu'elle a construit le template associé **/
	            case 'homepageHidden':
	                this.hide();
	                break;
	            case 'homepageDisplayed':
	            	this.show();
	            	break;
            }
        },
//        /** Affichage de la page d'accueil **/
        show : function() {
            dojoConfig.bibloto.appParams.rfid_lastVal = "";
            if (this.domNode.style.display == "none") {
                this.domNode.style.display = "block";
                this.domNode.style.height = "100%";
                registry.byId('mainContainer').resize();
            }
        },
//        /** Masquage de la page d'accueil **/
        hide : function() {
            dojoConfig.bibloto.appParams.rfid_lastVal = "";
            if (this.domNode.style.display != "none") {
                this.domNode.style.display = "none";
                this.domNode.style.height = "0px";
                registry.byId('mainContainer').resize();
            }
        }
    });
});
