<?php
// +-------------------------------------------------+
//  2002-2012 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: cms_module_common_selector_segments.class.php,v 1.1.4.2 2025/08/26 14:22:52 rtigero Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class cms_module_common_selector_segments extends cms_module_common_selector
{

	public function __construct($id = 0)
	{
		parent::__construct($id);
	}

	public function get_form()
	{
		$form = "
			<div class='row'>
				<div class='colonne3'>
					<label for=''>" . $this->format_text($this->msg['cms_module_common_selector_segments']) . "</label>
				</div>
				<div class='colonne-suite'>";
		$form .= $this->gen_select();
		$form .= "
				</div>
			</div>";
		$form .= parent::get_form();
		return $form;
	}

	public function save_form()
	{
		$this->parameters = $this->get_value_from_form("segment_id");
		return parent::save_form();
	}

	protected function gen_select()
	{
		if (!$this->id) {
			$this->parameters = array();
		}
		//TODO permettre d'autres types d'entits
		$query = "SELECT id_search_segment, search_segment_label, search_universe_label FROM search_segments
			JOIN search_universes ON search_segments.search_segment_num_universe = search_universes.id_search_universe
			WHERE search_segment_type = " . TYPE_NOTICE . "
			ORDER BY search_universes.search_universe_label, search_segment_label";
		$result = pmb_mysql_query($query);
		$current_universe = '';
		$select = "
					<select name='" . $this->get_form_value_name("segment_id") . "[]'>";
		if (pmb_mysql_num_rows($result)) {
			while ($row = pmb_mysql_fetch_object($result)) {
				if ($current_universe != $row->search_universe_label) {
					$current_universe = $row->search_universe_label;
					$select .= "</optgroup>";
					$select .= "<optgroup label='" . $row->search_universe_label . "'>";
				}
				$select .= "
						<option value='" . $row->id_search_segment . "' " . (in_array($row->id_search_segment, $this->parameters) ? "selected='selected'" : "") . ">" . $this->format_text($row->search_segment_label) . "</option>";
				if (empty($current_universe)) {
					$current_universe = $row->search_universe_label;
				}
			}
			$select .= "</optgroup>";
		} else {
			$select .= "
						<option value ='0'>" . $this->format_text($this->msg['cms_module_common_selector_segments_no_segment']) . "</option>";
		}
		$select .= "
			</select>";
		return $select;
	}

	public function get_value()
	{
		if (!$this->value) {
			$this->value = $this->parameters;
		}
		return $this->value;
	}
}
