<?php
// +-------------------------------------------------+
// | 2002-2011 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: list_abts_modeles_ui.class.php,v 1.1.4.3 2025/10/10 14:46:29 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".class.php")) die("no access");

class list_abts_modeles_ui extends list_abts_ui {
	
	protected function _get_query_base() {
		return 'SELECT modele_id FROM abts_modeles';
	}
	
	protected function get_object_instance($row) {
	    $abts_modele = new abts_modele($row->modele_id);
	    if (!$abts_modele->error) {
	        return $abts_modele;
	    }
	    return null;
	}
	
	/**
	 * Initialisation des filtres de recherche
	 */
	public function init_filters($filters=array()) {
	
		$this->filters = array(
			'serial_id' => 0
				
		);
		parent::init_filters($filters);
	}
	
	protected function init_default_applied_group() {
        $this->applied_group = array(0 => 'modele_name');
	}
	
	/**
	 * Initialisation des colonnes disponibles
	 */
	protected function init_available_columns() {
		$this->available_columns = 
		array('main_fields' =>
			array(
                    'modele_name' => 'abonnements_nom_modele',
					'periodicite' => 'abonnements_periodicite',
				    'duree_abonnement' => 'abonnements_duree_abonnement',
					'date_debut' => 'abonnements_date_debut',
					'date_fin' => 'abonnements_date_fin',
					'nombre_de_series' => 'abonnements_nombre_de_series',
					'nombre_de_horsseries' => 'abonnements_nombre_de_horsseries'
			)
		);
	}
	
	
	
	/**
	 * Initialisation du tri par dfaut appliqu
	 */
	protected function init_default_applied_sort() {
	    $this->add_applied_sort('modele_name');
	}
	
	protected function _cell_is_sortable($name) {
        return false;
	}
	
	/**
	 * Champ(s) du tri SQL
	 */
	protected function _get_query_field_order($sort_by) {
	    switch($sort_by) {
	        case 'modele_name':
	            return $sort_by;
	        default :
	            return parent::_get_query_field_order($sort_by);
	    }
	}
	
	protected function init_default_columns() {
		$this->add_column('periodicite');
		$this->add_column('duree_abonnement');
		$this->add_column('date_debut');
		$this->add_column('date_fin');
		$this->add_column('nombre_de_series');
		$this->add_column('nombre_de_horsseries');
	}

	protected function _get_object_property_modele_name($object) {
	    $href = "catalog.php?categ=serials&sub=modele&serial_id=".$object->num_notice."&modele_id=".$object->modele_id;
	    return "<a href='".$href."'>".$object->modele_name."</a>";
	}
	
	protected function _get_object_property_periodicite($object) {
	    return pmb_sql_value("SELECT libelle FROM abts_periodicites WHERE periodicite_id='".$object->num_periodicite."'") ?? '';
	}
	
	protected function _get_object_property_nombre_de_series($object) {
	    return pmb_sql_value("SELECT SUM(nombre_recu) FROM abts_grille_modele WHERE num_modele='".$object->modele_id."' AND type_serie ='1'") ?? 0;
	}
	
	protected function _get_object_property_nombre_de_horsseries($object) {
	    return pmb_sql_value("SELECT SUM(nombre_recu) FROM abts_grille_modele WHERE num_modele='".$object->modele_id."' AND type_serie ='2'") ?? 0;
	}
	
	/**
	 * Construction de la fonction JS pour l'expand/collapse
	 */
	public function get_js_sort_expandable_list() {
	    global $msg, $charset;
	    $display = "
			<div class='row'>
				<a href='javascript:expandAll(document.getElementById(\"modele_list_content\"))' title='".htmlentities($msg['expandall'], ENT_QUOTES, $charset)."'><img src='".get_url_icon('expand_all.gif')."' id='expandall'></a>
				<a href='javascript:collapseAll(document.getElementById(\"modele_list_content\"))' title='".htmlentities($msg['collapseall'], ENT_QUOTES, $charset)."'><img src='".get_url_icon('collapse_all.gif')."' id='collapseall'></a>
				".(!empty($this->expandable_title) ? $this->expandable_title : '')."
			</div>";
	    return $display;
	}
	
	protected function get_display_group_label($group_label, $counter=0) {
	    $group_label = parent::get_display_group_label($group_label, $counter);
	    return "
        <span class='notice-heada'>
        	<small>
        		<span  class='statutnot1'  style='margin-right: 3px;'>
        			<img src='".get_url_icon('spacer.gif')."' style='width:10px; height:10px' alt='' />
        		</span>
        	</small>
        	".$group_label."
        </span>";
	}
	
	/**
	 * Header de la liste
	 */
	public function get_display_header_list() {
	    return '';
	}
	
	/**
	 * Affichage des colonnes
	 * @param object $object
	 * @param string $property
	 */
	protected function get_display_cells($object) {
	    global $modele_view;
	    
	    $r = $modele_view;
	    $r = str_replace("!!num_periodicite!!", $this->_get_object_property_periodicite($object), $r);
	    $r = str_replace("!!duree_abonnement!!", $this->get_cell_content($object, 'duree_abonnement'), $r);
	    $r = str_replace("!!date_debut!!", $this->get_cell_content($object, 'date_debut'), $r);
	    $r = str_replace("!!date_fin!!", $this->get_cell_content($object, 'date_fin'), $r);
	    $r = str_replace("!!nombre_de_series!!", $this->_get_object_property_nombre_de_series($object), $r);
	    $r = str_replace("!!nombre_de_horsseries!!", $this->_get_object_property_nombre_de_horsseries($object), $r);
	    return $r;
	}
	
	/**
	 * Affichage de la liste des objets
	 * @return string
	 */
	public function get_display_objects_list() {
	    $display = "<script type='text/javascript' src='./javascript/tablist.js'></script>
        <div class='form-contenu' id='modele_list_content'>";
	    $display .= parent::get_display_objects_list();
	    $display .= "</div>";
	    return $display;
	    
	}
	
	protected function get_button_add() {
	    global $msg;
	    global $serial_id;
	    
	    return "<input type='button' class='bouton' value='".$msg["abts_modeles_add_button"]."' onClick='document.location=\"catalog.php?categ=serials&sub=modele&serial_id=$serial_id\"'/>";
	}
	
	protected function get_display_left_actions() {
	    return $this->get_button_add();
	}
	
	public function get_error_message_empty_list() {
	    global $msg;
	    
	    return $msg["abts_modeles_no_modele"];
	}
	
	public static function get_controller_url_base() {
	    global $base_path, $serial_id;
	    
	    return $base_path.'/catalog.php?categ=serials&sub=view&serial_id='.$serial_id.'&view=modele';
	}
}