<?php
// +-------------------------------------------------+
//  2002-2004 PMB Services / www.sigb.net pmb@sigb.net et contributeurs (voir www.sigb.net)
// +-------------------------------------------------+
// $Id: func_bdp19.inc.php,v 1.25 2022/04/25 14:43:37 dgoron Exp $

if (stristr($_SERVER['REQUEST_URI'], ".inc.php")) die("no access");

global $class_path;
require_once ($class_path."/import/import_expl_bdp.class.php");

// DEBUT paramtrage propre  la base de donnes d'importation :
$section_bdp19=array("BD adulte","Roman adulte","Roman policier adulte","Roman science fiction adulte",
"Documentaire adulte","Livre+CD adulte","Livre+K7 adulte","Large vision","Fond rgional","Revues",
"Album jeunes","BD jeunes","Contes jeunes","Roman jeune","Roman enfant","Documentaire jeune","Livre+CD jeune",
"Livre+K7 jeune","Diapositives","CD","Disque","K7","DVD","K7 Vido");

$corresp_bdp19=array(
	array("BD"),
	array("R"),
	array("RX"),
	array("RS"),
	array("79","91","1","2","3","4","5","6","7","8","9","B","0"),
	array("CDL6"),
	array("KL6"),
	array("G"),
	array("L"),
	array("PER"),
	array("EA"),
	array("JBD"),
	array("C"),
	array("E"),
	array("J"),
	array("J1","J2","J3","J4","J5","J6","J7","J8","J9","J79","J91","JB","J0"),
	array("CDL7"),
	array("KL7"),
	array("D"),
	array("CD"),
	array("M"),
	array("K"),
	array("DV"),
	array("V","F","VJ","FJ")
);

$sec_search_bdp19=array(
	"CDL6",
	"CDL7",
	"KL6",
	"PER",
	"JBD",
	"KL7",
	"J79",
	"J91",
	"BD",
	"RX",
	"RS",
	"79",
	"91",
	"EA",
	"J1",
	"J2",
	"J3",
	"J4",
	"J5",
	"J6",
	"J7",
	"J8",
	"J9",
	"JB",
	"J0",
	"CD",
	"DV",
	"VJ",
	"FJ",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
	"9",
	"0",
	"B",
	"R",
	"G",
	"L",
	"C",
	"E",
	"J",
	"D",
	"M",
	"K",
	"V",
	"F");
// 995 $r = type documents
// aucun : sont insrs en base de donnes avec les bons codages 995$r :
/*
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Imprims",15,15,"az");
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Disque vinyle",15,15,"jz"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("K7 audio",15,15,"jd"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("K7 lue",15,15,"ld"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Livre K7",15,15,"md"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("CD audio",15,15,"je"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("CD-lu",15,15,"ie"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Livre CD",15,15,"me"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("DVD audio",15,15,"jf"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("K7 vido",15,15,"gd"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("DVD-vido",15,15,"gf"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Affiches estampes",15,15,"ka");
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Cartes postales",15,15,"kb"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Diapositives - Icnes",15,15,"kc");
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("CD-Rom",15,15,"le"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("DVD-rom",15,15,"lf"); 
insert into docs_type (tdoc_libelle, duree_pret, duree_resa, tdoc_codage_import) values ("Exposition",15,15,"mz"); 
*/
// FIN paramtrage 

function recup_noticeunimarc_suite($notice) {
	} // fin recup_noticeunimarc_suite = fin rcupration des variables propres  la BDP02
	
function import_new_notice_suite() {
	global $notice_id ;
	
	global $index_sujets ;
	global $pmb_keyword_sep ;
	
	if (is_array($index_sujets)) $mots_cles = implode (" $pmb_keyword_sep ",$index_sujets);
		else $mots_cles = $index_sujets;
	
	$mots_cles .= import_records::get_mots_cles();
	
	$mots_cles ? $index_matieres = strip_empty_words($mots_cles) : $index_matieres = '';
	$rqt_maj = "update notices set index_l='".addslashes($mots_cles)."', index_matieres=' ".addslashes($index_matieres)." ' where notice_id='$notice_id' " ;
	pmb_mysql_query($rqt_maj);

} // fin import_new_notice_suite
			
// TRAITEMENT DES EXEMPLAIRES ICI
function traite_exemplaires () {
	global $nb_expl_ignores ;
	global $prix, $notice_id, $info_995, $typdoc_995, $tdoc_codage, $book_lender_id, 
		$section_bdp19, $sec_search_bdp19,$corresp_bdp19,$sdoc_codage, $book_statut_id, $locdoc_codage, $codstatdoc_995, $statisdoc_codage,
		$cote_mandatory, $book_location_id ;
		
	// lu en 010$d de la notice
	$price = $prix[0];
	
	$nb_infos_995 = count($info_995);
	// la zone 995 est rptable
	for ($nb_expl = 0; $nb_expl < $nb_infos_995; $nb_expl++) {
		/* RAZ expl */
		$expl = array();
		
		/* prparation du tableau  passer  la mthode */
		$expl['cb'] 	    = $info_995[$nb_expl]['f'];
		$expl['notice']     = $notice_id ;
		
		// $expl['typdoc']     = $info_995[$nb_expl]['r']; charg en base lors de l'installation, voir plus haut
		$data_doc=array();
		$data_doc['tdoc_libelle'] = "Libell cr ".$info_995[$nb_expl]['r'];
		$data_doc['duree_pret'] = 15 ; /* valeur par dfaut */
		$data_doc['tdoc_codage_import'] = $info_995[$nb_expl]['r'] ;
		if ($tdoc_codage) $data_doc['tdoc_owner'] = $book_lender_id ;
			else $data_doc['tdoc_owner'] = 0 ;
		$expl['typdoc'] = docs_type::import($data_doc);
		
		$expl['cote'] = $info_995[$nb_expl]['k'];
		
		// traitement des sections en fonction de la cote
		// cote[1] ?? G L ou U
		// -Non
		//		trouver le dbut de la cote dans le tableau
		//		crer la section si besoin
		// -Oui
		//		tronquer de cette premire lettre
		//		trouver le nouveau dbut dans le tableau
		//		remettre la premire lettre
		//		crer la section si besoin
		$car = (string)$info_995[$nb_expl]['k'][0];
		switch ($car) {
			case 'U':
				$prefix="" ;
				$suffixe_libelle="" ;
				$info_995[$nb_expl]['k']=substr((string)$info_995[$nb_expl]['k'],1);
				break;
			default:
				$prefix="" ;
				$suffixe_libelle="" ;
				break;
			}
		reset($sec_search_bdp19) ;
		$flag = 0 ;
		foreach ($sec_search_bdp19 as $cle_tab => $val_tab) {
			$p=strpos((string)$info_995[$nb_expl]['k'],(string)$val_tab) ;
			if (($p!==false) && ($p==0)) {
				$flag=1;
				break;
				}
			}
		if ($flag==1) {
			//Recherche de la section
			for ($i=0; $i<count($corresp_bdp19); $i++) {
				$as=array_search($val_tab,$corresp_bdp19[$i]);
				if (($as!==null)&&($as!==false)) {
					$codage_section_lu=$i+1;
					$libelle_section_lu=$section_bdp19[$i];
				}
			}
		} else {
				$codage_section_lu = "INCONNU" ;
				$libelle_section_lu = "Section inconnue" ;
				}
		
		
		// $expl['section']    = $info_995['8'];  chercher dans docs_section
		$data_doc=array();
		$data_doc['section_libelle'] = $libelle_section_lu;
		$data_doc['sdoc_codage_import'] = $codage_section_lu ;
		if ($sdoc_codage) $data_doc['sdoc_owner'] = $book_lender_id ;
			else $data_doc['sdoc_owner'] = 0 ;
		$expl['section'] = docs_section::import($data_doc);
		
		// le statut est choisi lors de l'import
		
		$expl['statut'] = $book_statut_id;
		
		$expl['location'] = $book_location_id;
		
		// $expl['codestat']   = $info_995[$nb_expl]['q']; 'q' utilis, ventuellement  fixer par combo_box
		$data_doc=array();
		//$data_doc['codestat_libelle'] = $info_995[$nb_expl]['q']." -Pub vis import (".$book_lender_id.")";
		$data_doc['codestat_libelle'] = $codstatdoc_995[$info_995[$nb_expl]['q']];
		$data_doc['statisdoc_codage_import'] = $info_995[$nb_expl]['q'] ;
		if ($statisdoc_codage) $data_doc['statisdoc_owner'] = $book_lender_id ;
			else $data_doc['statisdoc_owner'] = 0 ;
		$expl['codestat'] = docs_codestat::import($data_doc);
		
		// $expl['creation']   = $info_995[$nb_expl][''];  prciser
		// $expl['modif']      = $info_995[$nb_expl][''];  prciser
                      	
		$expl['note']       = $info_995[$nb_expl]['u'];
		$expl['prix']       = $price;
		$expl['expl_owner'] = $book_lender_id ;
		$expl['cote_mandatory'] = $cote_mandatory ;
		
		if (!empty($info_995[$nb_expl]['m'])) {
			$expl['date_depot'] = substr($info_995[$nb_expl]['m'],0,4)."-".substr($info_995[$nb_expl]['m'],4,2)."-".substr($info_995[$nb_expl]['m'],6,2) ;
		}
		if (!empty($info_995[$nb_expl]['n'])) {
			$expl['date_retour'] = substr($info_995[$nb_expl]['n'],0,4)."-".substr($info_995[$nb_expl]['n'],4,2)."-".substr($info_995[$nb_expl]['n'],6,2) ;
		}
		
		$expl_id = exemplaire::import($expl);
		if ($expl_id == 0) {
			$nb_expl_ignores++;
			}
                      	
		//debug : affichage zone 995 
		/*
		echo "995\$a =".$info_995[$nb_expl]['a']."<br />";
		echo "995\$b =".$info_995[$nb_expl]['b']."<br />";
		echo "995\$c =".$info_995[$nb_expl]['c']."<br />";
		echo "995\$d =".$info_995[$nb_expl]['d']."<br />";
		echo "995\$f =".$info_995[$nb_expl]['f']."<br />";
		echo "995\$k =".$info_995[$nb_expl]['k']."<br />";
		echo " section $codage_section_lu <br />";
		echo "995\$m =".$info_995[$nb_expl]['m']."<br />";
		echo "995\$n =".$info_995[$nb_expl]['n']."<br />";
		echo "995\$o =".$info_995[$nb_expl]['o']."<br />";
		echo "995\$q =".$info_995[$nb_expl]['q']."<br />";
		echo "995\$r =".$info_995[$nb_expl]['r']."<br />";
		echo "995\$u =".$info_995[$nb_expl]['u']."<br /><br />";
		*/
		} // fin for
	} // fin traite_exemplaires	TRAITEMENT DES EXEMPLAIRES JUSQU'ICI

// fonction spcifique d'export de la zone 995
function export_traite_exemplaires ($ex=array()) {
	global $opac_biblio_name ;
	
	$subfields = import_expl::export_traite_exemplaires($ex);
	
	$subfields["a"] = $opac_biblio_name;
	unset($subfields["c"]);
	
	if ($ex -> statisdoc_codage_import) {
		$subfields["q"] = $ex -> statisdoc_codage_import;
	} else {
		$subfields["q"] = "u";
	}
	return 	$subfields ;
}	